/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.tools;

import emu.grasscutter.Configuration;
import emu.grasscutter.Grasscutter;
import emu.grasscutter.tools.ToolsWithLanguageOption;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class Tools {
    public static void createGmHandbook() throws Exception {
        ToolsWithLanguageOption.createGmHandbook(Tools.getLanguageOption());
    }

    public static void createGachaMapping(String location) throws Exception {
        ToolsWithLanguageOption.createGachaMapping(location, Tools.getLanguageOption());
    }

    public static List<String> getAvailableLanguage() {
        File textMapFolder = new File(Configuration.RESOURCE("TextMap"));
        ArrayList<String> availableLangList = new ArrayList<String>();
        for (String textMapFileName : Objects.requireNonNull(textMapFolder.list((dir, name) -> name.startsWith("TextMap") && name.endsWith(".json")))) {
            availableLangList.add(textMapFileName.replace("TextMap", "").replace(".json", "").toLowerCase());
        }
        return availableLangList;
    }

    public static String getLanguageOption() {
        List<String> availableLangList = Tools.getAvailableLanguage();
        if (availableLangList.size() == 1) {
            return availableLangList.get(0).toUpperCase();
        }
        StringBuilder stagedMessage = new StringBuilder();
        stagedMessage.append("The following languages mappings are available, please select one: [default: EN] \n");
        StringBuilder groupedLangList = new StringBuilder(">\t");
        int groupedLangCount = 0;
        for (String availableLanguage : availableLangList) {
            groupedLangList.append(availableLanguage).append("\t");
            if (++groupedLangCount != 6) continue;
            stagedMessage.append((CharSequence)groupedLangList).append("\n");
            groupedLangCount = 0;
            groupedLangList = new StringBuilder(">\t");
        }
        if (groupedLangCount > 0) {
            stagedMessage.append((CharSequence)groupedLangList).append("\n");
        }
        stagedMessage.append("\nYour choice:[EN] ");
        String input = Grasscutter.getConsole().readLine(stagedMessage.toString());
        if (availableLangList.contains(input.toLowerCase())) {
            return input.toUpperCase();
        }
        Grasscutter.getLogger().info("Invalid option. Will use EN(English) as fallback");
        return "EN";
    }
}

