/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.server.packet.send;

import emu.grasscutter.game.entity.EntityVehicle;
import emu.grasscutter.game.entity.GameEntity;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.game.props.FightProperty;
import emu.grasscutter.net.packet.BasePacket;
import emu.grasscutter.net.proto.VehicleInteractTypeOuterClass;
import emu.grasscutter.net.proto.VehicleMemberOuterClass;
import emu.grasscutter.net.proto.VehicleSpawnRspOuterClass;
import emu.grasscutter.server.packet.send.PacketVehicleInteractRsp;
import emu.grasscutter.utils.Position;
import java.util.List;

public class PacketVehicleSpawnRsp
extends BasePacket {
    public PacketVehicleSpawnRsp(Player player, int vehicleId, int pointId, Position pos, Position rot) {
        super(865);
        VehicleSpawnRspOuterClass.VehicleSpawnRsp.Builder proto = VehicleSpawnRspOuterClass.VehicleSpawnRsp.newBuilder();
        List<GameEntity> previousVehicles = player.getScene().getEntities().values().stream().filter(entity -> entity instanceof EntityVehicle && ((EntityVehicle)entity).getGadgetId() == vehicleId && ((EntityVehicle)entity).getOwner().equals(player)).toList();
        previousVehicles.stream().forEach(entity -> {
            List vehicleMembers = ((EntityVehicle)entity).getVehicleMembers().stream().toList();
            vehicleMembers.stream().forEach(vehicleMember -> player.getScene().broadcastPacket(new PacketVehicleInteractRsp((EntityVehicle)entity, (VehicleMemberOuterClass.VehicleMember)vehicleMember, VehicleInteractTypeOuterClass.VehicleInteractType.VEHICLE_INTERACT_OUT)));
            player.getScene().killEntity((GameEntity)entity, 0);
        });
        EntityVehicle vehicle = new EntityVehicle(player.getScene(), player, vehicleId, pointId, pos, rot);
        switch (vehicleId) {
            case 45001001: 
            case 45001002: {
                vehicle.addFightProperty(FightProperty.FIGHT_PROP_BASE_HP, 10000.0f);
                vehicle.addFightProperty(FightProperty.FIGHT_PROP_BASE_ATTACK, 100.0f);
                vehicle.addFightProperty(FightProperty.FIGHT_PROP_CUR_ATTACK, 100.0f);
                vehicle.addFightProperty(FightProperty.FIGHT_PROP_CUR_HP, 10000.0f);
                vehicle.addFightProperty(FightProperty.FIGHT_PROP_CUR_DEFENSE, 0.0f);
                vehicle.addFightProperty(FightProperty.FIGHT_PROP_CUR_SPEED, 0.0f);
                vehicle.addFightProperty(FightProperty.FIGHT_PROP_CHARGE_EFFICIENCY, 0.0f);
                vehicle.addFightProperty(FightProperty.FIGHT_PROP_MAX_HP, 10000.0f);
                break;
            }
        }
        player.getScene().addEntity(vehicle);
        proto.setVehicleId(vehicleId);
        proto.setEntityId(vehicle.getId());
        this.setData(proto.build());
    }
}

