/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.server.packet.send;

import emu.grasscutter.game.player.Player;
import emu.grasscutter.game.props.EnterReason;
import emu.grasscutter.net.packet.BasePacket;
import emu.grasscutter.net.proto.EnterTypeOuterClass;
import emu.grasscutter.net.proto.PlayerEnterSceneNotifyOuterClass;
import emu.grasscutter.utils.Position;
import emu.grasscutter.utils.Utils;

public class PacketPlayerEnterSceneNotify
extends BasePacket {
    public PacketPlayerEnterSceneNotify(Player player) {
        super(260);
        player.setSceneLoadState(Player.SceneLoadState.LOADING);
        player.setEnterSceneToken(Utils.randomRange(1000, 99999));
        PlayerEnterSceneNotifyOuterClass.PlayerEnterSceneNotify proto = PlayerEnterSceneNotifyOuterClass.PlayerEnterSceneNotify.newBuilder().setSceneId(player.getSceneId()).setPos(player.getPos().toProto()).setSceneBeginTime(System.currentTimeMillis()).setType(EnterTypeOuterClass.EnterType.ENTER_SELF).setTargetUid(player.getUid()).setEnterSceneToken(player.getEnterSceneToken()).setWorldLevel(player.getWorldLevel()).setEnterReason(EnterReason.Login.getValue()).setIsFirstLoginEnterScene(player.isFirstLoginEnterScene()).setWorldType(1).setSceneTransaction("3-" + player.getUid() + "-" + (int)(System.currentTimeMillis() / 1000L) + "-18402").build();
        this.setData(proto);
    }

    public PacketPlayerEnterSceneNotify(Player player, EnterTypeOuterClass.EnterType type2, EnterReason reason, int newScene, Position newPos) {
        this(player, player, type2, reason, newScene, newPos);
    }

    public PacketPlayerEnterSceneNotify(Player player, Player target, EnterTypeOuterClass.EnterType type2, EnterReason reason, int newScene, Position newPos) {
        super(260);
        player.setEnterSceneToken(Utils.randomRange(1000, 99999));
        PlayerEnterSceneNotifyOuterClass.PlayerEnterSceneNotify proto = PlayerEnterSceneNotifyOuterClass.PlayerEnterSceneNotify.newBuilder().setPrevSceneId(player.getSceneId()).setPrevPos(player.getPos().toProto()).setSceneId(newScene).setPos(newPos.toProto()).setSceneBeginTime(System.currentTimeMillis()).setType(type2).setTargetUid(target.getUid()).setEnterSceneToken(player.getEnterSceneToken()).setWorldLevel(target.getWorld().getWorldLevel()).setEnterReason(reason.getValue()).addSceneTagIdList(102).addSceneTagIdList(107).addSceneTagIdList(109).addSceneTagIdList(113).addSceneTagIdList(117).setWorldType(1).setSceneTransaction(newScene + "-" + target.getUid() + "-" + (int)(System.currentTimeMillis() / 1000L) + "-18402").build();
        this.setData(proto);
    }
}

