/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.server.packet.send;

import emu.grasscutter.game.avatar.Avatar;
import emu.grasscutter.game.entity.GameEntity;
import emu.grasscutter.game.props.FightProperty;
import emu.grasscutter.game.props.LifeState;
import emu.grasscutter.net.packet.BasePacket;
import emu.grasscutter.net.proto.AvatarLifeStateChangeNotifyOuterClass;
import emu.grasscutter.net.proto.PlayerDieTypeOuterClass;

public class PacketAvatarLifeStateChangeNotify
extends BasePacket {
    public PacketAvatarLifeStateChangeNotify(Avatar avatar) {
        super(1245);
        AvatarLifeStateChangeNotifyOuterClass.AvatarLifeStateChangeNotify proto = AvatarLifeStateChangeNotifyOuterClass.AvatarLifeStateChangeNotify.newBuilder().setAvatarGuid(avatar.getGuid()).setLifeState(avatar.getFightProperty(FightProperty.FIGHT_PROP_CUR_HP) > 0.0f ? LifeState.LIFE_ALIVE.getValue() : LifeState.LIFE_DEAD.getValue()).build();
        this.setData(proto);
    }

    public PacketAvatarLifeStateChangeNotify(Avatar avatar, int attackerId, LifeState lifeState) {
        super(1245);
        AvatarLifeStateChangeNotifyOuterClass.AvatarLifeStateChangeNotify proto = AvatarLifeStateChangeNotifyOuterClass.AvatarLifeStateChangeNotify.newBuilder().setAvatarGuid(avatar.getGuid()).setLifeState(lifeState.getValue()).setMoveReliableSeq(attackerId).build();
        this.setData(proto);
    }

    public PacketAvatarLifeStateChangeNotify(Avatar avatar, LifeState lifeState, PlayerDieTypeOuterClass.PlayerDieType dieType) {
        this(avatar, lifeState, null, "", dieType);
    }

    public PacketAvatarLifeStateChangeNotify(Avatar avatar, LifeState lifeState, GameEntity sourceEntity, String attackTag, PlayerDieTypeOuterClass.PlayerDieType dieType) {
        super(1245);
        AvatarLifeStateChangeNotifyOuterClass.AvatarLifeStateChangeNotify.Builder proto = AvatarLifeStateChangeNotifyOuterClass.AvatarLifeStateChangeNotify.newBuilder();
        proto.setAvatarGuid(avatar.getGuid());
        proto.setLifeState(lifeState.getValue());
        if (sourceEntity != null) {
            proto.setSourceEntityId(sourceEntity.getId());
        }
        proto.setDieType(dieType);
        proto.setAttackTag(attackTag);
        this.setData(proto.build());
    }
}

