/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.server.packet.recv;

import emu.grasscutter.Grasscutter;
import emu.grasscutter.game.entity.GameEntity;
import emu.grasscutter.game.props.FightProperty;
import emu.grasscutter.net.packet.Opcodes;
import emu.grasscutter.net.packet.PacketHandler;
import emu.grasscutter.net.proto.CombatInvocationsNotifyOuterClass;
import emu.grasscutter.net.proto.CombatInvokeEntryOuterClass;
import emu.grasscutter.net.proto.EntityMoveInfoOuterClass;
import emu.grasscutter.net.proto.EvtBeingHitInfoOuterClass;
import emu.grasscutter.net.proto.MotionInfoOuterClass;
import emu.grasscutter.net.proto.MotionStateOuterClass;
import emu.grasscutter.net.proto.PlayerDieTypeOuterClass;
import emu.grasscutter.server.game.GameSession;
import emu.grasscutter.server.packet.send.PacketEntityFightPropUpdateNotify;

@Opcodes(value=347)
public class HandlerCombatInvocationsNotify
extends PacketHandler {
    private float cachedLandingSpeed = 0.0f;
    private long cachedLandingTimeMillisecond = 0L;
    private boolean monitorLandingEvent = false;

    @Override
    public void handle(GameSession session, byte[] header, byte[] payload) throws Exception {
        CombatInvocationsNotifyOuterClass.CombatInvocationsNotify notif = CombatInvocationsNotifyOuterClass.CombatInvocationsNotify.parseFrom(payload);
        for (CombatInvokeEntryOuterClass.CombatInvokeEntry entry : notif.getInvokeListList()) {
            switch (entry.getArgumentType()) {
                case COMBAT_EVT_BEING_HIT: {
                    EvtBeingHitInfoOuterClass.EvtBeingHitInfo hitInfo = EvtBeingHitInfoOuterClass.EvtBeingHitInfo.parseFrom(entry.getCombatData());
                    session.getPlayer().getAttackResults().add(hitInfo.getAttackResult());
                    break;
                }
                case ENTITY_MOVE: {
                    EntityMoveInfoOuterClass.EntityMoveInfo moveInfo = EntityMoveInfoOuterClass.EntityMoveInfo.parseFrom(entry.getCombatData());
                    GameEntity entity = session.getPlayer().getScene().getEntityById(moveInfo.getEntityId());
                    if (entity == null) break;
                    MotionInfoOuterClass.MotionInfo motionInfo = moveInfo.getMotionInfo();
                    entity.getPosition().set(motionInfo.getPos());
                    entity.getRotation().set(motionInfo.getRot());
                    entity.setLastMoveSceneTimeMs(moveInfo.getSceneTime());
                    entity.setLastMoveReliableSeq(moveInfo.getReliableSeq());
                    MotionStateOuterClass.MotionState motionState = motionInfo.getState();
                    entity.setMotionState(motionState);
                    session.getPlayer().getStaminaManager().handleCombatInvocationsNotify(session, moveInfo, entity);
                    if (motionState == MotionStateOuterClass.MotionState.MOTION_LAND_SPEED) {
                        this.cachedLandingSpeed = motionInfo.getSpeed().getY();
                        this.cachedLandingTimeMillisecond = System.currentTimeMillis();
                        this.monitorLandingEvent = true;
                    }
                    if (!this.monitorLandingEvent || motionState != MotionStateOuterClass.MotionState.MOTION_FALL_ON_GROUND) break;
                    this.monitorLandingEvent = false;
                    this.handleFallOnGround(session, entity, motionState);
                    break;
                }
            }
            session.getPlayer().getCombatInvokeHandler().addEntry(entry.getForwardType(), entry);
        }
    }

    private void handleFallOnGround(GameSession session, GameEntity entity, MotionStateOuterClass.MotionState motionState) {
        float damage;
        float newHP;
        if (session.getPlayer().inGodmode()) {
            return;
        }
        int maxDelay = 200;
        long actualDelay = System.currentTimeMillis() - this.cachedLandingTimeMillisecond;
        Grasscutter.getLogger().trace("MOTION_FALL_ON_GROUND received after " + actualDelay + "/" + maxDelay + "ms." + (actualDelay > (long)maxDelay ? " Discard" : ""));
        if (actualDelay > (long)maxDelay) {
            return;
        }
        float currentHP = entity.getFightProperty(FightProperty.FIGHT_PROP_CUR_HP);
        float maxHP = entity.getFightProperty(FightProperty.FIGHT_PROP_MAX_HP);
        float damageFactor = 0.0f;
        if ((double)this.cachedLandingSpeed < -23.5) {
            damageFactor = 0.33f;
        }
        if (this.cachedLandingSpeed < -25.0f) {
            damageFactor = 0.5f;
        }
        if ((double)this.cachedLandingSpeed < -26.5) {
            damageFactor = 0.66f;
        }
        if (this.cachedLandingSpeed < -28.0f) {
            damageFactor = 1.0f;
        }
        if ((newHP = currentHP - (damage = maxHP * damageFactor)) < 0.0f) {
            newHP = 0.0f;
        }
        if (damageFactor > 0.0f) {
            Grasscutter.getLogger().debug(currentHP + "/" + maxHP + "\tLandingSpeed: " + this.cachedLandingSpeed + "\tDamageFactor: " + damageFactor + "\tDamage: " + damage + "\tNewHP: " + newHP);
        } else {
            Grasscutter.getLogger().trace(currentHP + "/" + maxHP + "\tLandingSpeed: 0\tNo damage");
        }
        entity.setFightProperty(FightProperty.FIGHT_PROP_CUR_HP, newHP);
        entity.getWorld().broadcastPacket(new PacketEntityFightPropUpdateNotify(entity, FightProperty.FIGHT_PROP_CUR_HP));
        if (newHP == 0.0f) {
            session.getPlayer().getStaminaManager().killAvatar(session, entity, PlayerDieTypeOuterClass.PlayerDieType.PLAYER_DIE_FALL);
        }
        this.cachedLandingSpeed = 0.0f;
    }
}

