/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.server.packet.recv;

import emu.grasscutter.game.expedition.ExpeditionInfo;
import emu.grasscutter.game.expedition.ExpeditionRewardData;
import emu.grasscutter.game.expedition.ExpeditionRewardDataList;
import emu.grasscutter.game.inventory.GameItem;
import emu.grasscutter.game.props.ActionReason;
import emu.grasscutter.net.packet.Opcodes;
import emu.grasscutter.net.packet.PacketHandler;
import emu.grasscutter.net.proto.AvatarExpeditionGetRewardReqOuterClass;
import emu.grasscutter.server.game.GameSession;
import emu.grasscutter.server.packet.send.PacketAvatarExpeditionGetRewardRsp;
import emu.grasscutter.server.packet.send.PacketItemAddHintNotify;
import emu.grasscutter.utils.Utils;
import java.util.LinkedList;
import java.util.List;

@Opcodes(value=1604)
public class HandlerAvatarExpeditionGetRewardReq
extends PacketHandler {
    @Override
    public void handle(GameSession session, byte[] header, byte[] payload) throws Exception {
        AvatarExpeditionGetRewardReqOuterClass.AvatarExpeditionGetRewardReq req = AvatarExpeditionGetRewardReqOuterClass.AvatarExpeditionGetRewardReq.parseFrom(payload);
        ExpeditionInfo expInfo = session.getPlayer().getExpeditionInfo(req.getAvatarGuid());
        LinkedList<GameItem> items = new LinkedList<GameItem>();
        if (session.getServer().getExpeditionManager().getExpeditionRewardDataList().containsKey(expInfo.getExpId())) {
            for (ExpeditionRewardDataList RewardDataList : (List)session.getServer().getExpeditionManager().getExpeditionRewardDataList().get(expInfo.getExpId())) {
                if (RewardDataList.getHourTime() != expInfo.getHourTime() || RewardDataList.getExpeditionRewardData().isEmpty()) continue;
                for (ExpeditionRewardData RewardData2 : RewardDataList.getExpeditionRewardData()) {
                    int num = RewardData2.getMinCount();
                    if (RewardData2.getMinCount() != RewardData2.getMaxCount()) {
                        num = Utils.randomRange(RewardData2.getMinCount(), RewardData2.getMaxCount());
                    }
                    items.add(new GameItem(RewardData2.getItemId(), num));
                }
            }
        }
        session.getPlayer().getInventory().addItems(items);
        session.getPlayer().sendPacket(new PacketItemAddHintNotify(items, ActionReason.ExpeditionReward));
        session.getPlayer().removeExpeditionInfo(req.getAvatarGuid());
        session.getPlayer().save();
        session.send(new PacketAvatarExpeditionGetRewardRsp(session.getPlayer(), items));
    }
}

