/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.server.http.handlers;

import emu.grasscutter.Configuration;
import emu.grasscutter.Grasscutter;
import emu.grasscutter.database.DatabaseHelper;
import emu.grasscutter.game.Account;
import emu.grasscutter.game.gacha.GachaBanner;
import emu.grasscutter.game.gacha.GachaManager;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.server.http.Router;
import emu.grasscutter.tools.Tools;
import emu.grasscutter.utils.FileUtils;
import emu.grasscutter.utils.Language;
import emu.grasscutter.utils.Utils;
import express.Express;
import express.http.Request;
import express.http.Response;
import io.javalin.Javalin;
import io.javalin.http.staticfiles.Location;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashSet;

public final class GachaHandler
implements Router {
    private final String gachaMappings = Utils.toFilePath(Configuration.DATA("/gacha/mappings.js"));

    public GachaHandler() {
        if (!new File(this.gachaMappings).exists()) {
            try {
                Tools.createGachaMapping(this.gachaMappings);
            }
            catch (Exception exception) {
                Grasscutter.getLogger().warn("Failed to create gacha mappings.", exception);
            }
        }
    }

    @Override
    public void applyRoutes(Express express, Javalin handle2) {
        express.get("/gacha", GachaHandler::gachaRecords);
        express.get("/gacha/details", GachaHandler::gachaDetails);
        express.useStaticFallback("/gacha/mappings", this.gachaMappings, Location.EXTERNAL);
    }

    private static void gachaRecords(Request request, Response response) {
        File recordsTemplate = new File(Utils.toFilePath(Configuration.DATA("gacha/records.html")));
        if (!recordsTemplate.exists()) {
            Grasscutter.getLogger().warn("File does not exist: " + recordsTemplate);
            response.status(500);
            return;
        }
        String sessionKey = request.query("s");
        Account account = DatabaseHelper.getAccountBySessionKey(sessionKey);
        if (account == null) {
            response.status(403).send("Requested account was not found");
            return;
        }
        Player player = Grasscutter.getGameServer().getPlayerByUid(account.getPlayerUid());
        if (player == null) {
            response.status(403).send("No player associated with requested account");
            return;
        }
        int page = 0;
        int gachaType = 0;
        if (request.query("p") != null) {
            page = Integer.parseInt(request.query("p"));
        }
        if (request.query("gachaType") != null) {
            gachaType = Integer.parseInt(request.query("gachaType"));
        }
        String records = DatabaseHelper.getGachaRecords(player.getUid(), page, gachaType).toString();
        long maxPage = DatabaseHelper.getGachaRecordsMaxPage(player.getUid(), page, gachaType);
        String template = new String(FileUtils.read(recordsTemplate), StandardCharsets.UTF_8).replace("{{REPLACE_RECORDS}}", records).replace("{{REPLACE_MAXPAGE}}", String.valueOf(maxPage)).replace("{{LANGUAGE}}", Utils.getLanguageCode(account.getLocale()));
        response.send(template);
    }

    private static void gachaDetails(Request request, Response response) {
        File detailsTemplate = new File(Utils.toFilePath(Configuration.DATA("gacha/details.html")));
        if (!detailsTemplate.exists()) {
            Grasscutter.getLogger().warn("File does not exist: " + detailsTemplate);
            response.status(500);
            return;
        }
        String sessionKey = request.query("s");
        Account account = DatabaseHelper.getAccountBySessionKey(sessionKey);
        if (account == null) {
            response.status(403).send("Requested account was not found");
            return;
        }
        Player player = Grasscutter.getGameServer().getPlayerByUid(account.getPlayerUid());
        if (player == null) {
            response.status(403).send("No player associated with requested account");
            return;
        }
        String template = new String(FileUtils.read(detailsTemplate), StandardCharsets.UTF_8);
        template = template.replace("{{TITLE}}", Language.translate(player, "gacha.details.title", new Object[0])).replace("{{AVAILABLE_FIVE_STARS}}", Language.translate(player, "gacha.details.available_five_stars", new Object[0])).replace("{{AVAILABLE_FOUR_STARS}}", Language.translate(player, "gacha.details.available_four_stars", new Object[0])).replace("{{AVAILABLE_THREE_STARS}}", Language.translate(player, "gacha.details.available_three_stars", new Object[0])).replace("{{LANGUAGE}}", Utils.getLanguageCode(account.getLocale()));
        int gachaType = Integer.parseInt(request.query("gachaType"));
        GachaManager manager = Grasscutter.getGameServer().getGachaManager();
        GachaBanner banner = (GachaBanner)manager.getGachaBanners().get(gachaType);
        LinkedHashSet fiveStarItems = new LinkedHashSet();
        Arrays.stream(banner.getRateUpItems5()).forEach(i2 -> fiveStarItems.add(Integer.toString(i2)));
        Arrays.stream(banner.getFallbackItems5Pool1()).forEach(i2 -> fiveStarItems.add(Integer.toString(i2)));
        Arrays.stream(banner.getFallbackItems5Pool2()).forEach(i2 -> fiveStarItems.add(Integer.toString(i2)));
        template = template.replace("{{FIVE_STARS}}", "[" + String.join((CharSequence)",", fiveStarItems) + "]");
        LinkedHashSet fourStarItems = new LinkedHashSet();
        Arrays.stream(banner.getRateUpItems4()).forEach(i2 -> fourStarItems.add(Integer.toString(i2)));
        Arrays.stream(banner.getFallbackItems4Pool1()).forEach(i2 -> fourStarItems.add(Integer.toString(i2)));
        Arrays.stream(banner.getFallbackItems4Pool2()).forEach(i2 -> fourStarItems.add(Integer.toString(i2)));
        template = template.replace("{{FOUR_STARS}}", "[" + String.join((CharSequence)",", fourStarItems) + "]");
        LinkedHashSet threeStarItems = new LinkedHashSet();
        Arrays.stream(banner.getFallbackItems3()).forEach(i2 -> threeStarItems.add(Integer.toString(i2)));
        template = template.replace("{{THREE_STARS}}", "[" + String.join((CharSequence)",", threeStarItems) + "]");
        response.send(template);
    }
}

