/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.server.http.handlers;

import emu.grasscutter.Configuration;
import emu.grasscutter.Grasscutter;
import emu.grasscutter.server.http.Router;
import emu.grasscutter.server.http.objects.HttpJsonResponse;
import emu.grasscutter.utils.FileUtils;
import emu.grasscutter.utils.Utils;
import express.Express;
import express.http.MediaType;
import express.http.Request;
import express.http.Response;
import io.javalin.Javalin;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public final class AnnouncementsHandler
implements Router {
    @Override
    public void applyRoutes(Express express, Javalin handle2) {
        express.all("/common/hk4e_global/announcement/api/getAlertPic", new HttpJsonResponse("{\"retcode\":0,\"message\":\"OK\",\"data\":{\"total\":0,\"list\":[]}}"));
        express.all("/common/hk4e_global/announcement/api/getAlertAnn", new HttpJsonResponse("{\"retcode\":0,\"message\":\"OK\",\"data\":{\"alert\":false,\"alert_id\":0,\"remind\":true}}"));
        express.all("/common/hk4e_global/announcement/api/getAnnList", AnnouncementsHandler::getAnnouncement);
        express.all("/common/hk4e_global/announcement/api/getAnnContent", AnnouncementsHandler::getAnnouncement);
        express.all("/hk4e_global/mdk/shopwindow/shopwindow/listPriceTier", new HttpJsonResponse("{\"retcode\":0,\"message\":\"OK\",\"data\":{\"suggest_currency\":\"USD\",\"tiers\":[]}}"));
        express.get("/hk4e/announcement/*", AnnouncementsHandler::getPageResources);
    }

    private static void getAnnouncement(Request request, Response response) {
        String data = "";
        if (Objects.equals(request.baseUrl(), "/common/hk4e_global/announcement/api/getAnnContent")) {
            data = AnnouncementsHandler.readToString(new File(Utils.toFilePath(Configuration.DATA("GameAnnouncement.json"))));
        } else if (Objects.equals(request.baseUrl(), "/common/hk4e_global/announcement/api/getAnnList")) {
            data = AnnouncementsHandler.readToString(new File(Utils.toFilePath(Configuration.DATA("GameAnnouncementList.json"))));
        } else {
            response.send("{\"retcode\":404,\"message\":\"Unknown request path\"}");
        }
        if (data.isEmpty()) {
            response.send("{\"retcode\":500,\"message\":\"Unable to fetch requsted content\"}");
            return;
        }
        String dispatchDomain = "http" + (Configuration.HTTP_ENCRYPTION.useInRouting ? "s" : "") + "://" + Configuration.lr(Configuration.HTTP_INFO.accessAddress, Configuration.HTTP_INFO.bindAddress) + ":" + Configuration.lr(Configuration.HTTP_INFO.accessPort, Configuration.HTTP_INFO.bindPort);
        data = data.replace("{{DISPATCH_PUBLIC}}", dispatchDomain).replace("{{SYSTEM_TIME}}", String.valueOf(System.currentTimeMillis()));
        response.send("{\"retcode\":0,\"message\":\"OK\",\"data\": " + data + "}");
    }

    private static void getPageResources(Request request, Response response) {
        String filename = Utils.toFilePath(Configuration.DATA(request.path()));
        File file = new File(filename);
        if (file.exists() && file.isFile()) {
            MediaType fromExtension = MediaType.getByExtension(filename.substring(filename.lastIndexOf(".") + 1));
            response.type(fromExtension != null ? fromExtension.getMIME() : "application/octet-stream");
            response.send(FileUtils.read(file));
        } else {
            Grasscutter.getLogger().warn("File does not exist: " + file);
            response.status(404);
        }
    }

    private static String readToString(File file) {
        byte[] content = new byte[(int)file.length()];
        try {
            FileInputStream in = new FileInputStream(file);
            in.read(content);
            in.close();
        }
        catch (IOException ignored) {
            Grasscutter.getLogger().warn("File does not exist: " + file);
        }
        return new String(content, StandardCharsets.UTF_8);
    }
}

