/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.server.http.dispatch;

import com.google.protobuf.ByteString;
import emu.grasscutter.Configuration;
import emu.grasscutter.Grasscutter;
import emu.grasscutter.net.proto.QueryCurrRegionHttpRspOuterClass;
import emu.grasscutter.net.proto.QueryRegionListHttpRspOuterClass;
import emu.grasscutter.net.proto.RegionInfoOuterClass;
import emu.grasscutter.net.proto.RegionSimpleInfoOuterClass;
import emu.grasscutter.server.event.dispatch.QueryAllRegionsEvent;
import emu.grasscutter.server.event.dispatch.QueryCurrentRegionEvent;
import emu.grasscutter.server.http.Router;
import emu.grasscutter.utils.ConfigContainer;
import emu.grasscutter.utils.Crypto;
import emu.grasscutter.utils.Utils;
import express.Express;
import express.http.Request;
import express.http.Response;
import io.javalin.Javalin;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class RegionHandler
implements Router {
    private static final Map<String, RegionData> regions = new ConcurrentHashMap<String, RegionData>();
    private static String regionListResponse;

    public RegionHandler() {
        try {
            this.initialize();
        }
        catch (Exception exception) {
            Grasscutter.getLogger().error("Failed to initialize region data.", exception);
        }
    }

    private void initialize() {
        String dispatchDomain = "http" + (Configuration.HTTP_ENCRYPTION.useInRouting ? "s" : "") + "://" + Configuration.lr(Configuration.HTTP_INFO.accessAddress, Configuration.HTTP_INFO.bindAddress) + ":" + Configuration.lr(Configuration.HTTP_INFO.accessPort, Configuration.HTTP_INFO.bindPort);
        ArrayList servers = new ArrayList();
        ArrayList usedNames = new ArrayList();
        ArrayList<ConfigContainer.Region> configuredRegions = new ArrayList<ConfigContainer.Region>(List.of(Configuration.DISPATCH_INFO.regions));
        if (Configuration.SERVER.runMode != Grasscutter.ServerRunMode.HYBRID && configuredRegions.size() == 0) {
            Grasscutter.getLogger().error("[Dispatch] There are no game servers available. Exiting due to unplayable state.");
            System.exit(1);
        } else {
            configuredRegions.add(new ConfigContainer.Region("os_usa", Configuration.DISPATCH_INFO.defaultName, Configuration.lr(Configuration.GAME_INFO.accessAddress, Configuration.GAME_INFO.bindAddress), Configuration.lr(Configuration.GAME_INFO.accessPort, Configuration.GAME_INFO.bindPort)));
        }
        configuredRegions.forEach(region -> {
            if (usedNames.contains(region.Name)) {
                Grasscutter.getLogger().error("Region name already in use.");
                return;
            }
            RegionSimpleInfoOuterClass.RegionSimpleInfo identifier = RegionSimpleInfoOuterClass.RegionSimpleInfo.newBuilder().setName(region.Name).setTitle(region.Title).setType("DEV_PUBLIC").setDispatchUrl(dispatchDomain + "/query_cur_region/" + region.Name).build();
            usedNames.add(region.Name);
            servers.add(identifier);
            RegionInfoOuterClass.RegionInfo regionInfo = RegionInfoOuterClass.RegionInfo.newBuilder().setGateserverIp(region.Ip).setGateserverPort(region.Port).setSecretKey(ByteString.copyFrom(Crypto.DISPATCH_SEED)).build();
            QueryCurrRegionHttpRspOuterClass.QueryCurrRegionHttpRsp updatedQuery = QueryCurrRegionHttpRspOuterClass.QueryCurrRegionHttpRsp.newBuilder().setRegionInfo(regionInfo).build();
            regions.put(region.Name, new RegionData(updatedQuery, Utils.base64Encode(updatedQuery.toByteString().toByteArray())));
        });
        byte[] customConfig = "{\"sdkenv\":\"2\",\"checkdevice\":\"false\",\"loadPatch\":\"false\",\"showexception\":\"false\",\"regionConfig\":\"pm|fk|add\",\"downloadMode\":\"0\"}".getBytes();
        Crypto.xor(customConfig, Crypto.DISPATCH_KEY);
        QueryRegionListHttpRspOuterClass.QueryRegionListHttpRsp updatedRegionList = QueryRegionListHttpRspOuterClass.QueryRegionListHttpRsp.newBuilder().addAllRegionList(servers).setClientSecretKey(ByteString.copyFrom(Crypto.DISPATCH_SEED)).setClientCustomConfigEncrypted(ByteString.copyFrom(customConfig)).setEnableLoginPc(true).build();
        regionListResponse = Utils.base64Encode(updatedRegionList.toByteString().toByteArray());
    }

    @Override
    public void applyRoutes(Express express, Javalin handle2) {
        express.get("/query_region_list", RegionHandler::queryRegionList);
        express.get("/query_cur_region/:region", RegionHandler::queryCurrentRegion);
    }

    private static void queryRegionList(Request request, Response response) {
        QueryAllRegionsEvent event = new QueryAllRegionsEvent(regionListResponse);
        event.call();
        response.send(event.getRegionList());
        Grasscutter.getLogger().info(String.format("[Dispatch] Client %s request: query_region_list", request.ip()));
    }

    private static void queryCurrentRegion(Request request, Response response) {
        RegionData region;
        String regionName = request.params("region");
        String regionData = "CAESGE5vdCBGb3VuZCB2ZXJzaW9uIGNvbmZpZw==";
        if (request.query().values().size() > 0 && (region = regions.get(regionName)) != null) {
            regionData = region.getBase64();
        }
        QueryCurrentRegionEvent event = new QueryCurrentRegionEvent(regionData);
        event.call();
        response.send(event.getRegionInfo());
        Grasscutter.getLogger().info(String.format("Client %s request: query_cur_region/%s", request.ip(), regionName));
    }

    public static QueryCurrRegionHttpRspOuterClass.QueryCurrRegionHttpRsp getCurrentRegion() {
        return Configuration.SERVER.runMode == Grasscutter.ServerRunMode.HYBRID ? regions.get("os_usa").getRegionQuery() : null;
    }

    public static class RegionData {
        private final QueryCurrRegionHttpRspOuterClass.QueryCurrRegionHttpRsp regionQuery;
        private final String base64;

        public RegionData(QueryCurrRegionHttpRspOuterClass.QueryCurrRegionHttpRsp prq, String b64) {
            this.regionQuery = prq;
            this.base64 = b64;
        }

        public QueryCurrRegionHttpRspOuterClass.QueryCurrRegionHttpRsp getRegionQuery() {
            return this.regionQuery;
        }

        public String getBase64() {
            return this.base64;
        }
    }
}

