/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.server.http.dispatch;

import emu.grasscutter.Grasscutter;
import emu.grasscutter.auth.AuthenticationSystem;
import emu.grasscutter.server.http.Router;
import emu.grasscutter.server.http.objects.ComboTokenReqJson;
import emu.grasscutter.server.http.objects.ComboTokenResJson;
import emu.grasscutter.server.http.objects.LoginAccountRequestJson;
import emu.grasscutter.server.http.objects.LoginResultJson;
import emu.grasscutter.server.http.objects.LoginTokenRequestJson;
import emu.grasscutter.utils.Language;
import emu.grasscutter.utils.Utils;
import express.Express;
import express.http.Request;
import express.http.Response;
import io.javalin.Javalin;

public final class DispatchHandler
implements Router {
    @Override
    public void applyRoutes(Express express, Javalin handle2) {
        express.post("/hk4e_global/mdk/shield/api/login", DispatchHandler::clientLogin);
        express.post("/hk4e_global/mdk/shield/api/verify", DispatchHandler::tokenLogin);
        express.post("/hk4e_global/combo/granter/login/v2/login", DispatchHandler::sessionKeyLogin);
        express.get("/authentication/type", (request, response) -> response.send(Grasscutter.getAuthenticationSystem().getClass().getSimpleName()));
        express.post("/authentication/login", (request, response) -> Grasscutter.getAuthenticationSystem().getExternalAuthenticator().handleLogin(AuthenticationSystem.fromExternalRequest(request, response)));
        express.post("/authentication/register", (request, response) -> Grasscutter.getAuthenticationSystem().getExternalAuthenticator().handleAccountCreation(AuthenticationSystem.fromExternalRequest(request, response)));
        express.post("/authentication/change_password", (request, response) -> Grasscutter.getAuthenticationSystem().getExternalAuthenticator().handlePasswordReset(AuthenticationSystem.fromExternalRequest(request, response)));
    }

    private static void clientLogin(Request request, Response response) {
        String rawBodyData = request.ctx().body();
        LoginAccountRequestJson bodyData = Utils.jsonDecode(rawBodyData, LoginAccountRequestJson.class);
        if (bodyData == null) {
            return;
        }
        LoginResultJson responseData = Grasscutter.getAuthenticationSystem().getPasswordAuthenticator().authenticate(AuthenticationSystem.fromPasswordRequest(request, bodyData));
        response.send(responseData);
        Grasscutter.getLogger().info(Language.translate("messages.dispatch.account.login_attempt", request.ip()));
    }

    private static void tokenLogin(Request request, Response response) {
        String rawBodyData = request.ctx().body();
        LoginTokenRequestJson bodyData = Utils.jsonDecode(rawBodyData, LoginTokenRequestJson.class);
        if (bodyData == null) {
            return;
        }
        LoginResultJson responseData = Grasscutter.getAuthenticationSystem().getTokenAuthenticator().authenticate(AuthenticationSystem.fromTokenRequest(request, bodyData));
        response.send(responseData);
        Grasscutter.getLogger().info(Language.translate("messages.dispatch.account.login_attempt", request.ip()));
    }

    private static void sessionKeyLogin(Request request, Response response) {
        String rawBodyData = request.ctx().body();
        ComboTokenReqJson bodyData = Utils.jsonDecode(rawBodyData, ComboTokenReqJson.class);
        if (bodyData == null || bodyData.data == null) {
            return;
        }
        ComboTokenReqJson.LoginTokenData tokenData = Utils.jsonDecode(bodyData.data, ComboTokenReqJson.LoginTokenData.class);
        ComboTokenResJson responseData = Grasscutter.getAuthenticationSystem().getSessionKeyAuthenticator().authenticate(AuthenticationSystem.fromComboTokenRequest(request, bodyData, tokenData));
        response.send(responseData);
        Grasscutter.getLogger().info(Language.translate("messages.dispatch.account.login_attempt", request.ip()));
    }
}

