/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.scripts.service;

import emu.grasscutter.game.entity.EntityMonster;
import emu.grasscutter.scripts.SceneScriptManager;
import emu.grasscutter.scripts.data.SceneGroup;
import emu.grasscutter.scripts.data.SceneMonster;
import emu.grasscutter.scripts.data.ScriptArgs;
import emu.grasscutter.scripts.listener.ScriptMonsterListener;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class ScriptMonsterTideService {
    private final SceneScriptManager sceneScriptManager;
    private final SceneGroup currentGroup;
    private final AtomicInteger monsterAlive;
    private final AtomicInteger monsterTideCount;
    private final AtomicInteger monsterKillCount;
    private final int monsterSceneLimit;
    private final ConcurrentLinkedQueue<Integer> monsterConfigOrders;
    private final OnMonsterCreated onMonsterCreated = new OnMonsterCreated();
    private final OnMonsterDead onMonsterDead = new OnMonsterDead();

    public ScriptMonsterTideService(SceneScriptManager sceneScriptManager, SceneGroup group, int tideCount, int monsterSceneLimit, Integer[] ordersConfigId) {
        this.sceneScriptManager = sceneScriptManager;
        this.currentGroup = group;
        this.monsterSceneLimit = monsterSceneLimit;
        this.monsterTideCount = new AtomicInteger(tideCount);
        this.monsterKillCount = new AtomicInteger(0);
        this.monsterAlive = new AtomicInteger(0);
        this.monsterConfigOrders = new ConcurrentLinkedQueue<Integer>(List.of(ordersConfigId));
        this.sceneScriptManager.getScriptMonsterSpawnService().addMonsterCreatedListener(this.onMonsterCreated);
        this.sceneScriptManager.getScriptMonsterSpawnService().addMonsterDeadListener(this.onMonsterDead);
        for (int i2 = 0; i2 < this.monsterSceneLimit; ++i2) {
            this.sceneScriptManager.getScriptMonsterSpawnService().spawnMonster(group.id, this.getNextMonster());
        }
    }

    public SceneMonster getNextMonster() {
        Integer nextId = this.monsterConfigOrders.poll();
        if (this.currentGroup.monsters.containsKey(nextId)) {
            return this.currentGroup.monsters.get(nextId);
        }
        return this.currentGroup.monsters.values().stream().findFirst().orElse(null);
    }

    public void unload() {
        this.sceneScriptManager.getScriptMonsterSpawnService().removeMonsterCreatedListener(this.onMonsterCreated);
        this.sceneScriptManager.getScriptMonsterSpawnService().removeMonsterDeadListener(this.onMonsterDead);
    }

    public class OnMonsterCreated
    implements ScriptMonsterListener {
        @Override
        public void onNotify(EntityMonster sceneMonster) {
            if (ScriptMonsterTideService.this.monsterSceneLimit > 0) {
                ScriptMonsterTideService.this.monsterAlive.incrementAndGet();
                ScriptMonsterTideService.this.monsterTideCount.decrementAndGet();
            }
        }
    }

    public class OnMonsterDead
    implements ScriptMonsterListener {
        @Override
        public void onNotify(EntityMonster sceneMonster) {
            if (ScriptMonsterTideService.this.monsterSceneLimit <= 0) {
                return;
            }
            if (ScriptMonsterTideService.this.monsterAlive.decrementAndGet() >= ScriptMonsterTideService.this.monsterSceneLimit) {
                return;
            }
            ScriptMonsterTideService.this.monsterKillCount.incrementAndGet();
            if (ScriptMonsterTideService.this.monsterTideCount.get() > 0) {
                ScriptMonsterTideService.this.sceneScriptManager.getScriptMonsterSpawnService().spawnMonster(ScriptMonsterTideService.this.currentGroup.id, ScriptMonsterTideService.this.getNextMonster());
            }
            ScriptMonsterTideService.this.sceneScriptManager.callEvent(37, new ScriptArgs(ScriptMonsterTideService.this.monsterKillCount.get()));
        }
    }
}

