/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.scripts.service;

import emu.grasscutter.data.GameData;
import emu.grasscutter.data.def.MonsterData;
import emu.grasscutter.data.def.WorldLevelData;
import emu.grasscutter.game.entity.EntityMonster;
import emu.grasscutter.scripts.SceneScriptManager;
import emu.grasscutter.scripts.data.SceneMonster;
import emu.grasscutter.scripts.data.ScriptArgs;
import emu.grasscutter.scripts.listener.ScriptMonsterListener;
import java.util.ArrayList;
import java.util.List;

public class ScriptMonsterSpawnService {
    private final SceneScriptManager sceneScriptManager;
    private final List<ScriptMonsterListener> onMonsterCreatedListener = new ArrayList<ScriptMonsterListener>();
    private final List<ScriptMonsterListener> onMonsterDeadListener = new ArrayList<ScriptMonsterListener>();

    public ScriptMonsterSpawnService(SceneScriptManager sceneScriptManager) {
        this.sceneScriptManager = sceneScriptManager;
    }

    public void addMonsterCreatedListener(ScriptMonsterListener scriptMonsterListener) {
        this.onMonsterCreatedListener.add(scriptMonsterListener);
    }

    public void addMonsterDeadListener(ScriptMonsterListener scriptMonsterListener) {
        this.onMonsterDeadListener.add(scriptMonsterListener);
    }

    public void removeMonsterCreatedListener(ScriptMonsterListener scriptMonsterListener) {
        this.onMonsterCreatedListener.remove(scriptMonsterListener);
    }

    public void removeMonsterDeadListener(ScriptMonsterListener scriptMonsterListener) {
        this.onMonsterDeadListener.remove(scriptMonsterListener);
    }

    public void onMonsterDead(EntityMonster entityMonster) {
        this.onMonsterDeadListener.forEach(l -> l.onNotify(entityMonster));
    }

    public void spawnMonster(int groupId, SceneMonster monster) {
        WorldLevelData worldLevelData;
        if (monster == null) {
            return;
        }
        MonsterData data = (MonsterData)GameData.getMonsterDataMap().get(monster.monster_id);
        if (data == null) {
            return;
        }
        int level = monster.level;
        if (this.sceneScriptManager.getScene().getDungeonData() != null) {
            level = this.sceneScriptManager.getScene().getDungeonData().getShowLevel();
        } else if (this.sceneScriptManager.getScene().getWorld().getWorldLevel() > 0 && (worldLevelData = (WorldLevelData)GameData.getWorldLevelDataMap().get(this.sceneScriptManager.getScene().getWorld().getWorldLevel())) != null) {
            level = worldLevelData.getMonsterLevel();
        }
        EntityMonster entity = new EntityMonster(this.sceneScriptManager.getScene(), data, monster.pos, level);
        entity.getRotation().set(monster.rot);
        entity.setGroupId(groupId);
        entity.setConfigId(monster.config_id);
        this.onMonsterCreatedListener.forEach(action -> action.onNotify(entity));
        this.sceneScriptManager.getScene().addEntity(entity);
        this.sceneScriptManager.callEvent(11, new ScriptArgs(entity.getConfigId()));
    }
}

