/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.scripts;

import emu.grasscutter.Configuration;
import emu.grasscutter.Grasscutter;
import emu.grasscutter.game.entity.EntityGadget;
import emu.grasscutter.game.world.Scene;
import emu.grasscutter.scripts.ScriptLib;
import emu.grasscutter.scripts.ScriptLoader;
import emu.grasscutter.scripts.data.SceneBlock;
import emu.grasscutter.scripts.data.SceneConfig;
import emu.grasscutter.scripts.data.SceneGadget;
import emu.grasscutter.scripts.data.SceneGroup;
import emu.grasscutter.scripts.data.SceneInitConfig;
import emu.grasscutter.scripts.data.SceneMonster;
import emu.grasscutter.scripts.data.SceneRegion;
import emu.grasscutter.scripts.data.SceneSuite;
import emu.grasscutter.scripts.data.SceneTrigger;
import emu.grasscutter.scripts.data.SceneVar;
import emu.grasscutter.scripts.data.ScriptArgs;
import emu.grasscutter.scripts.service.ScriptMonsterSpawnService;
import emu.grasscutter.scripts.service.ScriptMonsterTideService;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptException;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;

public class SceneScriptManager {
    private final Scene scene;
    private final ScriptLib scriptLib;
    private final LuaValue scriptLibLua;
    private final Map<String, Integer> variables;
    private Bindings bindings;
    private SceneConfig config;
    private List<SceneBlock> blocks;
    private boolean isInit;
    private final Map<String, SceneTrigger> triggers;
    private final Int2ObjectOpenHashMap<Set<SceneTrigger>> currentTriggers;
    private final Int2ObjectOpenHashMap<SceneRegion> regions;
    private Map<Integer, SceneGroup> sceneGroups;
    private SceneGroup currentGroup;
    private ScriptMonsterTideService scriptMonsterTideService;
    private ScriptMonsterSpawnService scriptMonsterSpawnService;

    public SceneScriptManager(Scene scene) {
        this.scene = scene;
        this.scriptLib = new ScriptLib(this);
        this.scriptLibLua = CoerceJavaToLua.coerce(this.scriptLib);
        this.triggers = new HashMap<String, SceneTrigger>();
        this.currentTriggers = new Int2ObjectOpenHashMap();
        this.regions = new Int2ObjectOpenHashMap();
        this.variables = new HashMap<String, Integer>();
        this.sceneGroups = new HashMap<Integer, SceneGroup>();
        this.scriptMonsterSpawnService = new ScriptMonsterSpawnService(this);
        if (this.getScene().getId() < 10) {
            return;
        }
        this.init();
    }

    public Scene getScene() {
        return this.scene;
    }

    public ScriptLib getScriptLib() {
        return this.scriptLib;
    }

    public LuaValue getScriptLibLua() {
        return this.scriptLibLua;
    }

    public Bindings getBindings() {
        return this.bindings;
    }

    public SceneConfig getConfig() {
        return this.config;
    }

    public SceneGroup getCurrentGroup() {
        return this.currentGroup;
    }

    public List<SceneBlock> getBlocks() {
        return this.blocks;
    }

    public Map<String, Integer> getVariables() {
        return this.variables;
    }

    public Set<SceneTrigger> getTriggersByEvent(int eventId) {
        return this.currentTriggers.computeIfAbsent(eventId, e -> new HashSet());
    }

    public void registerTrigger(SceneTrigger trigger) {
        this.triggers.put(trigger.name, trigger);
        this.getTriggersByEvent(trigger.event).add(trigger);
    }

    public void deregisterTrigger(SceneTrigger trigger) {
        this.triggers.remove(trigger.name);
        this.getTriggersByEvent(trigger.event).remove(trigger);
    }

    public void resetTriggers(List<String> triggerNames) {
        for (String name : triggerNames) {
            SceneTrigger instance = this.triggers.get(name);
            this.currentTriggers.get(instance.event).clear();
            this.currentTriggers.get(instance.event).add(instance);
        }
    }

    public void refreshGroup(SceneGroup group, int suiteIndex) {
        SceneSuite suite = group.getSuiteByIndex(suiteIndex);
        if (suite == null) {
            return;
        }
        if (suite.triggers.size() > 0) {
            this.resetTriggers(suite.triggers);
        }
        this.spawnMonstersInGroup(group, suite);
        this.spawnGadgetsInGroup(group, suite);
    }

    public SceneRegion getRegionById(int id) {
        return this.regions.get(id);
    }

    public void registerRegion(SceneRegion region) {
        this.regions.put(region.config_id, region);
    }

    public void deregisterRegion(SceneRegion region) {
        this.regions.remove(region.config_id);
    }

    public SceneGroup getGroupById(int groupId) {
        for (SceneBlock block : this.getScene().getLoadedBlocks()) {
            for (SceneGroup group : block.groups) {
                if (group.id != groupId) continue;
                return group;
            }
        }
        return null;
    }

    private void init() {
        CompiledScript cs = ScriptLoader.getScriptByPath(Configuration.SCRIPT("Scene/" + this.getScene().getId() + "/scene" + this.getScene().getId() + "." + ScriptLoader.getScriptType()));
        if (cs == null) {
            Grasscutter.getLogger().warn("No script found for scene " + this.getScene().getId());
            return;
        }
        this.bindings = ScriptLoader.getEngine().createBindings();
        this.bindings.put("ScriptLib", (Object)this.getScriptLib());
        try {
            cs.eval(this.getBindings());
            this.config = ScriptLoader.getSerializer().toObject(SceneConfig.class, this.bindings.get("scene_config"));
            List<Integer> blockIds = ScriptLoader.getSerializer().toList(Integer.class, this.bindings.get("blocks"));
            List<SceneBlock> blocks = ScriptLoader.getSerializer().toList(SceneBlock.class, this.bindings.get("block_rects"));
            for (int i2 = 0; i2 < blocks.size(); ++i2) {
                SceneBlock block = blocks.get(i2);
                block.id = blockIds.get(i2);
                this.loadBlockFromScript(block);
            }
            this.blocks = blocks;
        }
        catch (ScriptException e) {
            Grasscutter.getLogger().error("Error running script", e);
            return;
        }
        this.isInit = true;
    }

    public boolean isInit() {
        return this.isInit;
    }

    private void loadBlockFromScript(SceneBlock block) {
        CompiledScript cs = ScriptLoader.getScriptByPath(Configuration.SCRIPT("Scene/" + this.getScene().getId() + "/scene" + this.getScene().getId() + "_block" + block.id + "." + ScriptLoader.getScriptType()));
        if (cs == null) {
            return;
        }
        try {
            cs.eval(this.getBindings());
            block.groups = ScriptLoader.getSerializer().toList(SceneGroup.class, this.bindings.get("groups"));
            block.groups.forEach(g2 -> {
                g2.block_id = block.id;
            });
        }
        catch (ScriptException e) {
            Grasscutter.getLogger().error("Error loading block " + block.id + " in scene " + this.getScene().getId(), e);
        }
    }

    public void loadGroupFromScript(SceneGroup group) {
        group.setLoaded(true);
        CompiledScript cs = ScriptLoader.getScriptByPath(Configuration.SCRIPTS_FOLDER + "Scene/" + this.getScene().getId() + "/scene" + this.getScene().getId() + "_group" + group.id + "." + ScriptLoader.getScriptType());
        if (cs == null) {
            return;
        }
        try {
            cs.eval(this.getBindings());
            group.monsters = ScriptLoader.getSerializer().toList(SceneMonster.class, this.bindings.get("monsters")).stream().collect(Collectors.toMap(x -> x.config_id, y -> y));
            group.gadgets = ScriptLoader.getSerializer().toList(SceneGadget.class, this.bindings.get("gadgets"));
            group.triggers = ScriptLoader.getSerializer().toList(SceneTrigger.class, this.bindings.get("triggers"));
            group.suites = ScriptLoader.getSerializer().toList(SceneSuite.class, this.bindings.get("suites"));
            group.regions = ScriptLoader.getSerializer().toList(SceneRegion.class, this.bindings.get("regions"));
            group.init_config = ScriptLoader.getSerializer().toObject(SceneInitConfig.class, this.bindings.get("init_config"));
            List<SceneVar> variables = ScriptLoader.getSerializer().toList(SceneVar.class, this.bindings.get("variables"));
            variables.forEach(var -> this.getVariables().put(var.name, var.value));
            Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
            group.monsters.entrySet().forEach(m3 -> map.put(((SceneMonster)m3.getValue()).config_id, m3));
            group.gadgets.forEach(m3 -> map.put(m3.config_id, m3));
            for (SceneSuite suite : group.suites) {
                suite.sceneMonsters = new ArrayList<SceneMonster>(suite.monsters.size());
                suite.monsters.forEach(id -> {
                    Map.Entry monsterEntry;
                    Object monster;
                    Object objEntry = map.get((int)id);
                    if (objEntry instanceof Map.Entry && (monster = (monsterEntry = (Map.Entry)objEntry).getValue()) instanceof SceneMonster) {
                        SceneMonster sceneMonster = (SceneMonster)monster;
                        suite.sceneMonsters.add(sceneMonster);
                    }
                });
                suite.sceneGadgets = new ArrayList<SceneGadget>(suite.gadgets.size());
                for (int id2 : suite.gadgets) {
                    try {
                        SceneGadget gadget = (SceneGadget)map.get(id2);
                        if (gadget == null) continue;
                        suite.sceneGadgets.add(gadget);
                    }
                    catch (Exception exception) {}
                }
            }
            this.sceneGroups.put(group.id, group);
        }
        catch (ScriptException e) {
            Grasscutter.getLogger().error("Error loading group " + group.id + " in scene " + this.getScene().getId(), e);
        }
    }

    public void onTick() {
        this.checkRegions();
    }

    public void checkRegions() {
        if (this.regions.size() == 0) {
            return;
        }
        for (SceneRegion region : this.regions.values()) {
            this.getScene().getEntities().values().stream().filter(e -> e.getEntityType() <= 2 && region.contains(e.getPosition())).forEach(region::addEntity);
            if (!region.hasNewEntities()) continue;
            this.callEvent(4, new ScriptArgs(region.config_id).setSourceEntityId(region.config_id));
            region.resetNewEntities();
        }
    }

    public void spawnGadgetsInGroup(SceneGroup group, int suiteIndex) {
        this.spawnGadgetsInGroup(group, group.getSuiteByIndex(suiteIndex));
    }

    public void spawnGadgetsInGroup(SceneGroup group) {
        this.spawnGadgetsInGroup(group, null);
    }

    public void spawnGadgetsInGroup(SceneGroup group, SceneSuite suite) {
        List<SceneGadget> gadgets = group.gadgets;
        if (suite != null) {
            gadgets = suite.sceneGadgets;
        }
        for (SceneGadget g2 : gadgets) {
            EntityGadget entity = new EntityGadget(this.getScene(), g2.gadget_id, g2.pos);
            if (entity.getGadgetData() == null) continue;
            entity.setBlockId(group.block_id);
            entity.setConfigId(g2.config_id);
            entity.setGroupId(group.id);
            entity.getRotation().set(g2.rot);
            entity.setState(g2.state);
            this.getScene().addEntity(entity);
            this.callEvent(6, new ScriptArgs(entity.getConfigId()));
        }
    }

    public void spawnMonstersInGroup(SceneGroup group, int suiteIndex) {
        SceneSuite suite = group.getSuiteByIndex(suiteIndex);
        if (suite == null) {
            return;
        }
        this.spawnMonstersInGroup(group, suite);
    }

    public void spawnMonstersInGroup(SceneGroup group, SceneSuite suite) {
        if (suite == null || suite.sceneMonsters.size() <= 0) {
            return;
        }
        this.currentGroup = group;
        suite.sceneMonsters.forEach(mob -> this.scriptMonsterSpawnService.spawnMonster(group.id, (SceneMonster)mob));
    }

    public void spawnMonstersInGroup(SceneGroup group) {
        this.currentGroup = group;
        group.monsters.values().forEach(mob -> this.scriptMonsterSpawnService.spawnMonster(group.id, (SceneMonster)mob));
    }

    public void startMonsterTideInGroup(SceneGroup group, Integer[] ordersConfigId, int tideCount, int sceneLimit) {
        this.currentGroup = group;
        this.scriptMonsterTideService = new ScriptMonsterTideService(this, group, tideCount, sceneLimit, ordersConfigId);
    }

    public void unloadCurrentMonsterTide() {
        if (this.getScriptMonsterTideService() == null) {
            return;
        }
        this.getScriptMonsterTideService().unload();
    }

    public void spawnMonstersByConfigId(int configId, int delayTime) {
        this.scriptMonsterSpawnService.spawnMonster(this.currentGroup.id, this.currentGroup.monsters.get(configId));
    }

    public void callEvent(int eventType, ScriptArgs params) {
        for (SceneTrigger trigger : this.getTriggersByEvent(eventType)) {
            LuaValue condition = null;
            if (trigger.condition != null && !trigger.condition.isEmpty()) {
                condition = (LuaValue)this.getBindings().get(trigger.condition);
            }
            LuaValue ret = LuaValue.TRUE;
            if (condition != null) {
                LuaValue args2 = LuaValue.NIL;
                if (params != null) {
                    args2 = CoerceJavaToLua.coerce(params);
                }
                ScriptLib.logger.trace("Call Condition Trigger {}", (Object)trigger);
                ret = this.safetyCall(trigger.condition, condition, args2);
            }
            if (!((LuaValue)ret).isboolean() || !((LuaValue)ret).checkboolean()) continue;
            ScriptLib.logger.trace("Call Action Trigger {}", (Object)trigger);
            LuaValue action = (LuaValue)this.getBindings().get(trigger.action);
            ScriptArgs arg = new ScriptArgs();
            arg.param2 = 100;
            LuaValue args3 = CoerceJavaToLua.coerce(arg);
            this.safetyCall(trigger.action, action, args3);
        }
    }

    public LuaValue safetyCall(String name, LuaValue func, LuaValue args2) {
        try {
            return func.call(this.getScriptLibLua(), args2);
        }
        catch (LuaError error2) {
            ScriptLib.logger.error("[LUA] call trigger failed {},{}", name, args2, error2);
            return LuaValue.valueOf(-1);
        }
    }

    public ScriptMonsterTideService getScriptMonsterTideService() {
        return this.scriptMonsterTideService;
    }

    public ScriptMonsterSpawnService getScriptMonsterSpawnService() {
        return this.scriptMonsterSpawnService;
    }
}

