/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.plugin;

import emu.grasscutter.Configuration;
import emu.grasscutter.Grasscutter;
import emu.grasscutter.plugin.Plugin;
import emu.grasscutter.plugin.PluginConfig;
import emu.grasscutter.plugin.PluginIdentifier;
import emu.grasscutter.server.event.Event;
import emu.grasscutter.server.event.EventHandler;
import emu.grasscutter.server.event.HandlerPriority;
import emu.grasscutter.utils.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class PluginManager {
    private final Map<String, Plugin> plugins = new HashMap<String, Plugin>();
    private final List<EventHandler<? extends Event>> listeners = new LinkedList<EventHandler<? extends Event>>();

    public PluginManager() {
        this.loadPlugins();
    }

    private void loadPlugins() {
        File pluginsDir = new File(Utils.toFilePath(Configuration.PLUGINS_FOLDER));
        if (!pluginsDir.exists() && !pluginsDir.mkdirs()) {
            Grasscutter.getLogger().error("Failed to create plugins directory: " + pluginsDir.getAbsolutePath());
            return;
        }
        File[] files = pluginsDir.listFiles();
        if (files == null) {
            return;
        }
        List<File> plugins = Arrays.stream(files).filter(file -> file.getName().endsWith(".jar")).toList();
        URL[] pluginNames = new URL[plugins.size()];
        plugins.forEach(plugin -> {
            try {
                pluginNames[plugins.indexOf((Object)plugin)] = plugin.toURI().toURL();
            }
            catch (MalformedURLException exception) {
                Grasscutter.getLogger().warn("Unable to load plugin.", exception);
            }
        });
        URLClassLoader classLoader = new URLClassLoader(pluginNames);
        plugins.forEach(plugin -> {
            try {
                URL url = plugin.toURI().toURL();
                try (URLClassLoader loader = new URLClassLoader(new URL[]{url});){
                    URL configFile = loader.findResource("plugin.json");
                    InputStreamReader fileReader = new InputStreamReader(configFile.openStream());
                    PluginConfig pluginConfig = Grasscutter.getGsonFactory().fromJson((Reader)fileReader, PluginConfig.class);
                    if (!pluginConfig.validate()) {
                        Utils.logObject(pluginConfig);
                        Grasscutter.getLogger().warn("Plugin " + plugin.getName() + " has an invalid config file.");
                        return;
                    }
                    JarFile jarFile = new JarFile((File)plugin);
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (entry.isDirectory() || !entry.getName().endsWith(".class") || entry.getName().contains("module-info")) continue;
                        String className = entry.getName().replace(".class", "").replace("/", ".");
                        classLoader.loadClass(className);
                    }
                    Class<?> pluginClass = classLoader.loadClass(pluginConfig.mainClass);
                    Plugin pluginInstance = (Plugin)pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    this.loadPlugin(pluginInstance, PluginIdentifier.fromPluginConfig(pluginConfig), loader);
                    fileReader.close();
                }
                catch (ClassNotFoundException ignored) {
                    Grasscutter.getLogger().warn("Plugin " + plugin.getName() + " has an invalid main class.");
                }
                catch (FileNotFoundException ignored) {
                    Grasscutter.getLogger().warn("Plugin " + plugin.getName() + " lacks a valid config file.");
                }
            }
            catch (Exception exception) {
                Grasscutter.getLogger().error("Failed to load plugin: " + plugin.getName(), exception);
            }
        });
    }

    private void loadPlugin(Plugin plugin, PluginIdentifier identifier, URLClassLoader classLoader) {
        Grasscutter.getLogger().info("Loading plugin: " + identifier.name);
        try {
            Class<Plugin> pluginClass = Plugin.class;
            Method method = pluginClass.getDeclaredMethod("initializePlugin", PluginIdentifier.class, URLClassLoader.class);
            method.setAccessible(true);
            method.invoke((Object)plugin, identifier, classLoader);
            method.setAccessible(false);
        }
        catch (Exception ignored) {
            Grasscutter.getLogger().warn("Failed to add plugin identifier: " + identifier.name);
        }
        this.plugins.put(identifier.name, plugin);
        plugin.onLoad();
    }

    public void enablePlugins() {
        this.plugins.forEach((name, plugin) -> {
            Grasscutter.getLogger().info("Enabling plugin: " + name);
            plugin.onEnable();
        });
    }

    public void disablePlugins() {
        this.plugins.forEach((name, plugin) -> {
            Grasscutter.getLogger().info("Disabling plugin: " + name);
            plugin.onDisable();
        });
    }

    public void registerListener(EventHandler<? extends Event> listener) {
        this.listeners.add(listener);
    }

    public void invokeEvent(Event event) {
        EnumSet.allOf(HandlerPriority.class).forEach(priority -> this.checkAndFilter(event, (HandlerPriority)((Object)priority)));
    }

    private void checkAndFilter(Event event, HandlerPriority priority) {
        this.listeners.stream().filter(handler -> handler.handles().isInstance(event)).filter(handler -> handler.getPriority() == priority).toList().forEach(handler -> this.invokeHandler(event, (EventHandler)handler));
    }

    public Plugin getPlugin(String name) {
        return this.plugins.get(name);
    }

    private <T extends Event> void invokeHandler(Event event, EventHandler<T> handler) {
        if (!event.isCanceled() || event.isCanceled() && handler.ignoresCanceled()) {
            handler.getCallback().consume(event);
        }
    }
}

