/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.net.packet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class PacketWriter {
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream(128);

    public byte[] build() {
        return this.baos.toByteArray();
    }

    public void writeEmpty(int i2) {
        while (i2 > 0) {
            this.baos.write(0);
            --i2;
        }
    }

    public void writeMax(int i2) {
        while (i2 > 0) {
            this.baos.write(255);
            --i2;
        }
    }

    public void writeInt8(byte b) {
        this.baos.write(b);
    }

    public void writeInt8(int i2) {
        this.baos.write((byte)i2);
    }

    public void writeBoolean(boolean b) {
        this.baos.write(b ? 1 : 0);
    }

    public void writeUint8(byte b) {
        this.baos.write(b & 0xFF);
    }

    public void writeUint8(int i2) {
        this.baos.write((byte)i2 & 0xFF);
    }

    public void writeUint16(int i2) {
        this.baos.write((byte)(i2 & 0xFF));
        this.baos.write((byte)(i2 >>> 8 & 0xFF));
    }

    public void writeUint24(int i2) {
        this.baos.write((byte)(i2 & 0xFF));
        this.baos.write((byte)(i2 >>> 8 & 0xFF));
        this.baos.write((byte)(i2 >>> 16 & 0xFF));
    }

    public void writeInt16(int i2) {
        this.baos.write((byte)i2);
        this.baos.write((byte)(i2 >>> 8));
    }

    public void writeUint32(int i2) {
        this.baos.write((byte)(i2 & 0xFF));
        this.baos.write((byte)(i2 >>> 8 & 0xFF));
        this.baos.write((byte)(i2 >>> 16 & 0xFF));
        this.baos.write((byte)(i2 >>> 24 & 0xFF));
    }

    public void writeInt32(int i2) {
        this.baos.write((byte)i2);
        this.baos.write((byte)(i2 >>> 8));
        this.baos.write((byte)(i2 >>> 16));
        this.baos.write((byte)(i2 >>> 24));
    }

    public void writeUint32(long i2) {
        this.baos.write((byte)(i2 & 0xFFL));
        this.baos.write((byte)(i2 >>> 8 & 0xFFL));
        this.baos.write((byte)(i2 >>> 16 & 0xFFL));
        this.baos.write((byte)(i2 >>> 24 & 0xFFL));
    }

    public void writeFloat(float f) {
        this.writeUint32(Float.floatToRawIntBits(f));
    }

    public void writeUint64(long l) {
        this.baos.write((byte)(l & 0xFFL));
        this.baos.write((byte)(l >>> 8 & 0xFFL));
        this.baos.write((byte)(l >>> 16 & 0xFFL));
        this.baos.write((byte)(l >>> 24 & 0xFFL));
        this.baos.write((byte)(l >>> 32 & 0xFFL));
        this.baos.write((byte)(l >>> 40 & 0xFFL));
        this.baos.write((byte)(l >>> 48 & 0xFFL));
        this.baos.write((byte)(l >>> 56 & 0xFFL));
    }

    public void writeDouble(double d) {
        long l = Double.doubleToLongBits(d);
        this.writeUint64(l);
    }

    public void writeString16(String s2) {
        if (s2 == null) {
            this.writeUint16(0);
            return;
        }
        this.writeUint16(s2.length() * 2);
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            char c = s2.charAt(i2);
            this.writeUint16((short)c);
        }
    }

    public void writeString8(String s2) {
        if (s2 == null) {
            this.writeUint16(0);
            return;
        }
        this.writeUint16(s2.length());
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            char c = s2.charAt(i2);
            this.writeUint8((byte)c);
        }
    }

    public void writeDirectString8(String s2, int expectedSize) {
        if (s2 == null) {
            return;
        }
        for (int i2 = 0; i2 < expectedSize; ++i2) {
            char c = i2 < s2.length() ? s2.charAt(i2) : (char)'\u0000';
            this.writeUint8((byte)c);
        }
    }

    public void writeBytes(byte[] bytes) {
        try {
            this.baos.write(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeBytes(int[] bytes) {
        byte[] b = new byte[bytes.length];
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            b[i2] = (byte)bytes[i2];
        }
        try {
            this.baos.write(b);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

