/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.world;

import emu.grasscutter.data.GameData;
import emu.grasscutter.data.def.DungeonData;
import emu.grasscutter.data.def.SceneData;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.game.props.EnterReason;
import emu.grasscutter.game.props.EntityIdType;
import emu.grasscutter.game.props.SceneType;
import emu.grasscutter.game.world.Scene;
import emu.grasscutter.net.packet.BasePacket;
import emu.grasscutter.net.proto.EnterTypeOuterClass;
import emu.grasscutter.scripts.data.SceneConfig;
import emu.grasscutter.server.game.GameServer;
import emu.grasscutter.server.packet.send.PacketDelTeamEntityNotify;
import emu.grasscutter.server.packet.send.PacketPlayerEnterSceneNotify;
import emu.grasscutter.server.packet.send.PacketScenePlayerInfoNotify;
import emu.grasscutter.server.packet.send.PacketSyncScenePlayTeamEntityNotify;
import emu.grasscutter.server.packet.send.PacketSyncTeamEntityNotify;
import emu.grasscutter.server.packet.send.PacketWorldPlayerInfoNotify;
import emu.grasscutter.server.packet.send.PacketWorldPlayerRTTNotify;
import emu.grasscutter.utils.Position;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class World
implements Iterable<Player> {
    private final GameServer server;
    private final Player owner;
    private final List<Player> players;
    private final Int2ObjectMap<Scene> scenes;
    private int levelEntityId;
    private int nextEntityId = 0;
    private int nextPeerId = 0;
    private int worldLevel;
    private boolean isMultiplayer;

    public World(Player player) {
        this(player, false);
    }

    public World(Player player, boolean isMultiplayer) {
        this.owner = player;
        this.server = player.getServer();
        this.players = Collections.synchronizedList(new ArrayList());
        this.scenes = Int2ObjectMaps.synchronize(new Int2ObjectOpenHashMap());
        this.levelEntityId = this.getNextEntityId(EntityIdType.MPLEVEL);
        this.worldLevel = player.getWorldLevel();
        this.isMultiplayer = isMultiplayer;
        this.owner.getServer().registerWorld(this);
    }

    public Player getHost() {
        return this.owner;
    }

    public GameServer getServer() {
        return this.server;
    }

    public int getLevelEntityId() {
        return this.levelEntityId;
    }

    public int getHostPeerId() {
        if (this.getHost() == null) {
            return 0;
        }
        return this.getHost().getPeerId();
    }

    public int getNextPeerId() {
        return ++this.nextPeerId;
    }

    public int getWorldLevel() {
        return this.worldLevel;
    }

    public void setWorldLevel(int worldLevel) {
        this.worldLevel = worldLevel;
    }

    public List<Player> getPlayers() {
        return this.players;
    }

    public Int2ObjectMap<Scene> getScenes() {
        return this.scenes;
    }

    public Scene getSceneById(int sceneId) {
        Scene scene = (Scene)this.getScenes().get(sceneId);
        if (scene != null) {
            return scene;
        }
        SceneData sceneData = (SceneData)GameData.getSceneDataMap().get(sceneId);
        if (sceneData != null) {
            scene = new Scene(this, sceneData);
            this.registerScene(scene);
            return scene;
        }
        return null;
    }

    public int getPlayerCount() {
        return this.getPlayers().size();
    }

    public boolean isMultiplayer() {
        return this.isMultiplayer;
    }

    public int getNextEntityId(EntityIdType idType) {
        return (idType.getId() << 24) + ++this.nextEntityId;
    }

    public synchronized void addPlayer(Player player) {
        if (this.getPlayers().contains(player)) {
            return;
        }
        if (player.getWorld() != null) {
            player.getWorld().removePlayer(player);
        }
        player.setWorld(this);
        this.getPlayers().add(player);
        player.setPeerId(this.getNextPeerId());
        player.getTeamManager().setEntityId(this.getNextEntityId(EntityIdType.TEAM));
        if (this.isMultiplayer()) {
            player.getTeamManager().getMpTeam().copyFrom(player.getTeamManager().getCurrentSinglePlayerTeamInfo(), player.getTeamManager().getMaxTeamSize());
            player.getTeamManager().setCurrentCharacterIndex(0);
        }
        Scene scene = this.getSceneById(player.getSceneId());
        scene.addPlayer(player);
        if (this.getPlayers().size() > 1) {
            this.updatePlayerInfos(player);
        }
    }

    public synchronized void removePlayer(Player player) {
        player.sendPacket(new PacketDelTeamEntityNotify(player.getSceneId(), this.getPlayers().stream().map(p -> p.getTeamManager().getEntityId()).collect(Collectors.toList())));
        this.getPlayers().remove(player);
        player.setWorld(null);
        Scene scene = this.getSceneById(player.getSceneId());
        scene.removePlayer(player);
        if (this.getPlayers().size() > 0) {
            this.updatePlayerInfos(player);
        }
        if (this.getHost() == player) {
            ArrayList<Player> kicked = new ArrayList<Player>(this.getPlayers());
            for (Player victim : kicked) {
                World world = new World(victim);
                world.addPlayer(victim);
                victim.sendPacket(new PacketPlayerEnterSceneNotify(victim, EnterTypeOuterClass.EnterType.ENTER_SELF, EnterReason.TeamKick, victim.getSceneId(), victim.getPos()));
            }
        }
    }

    public void registerScene(Scene scene) {
        this.getScenes().put(scene.getId(), scene);
    }

    public void deregisterScene(Scene scene) {
        this.getScenes().remove(scene.getId());
    }

    public boolean transferPlayerToScene(Player player, int sceneId, Position pos) {
        return this.transferPlayerToScene(player, sceneId, null, pos);
    }

    public boolean transferPlayerToScene(Player player, int sceneId, DungeonData data) {
        return this.transferPlayerToScene(player, sceneId, data, null);
    }

    public boolean transferPlayerToScene(Player player, int sceneId, DungeonData dungeonData, Position pos) {
        if (GameData.getSceneDataMap().get(sceneId) == null) {
            return false;
        }
        Scene oldScene = null;
        if (player.getScene() != null) {
            oldScene = player.getScene();
            if (oldScene.getId() == sceneId) {
                oldScene.setDontDestroyWhenEmpty(true);
            }
            oldScene.removePlayer(player);
        }
        Scene newScene = this.getSceneById(sceneId);
        newScene.setDungeonData(dungeonData);
        newScene.addPlayer(player);
        SceneConfig config = newScene.getScriptManager().getConfig();
        if (pos == null && config != null) {
            if (config.born_pos != null) {
                pos = newScene.getScriptManager().getConfig().born_pos;
            }
            if (config.born_rot != null) {
                player.getRotation().set(config.born_rot);
            }
        }
        if (pos == null) {
            pos = player.getPos();
        }
        player.getPos().set(pos);
        if (oldScene != null) {
            newScene.setPrevScene(oldScene.getId());
            oldScene.setDontDestroyWhenEmpty(false);
        }
        EnterTypeOuterClass.EnterType enterType = EnterTypeOuterClass.EnterType.ENTER_JUMP;
        EnterReason enterReason = EnterReason.TransPoint;
        if (dungeonData != null) {
            enterType = EnterTypeOuterClass.EnterType.ENTER_DUNGEON;
            enterReason = EnterReason.DungeonEnter;
        } else if (oldScene == newScene) {
            enterType = EnterTypeOuterClass.EnterType.ENTER_GOTO;
        } else if (newScene.getSceneType() == SceneType.SCENE_HOME_WORLD) {
            enterType = EnterTypeOuterClass.EnterType.ENTER_SELF_HOME;
        }
        player.sendPacket(new PacketPlayerEnterSceneNotify(player, enterType, enterReason, sceneId, pos));
        return true;
    }

    private void updatePlayerInfos(Player paramPlayer) {
        for (Player player : this.getPlayers()) {
            if (!player.hasSentAvatarDataNotify() || player.getSceneLoadState().getValue() < Player.SceneLoadState.INIT.getValue() || player == paramPlayer) continue;
            if (this.isMultiplayer()) {
                player.getTeamManager().getMpTeam().copyFrom(player.getTeamManager().getMpTeam(), player.getTeamManager().getMaxTeamSize());
                player.getTeamManager().updateTeamEntities(null);
            }
            player.getSession().send(new PacketWorldPlayerInfoNotify(this));
            player.getSession().send(new PacketScenePlayerInfoNotify(this));
            player.getSession().send(new PacketWorldPlayerRTTNotify(this));
            player.getSession().send(new PacketSyncTeamEntityNotify(player));
            player.getSession().send(new PacketSyncScenePlayTeamEntityNotify(player));
        }
    }

    public void broadcastPacket(BasePacket packet) {
        for (Player player : this.getPlayers()) {
            player.getSession().send(packet);
        }
    }

    public void onTick() {
        for (Scene scene : this.getScenes().values()) {
            scene.onTick();
        }
    }

    public void close() {
    }

    @Override
    public Iterator<Player> iterator() {
        return this.getPlayers().iterator();
    }
}

