/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.tower;

import emu.grasscutter.Configuration;
import emu.grasscutter.Grasscutter;
import emu.grasscutter.data.GameData;
import emu.grasscutter.data.def.TowerScheduleData;
import emu.grasscutter.game.tower.TowerScheduleConfig;
import emu.grasscutter.server.game.GameServer;
import java.io.FileReader;
import java.io.Reader;
import java.util.List;

public class TowerScheduleManager {
    private final GameServer gameServer;
    private TowerScheduleConfig towerScheduleConfig;

    public GameServer getGameServer() {
        return this.gameServer;
    }

    public TowerScheduleManager(GameServer gameServer) {
        this.gameServer = gameServer;
        this.load();
    }

    public synchronized void load() {
        try (FileReader fileReader = new FileReader(Configuration.DATA("TowerSchedule.json"));){
            this.towerScheduleConfig = Grasscutter.getGsonFactory().fromJson((Reader)fileReader, TowerScheduleConfig.class);
        }
        catch (Exception e) {
            Grasscutter.getLogger().error("Unable to load tower schedule config.", e);
        }
    }

    public TowerScheduleConfig getTowerScheduleConfig() {
        return this.towerScheduleConfig;
    }

    public TowerScheduleData getCurrentTowerScheduleData() {
        TowerScheduleData data = (TowerScheduleData)GameData.getTowerScheduleDataMap().get(this.towerScheduleConfig.getScheduleId());
        if (data == null) {
            Grasscutter.getLogger().error("Could not get current tower schedule data by schedule id {}, please check your resource files", (Object)this.towerScheduleConfig.getScheduleId());
        }
        return data;
    }

    public List<Integer> getScheduleFloors() {
        return this.getCurrentTowerScheduleData().getSchedules().get(0).getFloorList();
    }

    public int getNextFloorId(int floorId) {
        int i2;
        List<Integer> entranceFloors = this.getCurrentTowerScheduleData().getEntranceFloorId();
        List<Integer> scheduleFloors = this.getScheduleFloors();
        int nextId = 0;
        for (i2 = 0; i2 < entranceFloors.size() - 1; ++i2) {
            if (floorId != entranceFloors.get(i2)) continue;
            nextId = entranceFloors.get(i2 + 1);
        }
        if (floorId == entranceFloors.get(entranceFloors.size() - 1)) {
            nextId = scheduleFloors.get(0);
        }
        if (nextId != 0) {
            return nextId;
        }
        for (i2 = 0; i2 < scheduleFloors.size() - 1; ++i2) {
            if (floorId != scheduleFloors.get(i2)) continue;
            nextId = scheduleFloors.get(i2 + 1);
        }
        return nextId;
    }

    public Integer getLastEntranceFloor() {
        return this.getCurrentTowerScheduleData().getEntranceFloorId().get(this.getCurrentTowerScheduleData().getEntranceFloorId().size() - 1);
    }
}

