/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.tower;

import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Transient;
import emu.grasscutter.data.GameData;
import emu.grasscutter.data.def.TowerFloorData;
import emu.grasscutter.data.def.TowerLevelData;
import emu.grasscutter.game.dungeons.DungeonSettleListener;
import emu.grasscutter.game.dungeons.TowerDungeonSettleListener;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.game.tower.TowerLevelRecord;
import emu.grasscutter.server.packet.send.PacketCanUseSkillNotify;
import emu.grasscutter.server.packet.send.PacketTowerCurLevelRecordChangeNotify;
import emu.grasscutter.server.packet.send.PacketTowerEnterLevelRsp;
import emu.grasscutter.server.packet.send.PacketTowerLevelStarCondNotify;
import emu.grasscutter.server.packet.send.PacketTowerMiddleLevelChangeTeamNotify;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Entity
public class TowerManager {
    @Transient
    private Player player;
    private int currentFloorId;
    private int currentLevel;
    @Transient
    private int currentLevelId;
    private Map<Integer, TowerLevelRecord> recordMap;
    @Transient
    private int entryScene;
    private static final List<DungeonSettleListener> towerDungeonSettleListener = List.of(new TowerDungeonSettleListener());

    public TowerManager(Player player) {
        this.player = player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public int getCurrentFloorId() {
        return this.currentFloorId;
    }

    public int getCurrentLevelId() {
        return this.currentLevelId + this.currentLevel;
    }

    public int getCurrentLevel() {
        return this.currentLevel + 1;
    }

    public Map<Integer, TowerLevelRecord> getRecordMap() {
        if (this.recordMap == null) {
            this.recordMap = new HashMap<Integer, TowerLevelRecord>();
            this.recordMap.put(1001, new TowerLevelRecord(1001));
        }
        return this.recordMap;
    }

    public void teamSelect(int floor2, List<List<Long>> towerTeams) {
        TowerFloorData floorData = (TowerFloorData)GameData.getTowerFloorDataMap().get(floor2);
        this.currentFloorId = floorData.getFloorId();
        this.currentLevel = 0;
        this.currentLevelId = GameData.getTowerLevelDataMap().values().stream().filter(x -> x.getLevelId() == floorData.getLevelId() && x.getLevelIndex() == 1).findFirst().map(TowerLevelData::getID).orElse(0);
        if (this.entryScene == 0) {
            this.entryScene = this.player.getSceneId();
        }
        this.player.getTeamManager().setupTemporaryTeam(towerTeams);
    }

    public void enterLevel(int enterPointId) {
        TowerLevelData levelData = (TowerLevelData)GameData.getTowerLevelDataMap().get(this.getCurrentLevelId());
        int dungeonId = levelData.getDungeonId();
        this.notifyCurLevelRecordChange();
        this.player.getTeamManager().useTemporaryTeam(0);
        this.player.getServer().getDungeonManager().handoffDungeon(this.player, dungeonId, towerDungeonSettleListener);
        this.player.getScene().setPrevScene(this.entryScene);
        this.player.getScene().setPrevScenePoint(enterPointId);
        this.player.getSession().send(new PacketTowerEnterLevelRsp(this.currentFloorId, this.getCurrentLevel()));
        this.player.getSession().send(new PacketCanUseSkillNotify(false));
        this.player.getSession().send(new PacketTowerLevelStarCondNotify(this.currentFloorId, this.getCurrentLevel()));
    }

    public void notifyCurLevelRecordChange() {
        this.player.getSession().send(new PacketTowerCurLevelRecordChangeNotify(this.currentFloorId, this.getCurrentLevel()));
    }

    public void notifyCurLevelRecordChangeWhenDone(int stars) {
        if (!this.recordMap.containsKey(this.currentFloorId)) {
            this.recordMap.put(this.currentFloorId, new TowerLevelRecord(this.currentFloorId).setLevelStars(this.getCurrentLevelId(), stars));
        } else {
            this.recordMap.put(this.currentFloorId, this.recordMap.get(this.currentFloorId).setLevelStars(this.getCurrentLevelId(), stars));
        }
        ++this.currentLevel;
        if (!this.hasNextLevel()) {
            this.recordMap.putIfAbsent(this.getNextFloorId(), new TowerLevelRecord(this.getNextFloorId()));
            this.player.getSession().send(new PacketTowerCurLevelRecordChangeNotify(this.getNextFloorId(), 1));
        } else {
            this.player.getSession().send(new PacketTowerCurLevelRecordChangeNotify(this.currentFloorId, this.getCurrentLevel()));
        }
    }

    public boolean hasNextLevel() {
        return this.currentLevel < 3;
    }

    public int getNextFloorId() {
        return this.player.getServer().getTowerScheduleManager().getNextFloorId(this.currentFloorId);
    }

    public boolean hasNextFloor() {
        return this.player.getServer().getTowerScheduleManager().getNextFloorId(this.currentFloorId) > 0;
    }

    public void clearEntry() {
        this.entryScene = 0;
    }

    public boolean canEnterScheduleFloor() {
        if (!this.recordMap.containsKey(this.player.getServer().getTowerScheduleManager().getLastEntranceFloor())) {
            return false;
        }
        return this.recordMap.get(this.player.getServer().getTowerScheduleManager().getLastEntranceFloor()).getStarCount() >= 6;
    }

    public void mirrorTeamSetUp(int teamId) {
        this.player.getTeamManager().useTemporaryTeam(teamId);
        this.player.sendPacket(new PacketTowerMiddleLevelChangeTeamNotify());
    }
}

