/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.quest;

import emu.grasscutter.data.def.QuestData;
import emu.grasscutter.game.quest.GameQuest;
import emu.grasscutter.game.quest.QuestValue;
import emu.grasscutter.game.quest.handlers.QuestBaseHandler;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class ServerQuestHandler {
    private final Int2ObjectMap<QuestBaseHandler> condHandlers = new Int2ObjectOpenHashMap<QuestBaseHandler>();
    private final Int2ObjectMap<QuestBaseHandler> contHandlers = new Int2ObjectOpenHashMap<QuestBaseHandler>();
    private final Int2ObjectMap<QuestBaseHandler> execHandlers = new Int2ObjectOpenHashMap<QuestBaseHandler>();

    public ServerQuestHandler() {
        this.registerHandlers();
    }

    public void registerHandlers() {
        this.registerHandlers(this.condHandlers, "emu.grasscutter.game.quest.conditions");
        this.registerHandlers(this.contHandlers, "emu.grasscutter.game.quest.content");
        this.registerHandlers(this.execHandlers, "emu.grasscutter.game.quest.exec");
    }

    public void registerHandlers(Int2ObjectMap<QuestBaseHandler> map, String packageName) {
        Reflections reflections = new Reflections(packageName, new Scanner[0]);
        Set<Class<QuestBaseHandler>> handlerClasses = reflections.getSubTypesOf(QuestBaseHandler.class);
        for (Class<QuestBaseHandler> obj : handlerClasses) {
            this.registerPacketHandler(map, obj);
        }
    }

    public void registerPacketHandler(Int2ObjectMap<QuestBaseHandler> map, Class<? extends QuestBaseHandler> handlerClass) {
        try {
            QuestValue opcode = handlerClass.getAnnotation(QuestValue.class);
            if (opcode == null || opcode.value().getValue() <= 0) {
                return;
            }
            QuestBaseHandler packetHandler = handlerClass.newInstance();
            map.put(opcode.value().getValue(), packetHandler);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean triggerCondition(GameQuest quest, QuestData.QuestCondition condition, int ... params) {
        QuestBaseHandler handler = (QuestBaseHandler)this.condHandlers.get(condition.getType().getValue());
        if (handler == null || quest.getData() == null) {
            return false;
        }
        return handler.execute(quest, condition, params);
    }

    public boolean triggerContent(GameQuest quest, QuestData.QuestCondition condition, int ... params) {
        QuestBaseHandler handler = (QuestBaseHandler)this.contHandlers.get(condition.getType().getValue());
        if (handler == null || quest.getData() == null) {
            return false;
        }
        return handler.execute(quest, condition, params);
    }

    public boolean triggerExec(GameQuest quest, QuestData.QuestCondition condition, int ... params) {
        QuestBaseHandler handler = (QuestBaseHandler)this.execHandlers.get(condition.getType().getValue());
        if (handler == null || quest.getData() == null) {
            return false;
        }
        return handler.execute(quest, condition, params);
    }
}

