/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.quest;

import emu.grasscutter.data.GameData;
import emu.grasscutter.data.def.QuestData;
import emu.grasscutter.database.DatabaseHelper;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.game.quest.GameMainQuest;
import emu.grasscutter.game.quest.GameQuest;
import emu.grasscutter.game.quest.enums.LogicType;
import emu.grasscutter.game.quest.enums.QuestState;
import emu.grasscutter.game.quest.enums.QuestTrigger;
import emu.grasscutter.server.packet.send.PacketFinishedParentQuestUpdateNotify;
import emu.grasscutter.server.packet.send.PacketQuestListUpdateNotify;
import emu.grasscutter.server.packet.send.PacketQuestProgressUpdateNotify;
import emu.grasscutter.server.packet.send.PacketServerCondMeetQuestListUpdateNotify;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;

public class QuestManager {
    private final Player player;
    private final Int2ObjectMap<GameMainQuest> quests;

    public QuestManager(Player player) {
        this.player = player;
        this.quests = new Int2ObjectOpenHashMap<GameMainQuest>();
    }

    public Player getPlayer() {
        return this.player;
    }

    public Int2ObjectMap<GameMainQuest> getQuests() {
        return this.quests;
    }

    public GameMainQuest getMainQuestById(int mainQuestId) {
        return (GameMainQuest)this.getQuests().get(mainQuestId);
    }

    public GameQuest getQuestById(int questId) {
        QuestData questConfig = (QuestData)GameData.getQuestDataMap().get(questId);
        if (questConfig == null) {
            return null;
        }
        GameMainQuest mainQuest = (GameMainQuest)this.getQuests().get(questConfig.getMainId());
        if (mainQuest == null) {
            return null;
        }
        return mainQuest.getChildQuests().get(questId);
    }

    public void forEachQuest(Consumer<GameQuest> callback) {
        for (GameMainQuest mainQuest : this.getQuests().values()) {
            for (GameQuest quest : mainQuest.getChildQuests().values()) {
                callback.accept(quest);
            }
        }
    }

    public void forEachMainQuest(Consumer<GameMainQuest> callback) {
        for (GameMainQuest mainQuest : this.getQuests().values()) {
            callback.accept(mainQuest);
        }
    }

    public void forEachActiveQuest(Consumer<GameQuest> callback) {
        for (GameMainQuest mainQuest : this.getQuests().values()) {
            for (GameQuest quest : mainQuest.getChildQuests().values()) {
                if (quest.getState() == QuestState.QUEST_STATE_FINISHED) continue;
                callback.accept(quest);
            }
        }
    }

    public GameMainQuest addMainQuest(QuestData questConfig) {
        GameMainQuest mainQuest = new GameMainQuest(this.getPlayer(), questConfig.getMainId());
        this.getQuests().put(mainQuest.getParentQuestId(), mainQuest);
        this.getPlayer().sendPacket(new PacketFinishedParentQuestUpdateNotify(mainQuest));
        return mainQuest;
    }

    public GameQuest addQuest(int questId) {
        GameQuest quest;
        QuestData questConfig = (QuestData)GameData.getQuestDataMap().get(questId);
        if (questConfig == null) {
            return null;
        }
        GameMainQuest mainQuest = this.getMainQuestById(questConfig.getMainId());
        if (mainQuest == null) {
            mainQuest = this.addMainQuest(questConfig);
        }
        if ((quest = mainQuest.getChildQuestById(questId)) != null) {
            return null;
        }
        quest = new GameQuest(mainQuest, questConfig);
        mainQuest.save();
        this.getPlayer().sendPacket(new PacketServerCondMeetQuestListUpdateNotify(quest));
        this.getPlayer().sendPacket(new PacketQuestListUpdateNotify(quest));
        return quest;
    }

    public void triggerEvent(QuestTrigger condType, int ... params) {
        HashSet changedQuests = new HashSet();
        this.forEachActiveQuest(quest -> {
            QuestData data = quest.getData();
            for (int i2 = 0; i2 < data.getFinishCond().length; ++i2) {
                boolean result;
                QuestData.QuestCondition condition;
                if (quest.getFinishProgressList() == null || quest.getFinishProgressList()[i2] == 1 || (condition = data.getFinishCond()[i2]).getType() != condType || !(result = this.getPlayer().getServer().getQuestHandler().triggerContent((GameQuest)quest, condition, params))) continue;
                quest.getFinishProgressList()[i2] = 1;
                changedQuests.add(quest);
            }
        });
        for (GameQuest quest2 : changedQuests) {
            int[] progress;
            LogicType logicType = quest2.getData().getFailCondComb();
            boolean finish = LogicType.calculate(logicType, progress = quest2.getFinishProgressList());
            if (finish) {
                quest2.finish();
                continue;
            }
            this.getPlayer().sendPacket(new PacketQuestProgressUpdateNotify(quest2));
            quest2.save();
        }
    }

    public void loadFromDatabase() {
        List<GameMainQuest> quests = DatabaseHelper.getAllQuests(this.getPlayer());
        for (GameMainQuest mainQuest : quests) {
            mainQuest.setOwner(this.getPlayer());
            for (GameQuest quest : mainQuest.getChildQuests().values()) {
                quest.setMainQuest(mainQuest);
                quest.setConfig((QuestData)GameData.getQuestDataMap().get(quest.getQuestId()));
            }
            this.getQuests().put(mainQuest.getParentQuestId(), mainQuest);
        }
    }
}

