/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.managers;

import ch.qos.logback.classic.Logger;
import emu.grasscutter.Grasscutter;
import emu.grasscutter.game.entity.EntityAvatar;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.game.props.FightProperty;
import emu.grasscutter.game.props.PlayerProperty;
import emu.grasscutter.net.proto.ChangeHpReasonOuterClass;
import emu.grasscutter.net.proto.PropChangeReasonOuterClass;
import emu.grasscutter.server.packet.send.PacketEntityFightPropChangeReasonNotify;
import emu.grasscutter.server.packet.send.PacketEntityFightPropUpdateNotify;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class SotSManager {
    private final Player player;
    private final Logger logger = Grasscutter.getLogger();
    private Timer autoRecoverTimer;
    private final boolean enablePriorityHealing = false;
    public static final int GlobalMaximumSpringVolume = 8500000;

    public SotSManager(Player player) {
        this.player = player;
    }

    public boolean getIsAutoRecoveryEnabled() {
        return this.player.getProperty(PlayerProperty.PROP_IS_SPRING_AUTO_USE) == 1;
    }

    public void setIsAutoRecoveryEnabled(boolean enabled) {
        this.player.setProperty(PlayerProperty.PROP_IS_SPRING_AUTO_USE, enabled ? 1 : 0);
        this.player.save();
    }

    public int getAutoRecoveryPercentage() {
        return this.player.getProperty(PlayerProperty.PROP_SPRING_AUTO_USE_PERCENT);
    }

    public void setAutoRecoveryPercentage(int percentage) {
        this.player.setProperty(PlayerProperty.PROP_SPRING_AUTO_USE_PERCENT, percentage);
        this.player.save();
    }

    public long getLastUsed() {
        return this.player.getSpringLastUsed();
    }

    public void setLastUsed() {
        this.player.setSpringLastUsed(System.currentTimeMillis() / 1000L);
        this.player.save();
    }

    public int getMaxVolume() {
        return this.player.getProperty(PlayerProperty.PROP_MAX_SPRING_VOLUME);
    }

    public void setMaxVolume(int volume) {
        this.player.setProperty(PlayerProperty.PROP_MAX_SPRING_VOLUME, volume);
        this.player.save();
    }

    public int getCurrentVolume() {
        return this.player.getProperty(PlayerProperty.PROP_CUR_SPRING_VOLUME);
    }

    public void setCurrentVolume(int volume) {
        this.player.setProperty(PlayerProperty.PROP_CUR_SPRING_VOLUME, volume);
        this.setLastUsed();
        this.player.save();
    }

    public void handleEnterTransPointRegionNotify() {
        this.logger.trace("Player entered statue region");
        this.autoRevive();
        if (this.autoRecoverTimer == null) {
            this.autoRecoverTimer = new Timer();
            this.autoRecoverTimer.schedule((TimerTask)new AutoRecoverTimerTick(), 2500L, 15000L);
        }
    }

    public void handleExitTransPointRegionNotify() {
        this.logger.trace("Player left statue region");
        if (this.autoRecoverTimer != null) {
            this.autoRecoverTimer.cancel();
            this.autoRecoverTimer = null;
        }
    }

    public void autoRevive() {
        this.player.getTeamManager().getActiveTeam().forEach(entity -> {
            boolean isAlive = entity.isAlive();
            if (isAlive) {
                return;
            }
            this.logger.trace("Reviving avatar " + entity.getAvatar().getAvatarData().getName());
            this.player.getTeamManager().reviveAvatar(entity.getAvatar());
            this.player.getTeamManager().healAvatar(entity.getAvatar(), 30, 0);
        });
    }

    public void checkAndHealAvatar(EntityAvatar entity) {
        int maxHP = (int)(entity.getFightProperty(FightProperty.FIGHT_PROP_MAX_HP) * 100.0f);
        int currentHP = (int)(entity.getFightProperty(FightProperty.FIGHT_PROP_CUR_HP) * 100.0f);
        if (currentHP == maxHP) {
            return;
        }
        int targetHP = maxHP * this.getAutoRecoveryPercentage() / 100;
        if (targetHP > currentHP) {
            int needHP = targetHP - currentHP;
            int currentVolume = this.getCurrentVolume();
            if (currentVolume >= needHP) {
                this.setCurrentVolume(currentVolume - needHP);
            } else {
                needHP = currentVolume;
                this.setCurrentVolume(0);
            }
            if (needHP > 0) {
                this.logger.trace("Healing avatar " + entity.getAvatar().getAvatarData().getName() + " +" + needHP);
                this.player.getTeamManager().healAvatar(entity.getAvatar(), 0, needHP);
                this.player.getSession().send(new PacketEntityFightPropChangeReasonNotify(entity, FightProperty.FIGHT_PROP_CUR_HP, Float.valueOf((float)needHP / 100.0f), List.of(Integer.valueOf(3)), PropChangeReasonOuterClass.PropChangeReason.PROP_CHANGE_STATUE_RECOVER, ChangeHpReasonOuterClass.ChangeHpReason.ChangeHpAddStatue));
                this.player.getSession().send(new PacketEntityFightPropUpdateNotify(entity, FightProperty.FIGHT_PROP_CUR_HP));
            }
        }
    }

    public void refillSpringVolume() {
        this.setMaxVolume(8500000);
        this.setAutoRecoveryPercentage(100);
        this.setIsAutoRecoveryEnabled(true);
        int maxVolume = this.getMaxVolume();
        int currentVolume = this.getCurrentVolume();
        if (currentVolume < maxVolume) {
            long now = System.currentTimeMillis() / 1000L;
            int secondsSinceLastUsed = (int)(now - this.getLastUsed());
            int volumeRefilled = secondsSinceLastUsed * maxVolume / 15 / 100;
            this.logger.trace("Statue has refilled HP volume: " + volumeRefilled);
            currentVolume = Math.min(currentVolume + volumeRefilled, maxVolume);
            this.logger.trace("Statue remaining HP volume: " + currentVolume);
            this.setCurrentVolume(currentVolume);
        }
    }

    private class AutoRecoverTimerTick
    extends TimerTask {
        private AutoRecoverTimerTick() {
        }

        @Override
        public void run() {
            SotSManager.this.refillSpringVolume();
            SotSManager.this.logger.trace("isAutoRecoveryEnabled: " + SotSManager.this.getIsAutoRecoveryEnabled() + "\tautoRecoverPercentage: " + SotSManager.this.getAutoRecoveryPercentage());
            if (SotSManager.this.getIsAutoRecoveryEnabled()) {
                List<EntityAvatar> activeTeam = SotSManager.this.player.getTeamManager().getActiveTeam();
                int priorityIndex = -1;
                if (priorityIndex >= 0) {
                    SotSManager.this.checkAndHealAvatar(activeTeam.get(priorityIndex));
                }
                for (int i2 = 0; i2 < activeTeam.size(); ++i2) {
                    if (i2 == priorityIndex) continue;
                    SotSManager.this.checkAndHealAvatar(activeTeam.get(i2));
                }
            }
        }
    }
}

