/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.managers;

import emu.grasscutter.game.CoopRequest;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.game.props.EnterReason;
import emu.grasscutter.game.world.World;
import emu.grasscutter.net.proto.EnterTypeOuterClass;
import emu.grasscutter.net.proto.PlayerApplyEnterMpResultNotifyOuterClass;
import emu.grasscutter.server.game.GameServer;
import emu.grasscutter.server.packet.send.PacketPlayerApplyEnterMpNotify;
import emu.grasscutter.server.packet.send.PacketPlayerApplyEnterMpResultNotify;
import emu.grasscutter.server.packet.send.PacketPlayerEnterSceneNotify;

public class MultiplayerManager {
    private final GameServer server;

    public MultiplayerManager(GameServer server) {
        this.server = server;
    }

    public GameServer getServer() {
        return this.server;
    }

    public void applyEnterMp(Player player, int targetUid) {
        Player target = this.getServer().getPlayerByUid(targetUid);
        if (target == null) {
            player.sendPacket(new PacketPlayerApplyEnterMpResultNotify(targetUid, "", false, PlayerApplyEnterMpResultNotifyOuterClass.PlayerApplyEnterMpResultNotify.Reason.PLAYER_CANNOT_ENTER_MP));
            return;
        }
        if (player.getWorld().isMultiplayer()) {
            return;
        }
        CoopRequest request = (CoopRequest)target.getCoopRequests().get(player.getUid());
        if (request != null && !request.isExpired()) {
            return;
        }
        request = new CoopRequest(player);
        target.getCoopRequests().put(player.getUid(), request);
        target.sendPacket(new PacketPlayerApplyEnterMpNotify(player));
    }

    public void applyEnterMpReply(Player hostPlayer, int applyUid, boolean isAgreed) {
        CoopRequest request = (CoopRequest)hostPlayer.getCoopRequests().get(applyUid);
        if (request == null || request.isExpired()) {
            return;
        }
        Player requester = request.getRequester();
        hostPlayer.getCoopRequests().remove(applyUid);
        if (requester.getWorld().isMultiplayer()) {
            request.getRequester().sendPacket(new PacketPlayerApplyEnterMpResultNotify(hostPlayer, false, PlayerApplyEnterMpResultNotifyOuterClass.PlayerApplyEnterMpResultNotify.Reason.PLAYER_CANNOT_ENTER_MP));
            return;
        }
        request.getRequester().sendPacket(new PacketPlayerApplyEnterMpResultNotify(hostPlayer, isAgreed, PlayerApplyEnterMpResultNotifyOuterClass.PlayerApplyEnterMpResultNotify.Reason.PLAYER_JUDGE));
        if (!isAgreed) {
            return;
        }
        if (!hostPlayer.getWorld().isMultiplayer()) {
            World world = new World(hostPlayer, true);
            world.addPlayer(hostPlayer);
            hostPlayer.sendPacket(new PacketPlayerEnterSceneNotify(hostPlayer, hostPlayer, EnterTypeOuterClass.EnterType.ENTER_SELF, EnterReason.HostFromSingleToMp, hostPlayer.getScene().getId(), hostPlayer.getPos()));
        }
        requester.getPos().set(hostPlayer.getPos());
        requester.getRotation().set(hostPlayer.getRotation());
        requester.setSceneId(hostPlayer.getSceneId());
        hostPlayer.getWorld().addPlayer(requester);
        requester.sendPacket(new PacketPlayerEnterSceneNotify(requester, hostPlayer, EnterTypeOuterClass.EnterType.ENTER_OTHER, EnterReason.TeamJoin, hostPlayer.getScene().getId(), hostPlayer.getPos()));
    }

    public boolean leaveCoop(Player player) {
        if (!player.getWorld().isMultiplayer()) {
            return false;
        }
        for (Player p : player.getWorld().getPlayers()) {
            if (p.getSceneLoadState() == Player.SceneLoadState.LOADED) continue;
            return false;
        }
        World world = new World(player);
        world.addPlayer(player);
        player.sendPacket(new PacketPlayerEnterSceneNotify(player, EnterTypeOuterClass.EnterType.ENTER_SELF, EnterReason.TeamBack, player.getScene().getId(), player.getPos()));
        return true;
    }

    public boolean kickPlayer(Player player, int targetUid) {
        if (!player.getWorld().isMultiplayer() || player.getWorld().getHost() != player) {
            return false;
        }
        Player victim = player.getServer().getPlayerByUid(targetUid);
        if (victim == null || victim == player) {
            return false;
        }
        if (victim.getSceneLoadState() != Player.SceneLoadState.LOADED) {
            return false;
        }
        World world = new World(victim);
        world.addPlayer(victim);
        victim.sendPacket(new PacketPlayerEnterSceneNotify(victim, EnterTypeOuterClass.EnterType.ENTER_SELF, EnterReason.TeamKick, victim.getScene().getId(), victim.getPos()));
        return true;
    }
}

