/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.managers;

import emu.grasscutter.data.GameData;
import emu.grasscutter.data.common.ItemParamData;
import emu.grasscutter.data.custom.OpenConfigEntry;
import emu.grasscutter.data.def.AvatarPromoteData;
import emu.grasscutter.data.def.AvatarSkillData;
import emu.grasscutter.data.def.AvatarSkillDepotData;
import emu.grasscutter.data.def.AvatarTalentData;
import emu.grasscutter.data.def.ItemData;
import emu.grasscutter.data.def.ProudSkillData;
import emu.grasscutter.data.def.WeaponPromoteData;
import emu.grasscutter.game.avatar.Avatar;
import emu.grasscutter.game.inventory.GameItem;
import emu.grasscutter.game.inventory.ItemType;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.game.props.ActionReason;
import emu.grasscutter.game.shop.ShopChestBatchUseTable;
import emu.grasscutter.game.shop.ShopChestTable;
import emu.grasscutter.net.proto.ItemParamOuterClass;
import emu.grasscutter.net.proto.MaterialInfoOuterClass;
import emu.grasscutter.server.game.GameServer;
import emu.grasscutter.server.packet.send.PacketAvatarFetterDataNotify;
import emu.grasscutter.server.packet.send.PacketAvatarPromoteRsp;
import emu.grasscutter.server.packet.send.PacketAvatarPropNotify;
import emu.grasscutter.server.packet.send.PacketAvatarSkillChangeNotify;
import emu.grasscutter.server.packet.send.PacketAvatarSkillMaxChargeCountNotify;
import emu.grasscutter.server.packet.send.PacketAvatarSkillUpgradeRsp;
import emu.grasscutter.server.packet.send.PacketAvatarUnlockTalentNotify;
import emu.grasscutter.server.packet.send.PacketAvatarUpgradeRsp;
import emu.grasscutter.server.packet.send.PacketDestroyMaterialRsp;
import emu.grasscutter.server.packet.send.PacketProudSkillChangeNotify;
import emu.grasscutter.server.packet.send.PacketProudSkillExtraLevelNotify;
import emu.grasscutter.server.packet.send.PacketReliquaryUpgradeRsp;
import emu.grasscutter.server.packet.send.PacketSetEquipLockStateRsp;
import emu.grasscutter.server.packet.send.PacketStoreItemChangeNotify;
import emu.grasscutter.server.packet.send.PacketUnlockAvatarTalentRsp;
import emu.grasscutter.server.packet.send.PacketWeaponAwakenRsp;
import emu.grasscutter.server.packet.send.PacketWeaponPromoteRsp;
import emu.grasscutter.server.packet.send.PacketWeaponUpgradeRsp;
import emu.grasscutter.utils.Utils;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class InventoryManager {
    private final GameServer server;
    private static final int RELIC_MATERIAL_1 = 105002;
    private static final int RELIC_MATERIAL_2 = 105003;
    private static final int RELIC_MATERIAL_EXP_1 = 2500;
    private static final int RELIC_MATERIAL_EXP_2 = 10000;
    private static final int WEAPON_ORE_1 = 104011;
    private static final int WEAPON_ORE_2 = 104012;
    private static final int WEAPON_ORE_3 = 104013;
    private static final int WEAPON_ORE_EXP_1 = 400;
    private static final int WEAPON_ORE_EXP_2 = 2000;
    private static final int WEAPON_ORE_EXP_3 = 10000;
    private static final int AVATAR_BOOK_1 = 104001;
    private static final int AVATAR_BOOK_2 = 104002;
    private static final int AVATAR_BOOK_3 = 104003;
    private static final int AVATAR_BOOK_EXP_1 = 1000;
    private static final int AVATAR_BOOK_EXP_2 = 5000;
    private static final int AVATAR_BOOK_EXP_3 = 20000;

    public InventoryManager(GameServer server) {
        this.server = server;
    }

    public GameServer getServer() {
        return this.server;
    }

    public void lockEquip(Player player, long targetEquipGuid, boolean isLocked) {
        GameItem equip = player.getInventory().getItemByGuid(targetEquipGuid);
        if (equip == null || !equip.getItemData().isEquip()) {
            return;
        }
        equip.setLocked(isLocked);
        equip.save();
        player.sendPacket(new PacketStoreItemChangeNotify(equip));
        player.sendPacket(new PacketSetEquipLockStateRsp(equip));
    }

    public void upgradeRelic(Player player, long targetGuid, List<Long> foodRelicList, List<ItemParamOuterClass.ItemParam> list) {
        int level;
        GameItem relic = player.getInventory().getItemByGuid(targetGuid);
        if (relic == null || relic.getItemType() != ItemType.ITEM_RELIQUARY) {
            return;
        }
        int moraCost = 0;
        int expGain = 0;
        ArrayList<GameItem> foodRelics = new ArrayList<GameItem>();
        for (long guid : foodRelicList) {
            GameItem food = player.getInventory().getItemByGuid(guid);
            if (food == null || !food.isDestroyable()) continue;
            moraCost += food.getItemData().getBaseConvExp();
            expGain += food.getItemData().getBaseConvExp();
            if (food.getTotalExp() > 0) {
                expGain += food.getTotalExp() * 4 / 5;
            }
            foodRelics.add(food);
        }
        ArrayList<ItemParamData> payList = new ArrayList<ItemParamData>();
        for (ItemParamOuterClass.ItemParam itemParam : list) {
            int amount = itemParam.getCount();
            int gain = amount * (switch (itemParam.getItemId()) {
                case 105002 -> 2500;
                case 105003 -> 10000;
                default -> 0;
            });
            expGain += gain;
            moraCost += gain;
            payList.add(new ItemParamData(itemParam.getItemId(), itemParam.getCount()));
        }
        if (expGain <= 0) {
            return;
        }
        payList.add(new ItemParamData(202, moraCost));
        if (!player.getInventory().payItems(payList.toArray(new ItemParamData[0]))) {
            return;
        }
        player.getInventory().removeItems(foodRelics);
        int rate = 1;
        int boost = Utils.randomRange(1, 100);
        if (boost == 100) {
            rate = 5;
        } else if (boost <= 9) {
            rate = 2;
        }
        expGain *= rate;
        int oldLevel = level = relic.getLevel();
        int exp2 = relic.getExp();
        int totalExp = relic.getTotalExp();
        int reqExp = GameData.getRelicExpRequired(relic.getItemData().getRankLevel(), level);
        int upgrades = 0;
        List<Integer> oldAppendPropIdList = relic.getAppendPropIdList();
        while (expGain > 0 && reqExp > 0 && level < relic.getItemData().getMaxLevel()) {
            int toGain = Math.min(expGain, reqExp - exp2);
            totalExp += toGain;
            expGain -= toGain;
            if ((exp2 += toGain) < reqExp) continue;
            exp2 = 0;
            if (relic.getItemData().getAddPropLevelSet() != null && relic.getItemData().getAddPropLevelSet().contains(++level)) {
                ++upgrades;
            }
            reqExp = GameData.getRelicExpRequired(relic.getItemData().getRankLevel(), level);
        }
        if (upgrades > 0) {
            oldAppendPropIdList = new ArrayList<Integer>(relic.getAppendPropIdList());
            while (upgrades > 0) {
                relic.addAppendProp();
                --upgrades;
            }
        }
        relic.setLevel(level);
        relic.setExp(exp2);
        relic.setTotalExp(totalExp);
        relic.save();
        if (oldLevel != level) {
            Avatar avatar;
            Avatar avatar2 = avatar = relic.getEquipCharacter() > 0 ? player.getAvatars().getAvatarById(relic.getEquipCharacter()) : null;
            if (avatar != null) {
                avatar.recalcStats();
            }
        }
        player.sendPacket(new PacketStoreItemChangeNotify(relic));
        player.sendPacket(new PacketReliquaryUpgradeRsp(relic, rate, oldLevel, oldAppendPropIdList));
    }

    public List<ItemParamOuterClass.ItemParam> calcWeaponUpgradeReturnItems(Player player, long targetGuid, List<Long> foodWeaponGuidList, List<ItemParamOuterClass.ItemParam> itemParamList) {
        GameItem weapon = player.getInventory().getItemByGuid(targetGuid);
        if (weapon == null || weapon.getItemType() != ItemType.ITEM_WEAPON) {
            return null;
        }
        WeaponPromoteData promoteData = GameData.getWeaponPromoteData(weapon.getItemData().getWeaponPromoteId(), weapon.getPromoteLevel());
        if (promoteData == null) {
            return null;
        }
        int expGain = 0;
        Iterator<Serializable> iterator2 = foodWeaponGuidList.iterator();
        while (iterator2.hasNext()) {
            long guid = iterator2.next();
            GameItem food = player.getInventory().getItemByGuid(guid);
            if (food == null) continue;
            expGain += food.getItemData().getWeaponBaseExp();
            if (food.getTotalExp() <= 0) continue;
            expGain += food.getTotalExp() * 4 / 5;
        }
        for (ItemParamOuterClass.ItemParam param : itemParamList) {
            int n = param.getCount();
            expGain += n * (switch (param.getItemId()) {
                case 104011 -> 400;
                case 104012 -> 2000;
                case 104013 -> 10000;
                default -> 0;
            });
        }
        int maxLevel = promoteData.getUnlockMaxLevel();
        int level = weapon.getLevel();
        int exp2 = weapon.getExp();
        int reqExp = GameData.getWeaponExpRequired(weapon.getItemData().getRankLevel(), level);
        while (expGain > 0 && reqExp > 0 && level < maxLevel) {
            int toGain = Math.min(expGain, reqExp - exp2);
            expGain -= toGain;
            if ((exp2 += toGain) < reqExp) continue;
            exp2 = 0;
            reqExp = GameData.getWeaponExpRequired(weapon.getItemData().getRankLevel(), ++level);
        }
        return this.getLeftoverOres(expGain);
    }

    public void upgradeWeapon(Player player, long targetGuid, List<Long> foodWeaponGuidList, List<ItemParamOuterClass.ItemParam> itemParamList) {
        int level;
        GameItem weapon = player.getInventory().getItemByGuid(targetGuid);
        if (weapon == null || weapon.getItemType() != ItemType.ITEM_WEAPON) {
            return;
        }
        WeaponPromoteData promoteData = GameData.getWeaponPromoteData(weapon.getItemData().getWeaponPromoteId(), weapon.getPromoteLevel());
        if (promoteData == null) {
            return;
        }
        int expGain = 0;
        int expGainFree = 0;
        ArrayList<GameItem> foodWeapons = new ArrayList<GameItem>();
        for (long guid : foodWeaponGuidList) {
            GameItem food = player.getInventory().getItemByGuid(guid);
            if (food == null || !food.isDestroyable()) continue;
            expGain += food.getItemData().getWeaponBaseExp();
            if (food.getTotalExp() > 0) {
                expGainFree += food.getTotalExp() * 4 / 5;
            }
            foodWeapons.add(food);
        }
        ArrayList<ItemParamData> payList = new ArrayList<ItemParamData>();
        for (ItemParamOuterClass.ItemParam param : itemParamList) {
            int amount = param.getCount();
            int gain = amount * (switch (param.getItemId()) {
                case 104011 -> 400;
                case 104012 -> 2000;
                case 104013 -> 10000;
                default -> 0;
            });
            expGain += gain;
            payList.add(new ItemParamData(param.getItemId(), amount));
        }
        int moraCost = expGain / 10;
        if ((expGain += expGainFree) <= 0) {
            return;
        }
        payList.add(new ItemParamData(202, moraCost));
        if (!player.getInventory().payItems(payList.toArray(new ItemParamData[0]))) {
            return;
        }
        player.getInventory().removeItems(foodWeapons);
        int maxLevel = promoteData.getUnlockMaxLevel();
        int oldLevel = level = weapon.getLevel();
        int exp2 = weapon.getExp();
        int totalExp = weapon.getTotalExp();
        int reqExp = GameData.getWeaponExpRequired(weapon.getItemData().getRankLevel(), level);
        while (expGain > 0 && reqExp > 0 && level < maxLevel) {
            int toGain = Math.min(expGain, reqExp - exp2);
            totalExp += toGain;
            expGain -= toGain;
            if ((exp2 += toGain) < reqExp) continue;
            exp2 = 0;
            reqExp = GameData.getWeaponExpRequired(weapon.getItemData().getRankLevel(), ++level);
        }
        List<ItemParamOuterClass.ItemParam> leftovers = this.getLeftoverOres(expGain);
        player.getInventory().addItemParams(leftovers);
        weapon.setLevel(level);
        weapon.setExp(exp2);
        weapon.setTotalExp(totalExp);
        weapon.save();
        if (oldLevel != level) {
            Avatar avatar;
            Avatar avatar2 = avatar = weapon.getEquipCharacter() > 0 ? player.getAvatars().getAvatarById(weapon.getEquipCharacter()) : null;
            if (avatar != null) {
                avatar.recalcStats();
            }
        }
        player.sendPacket(new PacketStoreItemChangeNotify(weapon));
        player.sendPacket(new PacketWeaponUpgradeRsp(weapon, oldLevel, leftovers));
    }

    private List<ItemParamOuterClass.ItemParam> getLeftoverOres(int leftover) {
        ArrayList<ItemParamOuterClass.ItemParam> leftoverOreList = new ArrayList<ItemParamOuterClass.ItemParam>(3);
        if (leftover < 400) {
            return leftoverOreList;
        }
        int ore3 = leftover / 10000;
        int ore2 = (leftover %= 10000) / 2000;
        int ore1 = (leftover %= 2000) / 400;
        if (ore3 > 0) {
            leftoverOreList.add(ItemParamOuterClass.ItemParam.newBuilder().setItemId(104013).setCount(ore3).build());
        }
        if (ore2 > 0) {
            leftoverOreList.add(ItemParamOuterClass.ItemParam.newBuilder().setItemId(104012).setCount(ore2).build());
        }
        if (ore1 > 0) {
            leftoverOreList.add(ItemParamOuterClass.ItemParam.newBuilder().setItemId(104011).setCount(ore1).build());
        }
        return leftoverOreList;
    }

    public void refineWeapon(Player player, long targetGuid, long feedGuid) {
        Avatar avatar;
        GameItem weapon = player.getInventory().getItemByGuid(targetGuid);
        GameItem feed = player.getInventory().getItemByGuid(feedGuid);
        if (weapon == null || feed == null || !feed.isDestroyable()) {
            return;
        }
        if (weapon.getItemData().getAwakenMaterial() == 0 ? weapon.getItemType() != ItemType.ITEM_WEAPON || weapon.getItemId() != feed.getItemId() : weapon.getItemType() != ItemType.ITEM_WEAPON || weapon.getItemData().getAwakenMaterial() != feed.getItemId()) {
            return;
        }
        if (weapon.getRefinement() >= 4 || weapon.getAffixes() == null || weapon.getAffixes().size() == 0) {
            return;
        }
        int oldRefineLevel = weapon.getRefinement();
        int targetRefineLevel = Math.min(oldRefineLevel + feed.getRefinement() + 1, 4);
        int moraCost = 0;
        try {
            moraCost = weapon.getItemData().getAwakenCosts()[weapon.getRefinement()];
        }
        catch (Exception e) {
            return;
        }
        if (player.getMora() < moraCost) {
            return;
        }
        player.setMora(player.getMora() - moraCost);
        player.getInventory().removeItem(feed, 1);
        weapon.setRefinement(targetRefineLevel);
        weapon.save();
        Avatar avatar2 = avatar = weapon.getEquipCharacter() > 0 ? player.getAvatars().getAvatarById(weapon.getEquipCharacter()) : null;
        if (avatar != null) {
            avatar.recalcStats();
        }
        player.sendPacket(new PacketStoreItemChangeNotify(weapon));
        player.sendPacket(new PacketWeaponAwakenRsp(avatar, weapon, feed, oldRefineLevel));
    }

    public void promoteWeapon(Player player, long targetGuid) {
        Avatar avatar;
        GameItem weapon = player.getInventory().getItemByGuid(targetGuid);
        if (weapon == null || weapon.getItemType() != ItemType.ITEM_WEAPON) {
            return;
        }
        int nextPromoteLevel = weapon.getPromoteLevel() + 1;
        WeaponPromoteData currentPromoteData = GameData.getWeaponPromoteData(weapon.getItemData().getWeaponPromoteId(), weapon.getPromoteLevel());
        WeaponPromoteData nextPromoteData = GameData.getWeaponPromoteData(weapon.getItemData().getWeaponPromoteId(), nextPromoteLevel);
        if (currentPromoteData == null || nextPromoteData == null) {
            return;
        }
        if (weapon.getLevel() != currentPromoteData.getUnlockMaxLevel()) {
            return;
        }
        ItemParamData[] costs = nextPromoteData.getCostItems();
        if (nextPromoteData.getCoinCost() > 0) {
            costs = Arrays.copyOf(costs, costs.length + 1);
            costs[costs.length - 1] = new ItemParamData(202, nextPromoteData.getCoinCost());
        }
        if (!player.getInventory().payItems(costs)) {
            return;
        }
        int oldPromoteLevel = weapon.getPromoteLevel();
        weapon.setPromoteLevel(nextPromoteLevel);
        weapon.save();
        Avatar avatar2 = avatar = weapon.getEquipCharacter() > 0 ? player.getAvatars().getAvatarById(weapon.getEquipCharacter()) : null;
        if (avatar != null) {
            avatar.recalcStats();
        }
        player.sendPacket(new PacketStoreItemChangeNotify(weapon));
        player.sendPacket(new PacketWeaponPromoteRsp(weapon, oldPromoteLevel));
    }

    public void promoteAvatar(Player player, long guid) {
        Avatar avatar = player.getAvatars().getAvatarByGuid(guid);
        if (avatar == null) {
            return;
        }
        int nextPromoteLevel = avatar.getPromoteLevel() + 1;
        AvatarPromoteData currentPromoteData = GameData.getAvatarPromoteData(avatar.getAvatarData().getAvatarPromoteId(), avatar.getPromoteLevel());
        AvatarPromoteData nextPromoteData = GameData.getAvatarPromoteData(avatar.getAvatarData().getAvatarPromoteId(), nextPromoteLevel);
        if (currentPromoteData == null || nextPromoteData == null) {
            return;
        }
        if (avatar.getLevel() != currentPromoteData.getUnlockMaxLevel()) {
            return;
        }
        ItemParamData[] costs = nextPromoteData.getCostItems();
        if (nextPromoteData.getCoinCost() > 0) {
            costs = Arrays.copyOf(costs, costs.length + 1);
            costs[costs.length - 1] = new ItemParamData(202, nextPromoteData.getCoinCost());
        }
        if (!player.getInventory().payItems(costs)) {
            return;
        }
        avatar.setPromoteLevel(nextPromoteLevel);
        AvatarSkillDepotData skillDepot = (AvatarSkillDepotData)GameData.getAvatarSkillDepotDataMap().get(avatar.getSkillDepotId());
        if (skillDepot != null && skillDepot.getInherentProudSkillOpens() != null) {
            for (AvatarSkillDepotData.InherentProudSkillOpens openData : skillDepot.getInherentProudSkillOpens()) {
                if (openData.getProudSkillGroupId() == 0 || openData.getNeedAvatarPromoteLevel() != avatar.getPromoteLevel()) continue;
                int proudSkillId = openData.getProudSkillGroupId() * 100 + 1;
                if (!GameData.getProudSkillDataMap().containsKey(proudSkillId)) continue;
                avatar.getProudSkillList().add(proudSkillId);
                player.sendPacket(new PacketProudSkillChangeNotify(avatar));
            }
        }
        player.sendPacket(new PacketAvatarPropNotify(avatar));
        player.sendPacket(new PacketAvatarPromoteRsp(avatar));
        avatar.recalcStats(true);
        avatar.save();
    }

    public void upgradeAvatar(Player player, long guid, int itemId, int count) {
        int expGain;
        Avatar avatar = player.getAvatars().getAvatarByGuid(guid);
        if (avatar == null) {
            return;
        }
        AvatarPromoteData promoteData = GameData.getAvatarPromoteData(avatar.getAvatarData().getAvatarPromoteId(), avatar.getPromoteLevel());
        if (promoteData == null) {
            return;
        }
        switch (itemId) {
            case 104001: {
                int n = 1000 * count;
                break;
            }
            case 104002: {
                int n = 5000 * count;
                break;
            }
            case 104003: {
                int n = 20000 * count;
                break;
            }
            default: {
                int n = expGain = 0;
            }
        }
        if (expGain <= 0) {
            return;
        }
        int moraCost = expGain / 5;
        ItemParamData[] costItems = new ItemParamData[]{new ItemParamData(itemId, count), new ItemParamData(202, moraCost)};
        if (!player.getInventory().payItems(costItems)) {
            return;
        }
        this.upgradeAvatar(player, avatar, promoteData, expGain);
    }

    public void upgradeAvatar(Player player, Avatar avatar, int expGain) {
        AvatarPromoteData promoteData = GameData.getAvatarPromoteData(avatar.getAvatarData().getAvatarPromoteId(), avatar.getPromoteLevel());
        if (promoteData == null) {
            return;
        }
        this.upgradeAvatar(player, avatar, promoteData, expGain);
    }

    public void upgradeAvatar(Player player, Avatar avatar, AvatarPromoteData promoteData, int expGain) {
        int level;
        int maxLevel = promoteData.getUnlockMaxLevel();
        int oldLevel = level = avatar.getLevel();
        int exp2 = avatar.getExp();
        int reqExp = GameData.getAvatarLevelExpRequired(level);
        while (expGain > 0 && reqExp > 0 && level < maxLevel) {
            int toGain = Math.min(expGain, reqExp - exp2);
            expGain -= toGain;
            if ((exp2 += toGain) < reqExp) continue;
            exp2 = 0;
            reqExp = GameData.getAvatarLevelExpRequired(++level);
        }
        Map<Integer, Float> oldPropMap = avatar.getFightProperties();
        if (oldLevel != level) {
            oldPropMap = avatar.getFightProperties().int2FloatEntrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        avatar.setLevel(level);
        avatar.setExp(exp2);
        avatar.recalcStats();
        avatar.save();
        player.sendPacket(new PacketAvatarPropNotify(avatar));
        player.sendPacket(new PacketAvatarUpgradeRsp(avatar, oldLevel, oldPropMap));
    }

    public void upgradeAvatarFetterLevel(Player player, Avatar avatar, int expGain) {
        int maxLevel = 10;
        int level = avatar.getFetterLevel();
        int exp2 = avatar.getFetterExp();
        int reqExp = GameData.getAvatarFetterLevelExpRequired(level);
        while (expGain > 0 && reqExp > 0 && level < maxLevel) {
            int toGain = Math.min(expGain, reqExp - exp2);
            expGain -= toGain;
            if ((exp2 += toGain) < reqExp) continue;
            exp2 = 0;
            reqExp = GameData.getAvatarFetterLevelExpRequired(++level);
        }
        avatar.setFetterLevel(level);
        avatar.setFetterExp(exp2);
        avatar.save();
        player.sendPacket(new PacketAvatarPropNotify(avatar));
        player.sendPacket(new PacketAvatarFetterDataNotify(avatar));
    }

    public void upgradeAvatarSkill(Player player, long guid, int skillId) {
        Avatar avatar = player.getAvatars().getAvatarByGuid(guid);
        if (avatar == null) {
            return;
        }
        if (!avatar.getSkillLevelMap().containsKey(skillId)) {
            return;
        }
        AvatarSkillData skillData = (AvatarSkillData)GameData.getAvatarSkillDataMap().get(skillId);
        if (skillData == null) {
            return;
        }
        int currentLevel = avatar.getSkillLevelMap().get(skillId);
        int nextLevel = currentLevel + 1;
        int proudSkillId = skillData.getProudSkillGroupId() * 100 + nextLevel;
        if (nextLevel > 10) {
            return;
        }
        ProudSkillData proudSkill = (ProudSkillData)GameData.getProudSkillDataMap().get(proudSkillId);
        if (proudSkill == null) {
            return;
        }
        if (avatar.getPromoteLevel() < proudSkill.getBreakLevel()) {
            return;
        }
        ArrayList<ItemParamData> costs = new ArrayList<ItemParamData>(proudSkill.getCostItems());
        if (proudSkill.getCoinCost() > 0) {
            costs.add(new ItemParamData(202, proudSkill.getCoinCost()));
        }
        if (!player.getInventory().payItems(costs.toArray(new ItemParamData[0]))) {
            return;
        }
        avatar.getSkillLevelMap().put(skillId, nextLevel);
        avatar.save();
        player.sendPacket(new PacketAvatarSkillChangeNotify(avatar, skillId, currentLevel, nextLevel));
        player.sendPacket(new PacketAvatarSkillUpgradeRsp(avatar, skillId, currentLevel, nextLevel));
    }

    public void unlockAvatarConstellation(Player player, long guid) {
        AvatarTalentData talentData;
        Avatar avatar = player.getAvatars().getAvatarByGuid(guid);
        if (avatar == null) {
            return;
        }
        int currentTalentLevel = avatar.getCoreProudSkillLevel();
        int nextTalentId = avatar.getAvatarId() % 10000000 * 10 + currentTalentLevel + 1;
        if (avatar.getAvatarId() == 0x989686) {
            nextTalentId = 40 + currentTalentLevel + 1;
        }
        if ((talentData = (AvatarTalentData)GameData.getAvatarTalentDataMap().get(nextTalentId)) == null) {
            return;
        }
        if (!player.getInventory().payItem(talentData.getMainCostItemId(), 1)) {
            return;
        }
        avatar.getTalentIdList().add(talentData.getId());
        avatar.setCoreProudSkillLevel(currentTalentLevel + 1);
        player.sendPacket(new PacketAvatarUnlockTalentNotify(avatar, nextTalentId));
        player.sendPacket(new PacketUnlockAvatarTalentRsp(avatar, nextTalentId));
        OpenConfigEntry entry = GameData.getOpenConfigEntries().get(talentData.getOpenConfig());
        if (entry != null) {
            if (entry.getExtraTalentIndex() > 0) {
                avatar.recalcConstellations();
                player.sendPacket(new PacketProudSkillExtraLevelNotify(avatar, entry.getExtraTalentIndex()));
            } else if (entry.getSkillPointModifiers() != null) {
                avatar.recalcConstellations();
                for (OpenConfigEntry.SkillPointModifier mod : entry.getSkillPointModifiers()) {
                    player.sendPacket(new PacketAvatarSkillMaxChargeCountNotify(avatar, mod.getSkillId(), avatar.getSkillExtraChargeMap().getOrDefault(mod.getSkillId(), 0)));
                }
            }
        }
        avatar.recalcStats(true);
        avatar.save();
    }

    public void destroyMaterial(Player player, List<MaterialInfoOuterClass.MaterialInfo> list) {
        Int2IntOpenHashMap returnMaterialMap = new Int2IntOpenHashMap();
        for (MaterialInfoOuterClass.MaterialInfo info : list) {
            GameItem item;
            if (info.getCount() <= 0 || (item = player.getInventory().getItemByGuid(info.getGuid())) == null || !item.isDestroyable()) continue;
            int removeAmount = Math.min(info.getCount(), item.getCount());
            player.getInventory().removeItem(item, removeAmount);
            if (item.getItemData().getDestroyReturnMaterial().length <= 0) continue;
            for (int i2 = 0; i2 < item.getItemData().getDestroyReturnMaterial().length; ++i2) {
                returnMaterialMap.addTo(item.getItemData().getDestroyReturnMaterial()[i2], item.getItemData().getDestroyReturnMaterialCount()[i2]);
            }
        }
        if (returnMaterialMap.size() > 0) {
            for (Int2IntMap.Entry e : returnMaterialMap.int2IntEntrySet()) {
                player.getInventory().addItem(new GameItem(e.getIntKey(), e.getIntValue()));
            }
        }
        player.sendPacket(new PacketDestroyMaterialRsp(returnMaterialMap));
    }

    public GameItem useItem(Player player, long targetGuid, long itemGuid, int count, int optionId) {
        Avatar target = player.getAvatars().getAvatarByGuid(targetGuid);
        GameItem useItem = player.getInventory().getItemByGuid(itemGuid);
        if (useItem == null) {
            return null;
        }
        int used = 0;
        block0 : switch (useItem.getItemData().getMaterialType()) {
            case MATERIAL_FOOD: {
                if (!useItem.getItemData().getUseTarget().equals("ITEM_USE_TARGET_SPECIFY_DEAD_AVATAR") || target == null) break;
                used = player.getTeamManager().reviveAvatar(target) ? 1 : 0;
                break;
            }
            case MATERIAL_NOTICE_ADD_HP: {
                if (!useItem.getItemData().getUseTarget().equals("ITEM_USE_TARGET_SPECIFY_ALIVE_AVATAR") || target == null) break;
                int[] SatiationParams = useItem.getItemData().getSatiationParams();
                used = player.getTeamManager().healAvatar(target, SatiationParams[0], SatiationParams[1]) ? 1 : 0;
                break;
            }
            case MATERIAL_CHEST: {
                List<ShopChestTable> shopChestTableList = player.getServer().getShopManager().getShopChestData();
                ArrayList<GameItem> rewardItemList = new ArrayList<GameItem>();
                for (ShopChestTable shopChestTable : shopChestTableList) {
                    if (shopChestTable.getItemId() != useItem.getItemId()) continue;
                    if (shopChestTable.getContainsItem() == null) break block0;
                    for (ItemParamData itemParamData : shopChestTable.getContainsItem()) {
                        ItemData itemData = (ItemData)GameData.getItemDataMap().get(itemParamData.getId());
                        if (itemData == null) continue;
                        rewardItemList.add(new GameItem(itemData, itemParamData.getCount()));
                    }
                    if (!rewardItemList.isEmpty()) {
                        player.getInventory().addItems(rewardItemList, ActionReason.Shop);
                    }
                    used = 1;
                    break block0;
                }
                break;
            }
            case MATERIAL_CHEST_BATCH_USE: {
                if (optionId < 1) break;
                List<ShopChestBatchUseTable> shopChestBatchUseTableList = player.getServer().getShopManager().getShopChestBatchUseData();
                for (ShopChestBatchUseTable shopChestBatchUseTable : shopChestBatchUseTableList) {
                    if (shopChestBatchUseTable.getItemId() != useItem.getItemId()) continue;
                    if (shopChestBatchUseTable.getOptionItem() == null || optionId > shopChestBatchUseTable.getOptionItem().size()) break block0;
                    int optionItemId = shopChestBatchUseTable.getOptionItem().get(optionId - 1);
                    ItemData itemData = (ItemData)GameData.getItemDataMap().get(optionItemId);
                    if (itemData == null) break block0;
                    player.getInventory().addItem(new GameItem(itemData, count), ActionReason.Shop);
                    used = count;
                    break block0;
                }
                break;
            }
        }
        if (useItem.getItemId() == 1202) {
            player.rechargeMoonCard();
            used = 1;
        }
        if (used > 0) {
            player.getInventory().removeItem(useItem, used);
            return useItem;
        }
        return null;
    }
}

