/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.inventory;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public enum ItemQuality {
    QUALITY_NONE(0),
    QUALITY_WHITE(1),
    QUALITY_GREEN(2),
    QUALITY_BLUE(3),
    QUALITY_PURPLE(4),
    QUALITY_ORANGE(5),
    QUALITY_ORANGE_SP(105);

    private final int value;
    private static final Int2ObjectMap<ItemQuality> map;
    private static final Map<String, ItemQuality> stringMap;

    private ItemQuality(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ItemQuality getTypeByValue(int value) {
        return map.getOrDefault(value, QUALITY_NONE);
    }

    public static ItemQuality getTypeByName(String name) {
        return stringMap.getOrDefault(name, QUALITY_NONE);
    }

    static {
        map = new Int2ObjectOpenHashMap<ItemQuality>();
        stringMap = new HashMap<String, ItemQuality>();
        Stream.of(ItemQuality.values()).forEach(e -> {
            map.put(e.getValue(), (ItemQuality)((Object)e));
            stringMap.put(e.name(), (ItemQuality)((Object)e));
        });
    }
}

