/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.gacha;

import com.google.gson.reflect.TypeToken;
import com.sun.nio.file.SensitivityWatchEventModifier;
import emu.grasscutter.Configuration;
import emu.grasscutter.Grasscutter;
import emu.grasscutter.data.GameData;
import emu.grasscutter.data.common.ItemParamData;
import emu.grasscutter.data.def.ItemData;
import emu.grasscutter.database.DatabaseHelper;
import emu.grasscutter.game.avatar.Avatar;
import emu.grasscutter.game.gacha.GachaBanner;
import emu.grasscutter.game.gacha.GachaRecord;
import emu.grasscutter.game.gacha.PlayerGachaBannerInfo;
import emu.grasscutter.game.inventory.GameItem;
import emu.grasscutter.game.inventory.Inventory;
import emu.grasscutter.game.inventory.ItemType;
import emu.grasscutter.game.inventory.MaterialType;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.net.proto.GachaItemOuterClass;
import emu.grasscutter.net.proto.GachaTransferItemOuterClass;
import emu.grasscutter.net.proto.GetGachaInfoRspOuterClass;
import emu.grasscutter.net.proto.ItemParamOuterClass;
import emu.grasscutter.server.game.GameServer;
import emu.grasscutter.server.game.GameServerTickEvent;
import emu.grasscutter.server.packet.send.PacketDoGachaRsp;
import emu.grasscutter.utils.Utils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.greenrobot.eventbus.Subscribe;

public class GachaManager {
    private final GameServer server;
    private final Int2ObjectMap<GachaBanner> gachaBanners;
    private GetGachaInfoRspOuterClass.GetGachaInfoRsp cachedProto;
    WatchService watchService;
    private static final int starglitterId = 221;
    private static final int stardustId = 222;
    private int[] fallbackItems4Pool2Default = new int[]{11401, 11402, 11403, 11405, 12401, 12402, 12403, 12405, 13401, 13407, 14401, 14402, 14403, 14409, 15401, 15402, 15403, 15405};
    private int[] fallbackItems5Pool2Default = new int[]{11501, 11502, 12501, 12502, 13502, 13505, 14501, 14502, 15501, 15502};

    public GachaManager(GameServer server) {
        this.server = server;
        this.gachaBanners = new Int2ObjectOpenHashMap<GachaBanner>();
        this.load();
        this.startWatcher(server);
    }

    public GameServer getServer() {
        return this.server;
    }

    public Int2ObjectMap<GachaBanner> getGachaBanners() {
        return this.gachaBanners;
    }

    public int randomRange(int min2, int max2) {
        return ThreadLocalRandom.current().nextInt(max2 - min2 + 1) + min2;
    }

    public int getRandom(int[] array) {
        return array[this.randomRange(0, array.length - 1)];
    }

    public synchronized void load() {
        try (FileReader fileReader = new FileReader(Configuration.DATA("Banners.json"));){
            this.getGachaBanners().clear();
            List banners = (List)Grasscutter.getGsonFactory().fromJson((Reader)fileReader, TypeToken.getParameterized(Collection.class, new Type[]{GachaBanner.class}).getType());
            if (banners.size() > 0) {
                for (GachaBanner banner : banners) {
                    this.getGachaBanners().put(banner.getGachaType(), banner);
                }
                Grasscutter.getLogger().info("Banners successfully loaded.");
                this.cachedProto = this.createProto();
            } else {
                Grasscutter.getLogger().error("Unable to load banners. Banners size is 0.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private synchronized int checkPlayerAvatarConstellationLevel(Player player, int itemId) {
        ItemData itemData = (ItemData)GameData.getItemDataMap().get(itemId);
        if (itemData == null || itemData.getMaterialType() != MaterialType.MATERIAL_AVATAR) {
            return -2;
        }
        Avatar avatar = player.getAvatars().getAvatarById(itemId % 1000 + 10000000);
        if (avatar == null) {
            return -1;
        }
        int constLevel = avatar.getCoreProudSkillLevel();
        GameItem constItem = player.getInventory().getInventoryTab(ItemType.ITEM_MATERIAL).getItemById(itemId + 100);
        return constLevel += constItem == null ? 0 : constItem.getCount();
    }

    private synchronized int[] removeC6FromPool(int[] itemPool, Player player) {
        IntArrayList temp = new IntArrayList();
        for (int itemId : itemPool) {
            if (this.checkPlayerAvatarConstellationLevel(player, itemId) >= 6) continue;
            temp.add(itemId);
        }
        return temp.toIntArray();
    }

    private synchronized int drawRoulette(int[] weights, int cutoff) {
        int total = 0;
        for (int weight : weights) {
            if (weight < 0) {
                throw new IllegalArgumentException("Weights must be non-negative!");
            }
            total += weight;
        }
        int roll = ThreadLocalRandom.current().nextInt(total < cutoff ? total : cutoff);
        int subTotal = 0;
        for (int i2 = 0; i2 < weights.length; ++i2) {
            if (roll >= (subTotal += weights[i2])) continue;
            return i2;
        }
        return 0;
    }

    private synchronized int doRarePull(int[] featured, int[] fallback1, int[] fallback2, int rarity, GachaBanner banner, PlayerGachaBannerInfo gachaInfo) {
        boolean pullFeatured;
        int itemId = 0;
        boolean bl = pullFeatured = gachaInfo.getFailedFeaturedItemPulls(rarity) >= 1 || this.randomRange(1, 100) <= banner.getEventChance(rarity);
        if (pullFeatured && featured.length > 0) {
            itemId = this.getRandom(featured);
            gachaInfo.setFailedFeaturedItemPulls(rarity, 0);
        } else {
            gachaInfo.addFailedFeaturedItemPulls(rarity, 1);
            if (fallback1.length < 1) {
                itemId = fallback2.length < 1 ? this.getRandom(rarity == 5 ? this.fallbackItems5Pool2Default : this.fallbackItems4Pool2Default) : this.getRandom(fallback2);
            } else if (fallback2.length < 1) {
                itemId = this.getRandom(fallback1);
            } else {
                int pityPool2;
                int pityPool1 = banner.getPoolBalanceWeight(rarity, gachaInfo.getPityPool(rarity, 1));
                int chosenPool = switch (pityPool1 >= (pityPool2 = banner.getPoolBalanceWeight(rarity, gachaInfo.getPityPool(rarity, 2))) ? 1 : 0) {
                    case 1 -> 1 + this.drawRoulette(new int[]{pityPool1, pityPool2}, 10000);
                    default -> 2 - this.drawRoulette(new int[]{pityPool2, pityPool1}, 10000);
                };
                itemId = switch (chosenPool) {
                    case 1 -> {
                        gachaInfo.setPityPool(rarity, 1, 0);
                        yield this.getRandom(fallback1);
                    }
                    default -> {
                        gachaInfo.setPityPool(rarity, 2, 0);
                        yield this.getRandom(fallback2);
                    }
                };
            }
        }
        return itemId;
    }

    private synchronized int doPull(GachaBanner banner, PlayerGachaBannerInfo gachaInfo, BannerPools pools) {
        gachaInfo.incPityAll();
        int[] weights = new int[]{banner.getWeight(5, gachaInfo.getPity5()), banner.getWeight(4, gachaInfo.getPity4()), 10000};
        int levelWon = 5 - this.drawRoulette(weights, 10000);
        return switch (levelWon) {
            case 5 -> {
                gachaInfo.setPity5(0);
                yield this.doRarePull(pools.rateUpItems5, pools.fallbackItems5Pool1, pools.fallbackItems5Pool2, 5, banner, gachaInfo);
            }
            case 4 -> {
                gachaInfo.setPity4(0);
                yield this.doRarePull(pools.rateUpItems4, pools.fallbackItems4Pool1, pools.fallbackItems4Pool2, 4, banner, gachaInfo);
            }
            default -> this.getRandom(banner.getFallbackItems3());
        };
    }

    public synchronized void doPulls(Player player, int gachaType, int times) {
        if (times != 10 && times != 1) {
            return;
        }
        Inventory inventory = player.getInventory();
        if (inventory.getInventoryTab(ItemType.ITEM_WEAPON).getSize() + times > inventory.getInventoryTab(ItemType.ITEM_WEAPON).getMaxCapacity()) {
            player.sendPacket(new PacketDoGachaRsp());
            return;
        }
        GachaBanner banner = (GachaBanner)this.getGachaBanners().get(gachaType);
        if (banner == null) {
            player.sendPacket(new PacketDoGachaRsp());
            return;
        }
        ItemParamData cost = banner.getCost(times);
        if (cost.getCount() > 0 && !inventory.payItem(cost)) {
            player.sendPacket(new PacketDoGachaRsp());
            return;
        }
        PlayerGachaBannerInfo gachaInfo = player.getGachaInfo().getBannerInfo(banner);
        BannerPools pools = new BannerPools(banner);
        ArrayList<GachaItemOuterClass.GachaItem> list = new ArrayList<GachaItemOuterClass.GachaItem>();
        int stardust = 0;
        int starglitter = 0;
        if (banner.getRemoveC6FromPool()) {
            pools.rateUpItems4 = this.removeC6FromPool(pools.rateUpItems4, player);
            pools.rateUpItems5 = this.removeC6FromPool(pools.rateUpItems5, player);
            pools.fallbackItems4Pool1 = this.removeC6FromPool(pools.fallbackItems4Pool1, player);
            pools.fallbackItems4Pool2 = this.removeC6FromPool(pools.fallbackItems4Pool2, player);
            pools.fallbackItems5Pool1 = this.removeC6FromPool(pools.fallbackItems5Pool1, player);
            pools.fallbackItems5Pool2 = this.removeC6FromPool(pools.fallbackItems5Pool2, player);
        }
        for (int i2 = 0; i2 < times; ++i2) {
            int itemId = this.doPull(banner, gachaInfo, pools);
            ItemData itemData = (ItemData)GameData.getItemDataMap().get(itemId);
            if (itemData == null) continue;
            GachaRecord gachaRecord = new GachaRecord(itemId, player.getUid(), gachaType);
            DatabaseHelper.saveGachaRecord(gachaRecord);
            GachaItemOuterClass.GachaItem.Builder gachaItem = GachaItemOuterClass.GachaItem.newBuilder();
            int addStardust = 0;
            int addStarglitter = 0;
            boolean isTransferItem = false;
            int constellation = this.checkPlayerAvatarConstellationLevel(player, itemId);
            block0 : switch (constellation) {
                case -2: {
                    switch (itemData.getRankLevel()) {
                        case 5: {
                            addStarglitter = 10;
                            break block0;
                        }
                        case 4: {
                            addStarglitter = 2;
                            break block0;
                        }
                    }
                    addStardust = 15;
                    break;
                }
                case -1: {
                    gachaItem.setIsGachaItemNew(true);
                    break;
                }
                default: {
                    if (constellation >= 6) {
                        addStarglitter = itemData.getRankLevel() == 5 ? 25 : 5;
                    } else {
                        if (banner.getRemoveC6FromPool() && constellation == 5) {
                            pools.removeFromAllPools(new int[]{itemId});
                        }
                        addStarglitter = itemData.getRankLevel() == 5 ? 10 : 2;
                        int constItemId = itemId + 100;
                        GameItem constItem = inventory.getInventoryTab(ItemType.ITEM_MATERIAL).getItemById(constItemId);
                        gachaItem.addTransferItems(GachaTransferItemOuterClass.GachaTransferItem.newBuilder().setItem(ItemParamOuterClass.ItemParam.newBuilder().setItemId(constItemId).setCount(1)).setIsTransferItemNew(constItem == null));
                        inventory.addItem(constItemId, 1);
                    }
                    isTransferItem = true;
                }
            }
            GameItem item = new GameItem(itemData);
            gachaItem.setGachaItem(item.toItemParam());
            inventory.addItem(item);
            stardust += addStardust;
            starglitter += addStarglitter;
            if (addStardust > 0) {
                gachaItem.addTokenItemList(ItemParamOuterClass.ItemParam.newBuilder().setItemId(222).setCount(addStardust));
            }
            if (addStarglitter > 0) {
                ItemParamOuterClass.ItemParam starglitterParam = ItemParamOuterClass.ItemParam.newBuilder().setItemId(221).setCount(addStarglitter).build();
                if (isTransferItem) {
                    gachaItem.addTransferItems(GachaTransferItemOuterClass.GachaTransferItem.newBuilder().setItem(starglitterParam));
                }
                gachaItem.addTokenItemList(starglitterParam);
            }
            list.add(gachaItem.build());
        }
        if (stardust > 0) {
            inventory.addItem(222, stardust);
        }
        if (starglitter > 0) {
            inventory.addItem(221, starglitter);
        }
        player.sendPacket(new PacketDoGachaRsp(banner, list));
    }

    private synchronized void startWatcher(GameServer server) {
        if (this.watchService == null) {
            try {
                this.watchService = FileSystems.getDefault().newWatchService();
                Path path = new File(Configuration.DATA_FOLDER).toPath();
                path.register(this.watchService, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY}, SensitivityWatchEventModifier.HIGH);
            }
            catch (Exception e) {
                Grasscutter.getLogger().error("Unable to load the Gacha Manager Watch Service. If ServerOptions.watchGacha is true it will not auto-reload");
                e.printStackTrace();
            }
        } else {
            Grasscutter.getLogger().error("Cannot reinitialise watcher ");
        }
    }

    @Subscribe
    public synchronized void watchBannerJson(GameServerTickEvent tickEvent) {
        if (Configuration.GAME_OPTIONS.watchGachaConfig) {
            try {
                WatchKey watchKey = this.watchService.take();
                for (WatchEvent<?> event : watchKey.pollEvents()) {
                    Path changed = (Path)event.context();
                    if (!changed.endsWith("Banners.json")) continue;
                    Grasscutter.getLogger().info("Change detected with banners.json. Reloading gacha config");
                    this.load();
                }
                boolean valid = watchKey.reset();
                if (!valid) {
                    Grasscutter.getLogger().error("Unable to reset Gacha Manager Watch Key. Auto-reload of banners.json will no longer work.");
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Deprecated
    private synchronized GetGachaInfoRspOuterClass.GetGachaInfoRsp createProto() {
        GetGachaInfoRspOuterClass.GetGachaInfoRsp.Builder proto = GetGachaInfoRspOuterClass.GetGachaInfoRsp.newBuilder().setGachaRandom(12345);
        for (GachaBanner banner : this.getGachaBanners().values()) {
            proto.addGachaInfoList(banner.toProto());
        }
        return proto.build();
    }

    private synchronized GetGachaInfoRspOuterClass.GetGachaInfoRsp createProto(String sessionKey) {
        GetGachaInfoRspOuterClass.GetGachaInfoRsp.Builder proto = GetGachaInfoRspOuterClass.GetGachaInfoRsp.newBuilder().setGachaRandom(12345);
        for (GachaBanner banner : this.getGachaBanners().values()) {
            proto.addGachaInfoList(banner.toProto(sessionKey));
        }
        return proto.build();
    }

    @Deprecated
    public GetGachaInfoRspOuterClass.GetGachaInfoRsp toProto() {
        if (this.cachedProto == null) {
            this.cachedProto = this.createProto();
        }
        return this.cachedProto;
    }

    public GetGachaInfoRspOuterClass.GetGachaInfoRsp toProto(String sessionKey) {
        return this.createProto(sessionKey);
    }

    private class BannerPools {
        public int[] rateUpItems4;
        public int[] rateUpItems5;
        public int[] fallbackItems4Pool1;
        public int[] fallbackItems4Pool2;
        public int[] fallbackItems5Pool1;
        public int[] fallbackItems5Pool2;

        public BannerPools(GachaBanner banner) {
            this.rateUpItems4 = banner.getRateUpItems4();
            this.rateUpItems5 = banner.getRateUpItems5();
            this.fallbackItems4Pool1 = banner.getFallbackItems4Pool1();
            this.fallbackItems4Pool2 = banner.getFallbackItems4Pool2();
            this.fallbackItems5Pool1 = banner.getFallbackItems5Pool1();
            this.fallbackItems5Pool2 = banner.getFallbackItems5Pool2();
            if (banner.getAutoStripRateUpFromFallback()) {
                this.fallbackItems4Pool1 = Utils.setSubtract(this.fallbackItems4Pool1, this.rateUpItems4);
                this.fallbackItems4Pool2 = Utils.setSubtract(this.fallbackItems4Pool2, this.rateUpItems4);
                this.fallbackItems5Pool1 = Utils.setSubtract(this.fallbackItems5Pool1, this.rateUpItems5);
                this.fallbackItems5Pool2 = Utils.setSubtract(this.fallbackItems5Pool2, this.rateUpItems5);
            }
        }

        public void removeFromAllPools(int[] itemIds) {
            this.rateUpItems4 = Utils.setSubtract(this.rateUpItems4, itemIds);
            this.rateUpItems5 = Utils.setSubtract(this.rateUpItems5, itemIds);
            this.fallbackItems4Pool1 = Utils.setSubtract(this.fallbackItems4Pool1, itemIds);
            this.fallbackItems4Pool2 = Utils.setSubtract(this.fallbackItems4Pool2, itemIds);
            this.fallbackItems5Pool1 = Utils.setSubtract(this.fallbackItems5Pool1, itemIds);
            this.fallbackItems5Pool2 = Utils.setSubtract(this.fallbackItems5Pool2, itemIds);
        }
    }
}

