/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.dungeons;

import emu.grasscutter.data.common.ItemParamData;
import emu.grasscutter.data.def.DungeonData;
import emu.grasscutter.game.entity.EntityMonster;
import emu.grasscutter.game.inventory.GameItem;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.game.props.ActionReason;
import emu.grasscutter.game.world.Scene;
import emu.grasscutter.scripts.data.SceneGroup;
import emu.grasscutter.scripts.data.ScriptArgs;
import emu.grasscutter.server.packet.send.PacketChallengeDataNotify;
import emu.grasscutter.server.packet.send.PacketDungeonChallengeBeginNotify;
import emu.grasscutter.server.packet.send.PacketDungeonChallengeFinishNotify;
import emu.grasscutter.server.packet.send.PacketGadgetAutoPickDropInfoNotify;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;

public class DungeonChallenge {
    private final Scene scene;
    private final SceneGroup group;
    private int challengeIndex;
    private int challengeId;
    private boolean success;
    private boolean progress;
    private boolean stage;
    private int score;
    private int objective = 0;
    private IntSet rewardedPlayers;

    public DungeonChallenge(Scene scene, SceneGroup group, int challengeId, int challengeIndex, int objective) {
        this.scene = scene;
        this.group = group;
        this.challengeId = challengeId;
        this.challengeIndex = challengeIndex;
        this.objective = objective;
        this.setRewardedPlayers(new IntOpenHashSet());
    }

    public Scene getScene() {
        return this.scene;
    }

    public SceneGroup getGroup() {
        return this.group;
    }

    public int getChallengeIndex() {
        return this.challengeIndex;
    }

    public void setChallengeIndex(int challengeIndex) {
        this.challengeIndex = challengeIndex;
    }

    public int getChallengeId() {
        return this.challengeId;
    }

    public void setChallengeId(int challengeId) {
        this.challengeId = challengeId;
    }

    public int getObjective() {
        return this.objective;
    }

    public void setObjective(int objective) {
        this.objective = objective;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean isSuccess) {
        this.success = isSuccess;
    }

    public boolean inProgress() {
        return this.progress;
    }

    public int getScore() {
        return this.score;
    }

    public boolean isStage() {
        return this.stage;
    }

    public void setStage(boolean stage) {
        this.stage = stage;
    }

    public int getTimeLimit() {
        return 600;
    }

    public IntSet getRewardedPlayers() {
        return this.rewardedPlayers;
    }

    public void setRewardedPlayers(IntSet rewardedPlayers) {
        this.rewardedPlayers = rewardedPlayers;
    }

    public void start() {
        this.progress = true;
        this.getScene().broadcastPacket(new PacketDungeonChallengeBeginNotify(this));
    }

    public void finish() {
        this.progress = false;
        this.getScene().broadcastPacket(new PacketDungeonChallengeFinishNotify(this));
        if (this.isSuccess()) {
            this.getScene().getScriptManager().callEvent(16, null);
            this.settle();
        } else {
            this.getScene().getScriptManager().callEvent(17, null);
        }
    }

    private void settle() {
        this.getScene().getDungeonSettleObservers().forEach(o -> o.onDungeonSettle(this.getScene()));
        if (!this.stage) {
            this.getScene().getScriptManager().callEvent(8, new ScriptArgs(this.isSuccess() ? 1 : 0));
        }
    }

    public void onMonsterDie(EntityMonster entity) {
        this.score = this.getScore() + 1;
        this.getScene().broadcastPacket(new PacketChallengeDataNotify(this, 1, this.getScore()));
        if (this.getScore() >= this.getObjective() && this.progress) {
            this.setSuccess(true);
            this.finish();
        }
    }

    public void getStatueDrops(Player player) {
        DungeonData dungeonData = this.getScene().getDungeonData();
        if (!this.isSuccess() || dungeonData == null || dungeonData.getRewardPreview() == null || dungeonData.getRewardPreview().getPreviewItems().length == 0) {
            return;
        }
        if (this.getRewardedPlayers().contains(player.getUid())) {
            return;
        }
        ArrayList<GameItem> rewards = new ArrayList<GameItem>();
        for (ItemParamData param : this.getScene().getDungeonData().getRewardPreview().getPreviewItems()) {
            rewards.add(new GameItem(param.getId(), Math.max(param.getCount(), 1)));
        }
        player.getInventory().addItems(rewards, ActionReason.DungeonStatueDrop);
        player.sendPacket(new PacketGadgetAutoPickDropInfoNotify(rewards));
        this.getRewardedPlayers().add(player.getUid());
    }
}

