/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.ability;

import com.google.protobuf.InvalidProtocolBufferException;
import emu.grasscutter.data.GameData;
import emu.grasscutter.data.custom.AbilityModifier;
import emu.grasscutter.data.custom.AbilityModifierEntry;
import emu.grasscutter.data.def.ItemData;
import emu.grasscutter.game.entity.EntityItem;
import emu.grasscutter.game.entity.GameEntity;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.net.proto.AbilityActionGenerateElemBallOuterClass;
import emu.grasscutter.net.proto.AbilityInvokeEntryHeadOuterClass;
import emu.grasscutter.net.proto.AbilityInvokeEntryOuterClass;
import emu.grasscutter.net.proto.AbilityMetaModifierChangeOuterClass;
import emu.grasscutter.net.proto.AbilityMetaReInitOverrideMapOuterClass;
import emu.grasscutter.net.proto.AbilityMixinCostStaminaOuterClass;
import emu.grasscutter.net.proto.AbilityScalarValueEntryOuterClass;
import emu.grasscutter.net.proto.ModifierActionOuterClass;
import emu.grasscutter.utils.Position;

public class AbilityManager {
    private Player player;

    public AbilityManager(Player player) {
        this.player = player;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void onAbilityInvoke(AbilityInvokeEntryOuterClass.AbilityInvokeEntry invoke) throws Exception {
        switch (invoke.getArgumentType()) {
            case ABILITY_META_OVERRIDE_PARAM: {
                this.handleOverrideParam(invoke);
                break;
            }
            case ABILITY_META_REINIT_OVERRIDEMAP: {
                this.handleReinitOverrideMap(invoke);
                break;
            }
            case ABILITY_META_MODIFIER_CHANGE: {
                this.handleModifierChange(invoke);
                break;
            }
            case ABILITY_MIXIN_COST_STAMINA: {
                this.handleMixinCostStamina(invoke);
                break;
            }
            case ABILITY_ACTION_GENERATE_ELEM_BALL: {
                this.handleGenerateElemBall(invoke);
                break;
            }
        }
    }

    private void handleOverrideParam(AbilityInvokeEntryOuterClass.AbilityInvokeEntry invoke) throws Exception {
        GameEntity entity = this.player.getScene().getEntityById(invoke.getEntityId());
        if (entity == null) {
            return;
        }
        AbilityScalarValueEntryOuterClass.AbilityScalarValueEntry entry = AbilityScalarValueEntryOuterClass.AbilityScalarValueEntry.parseFrom(invoke.getAbilityData());
        entity.getMetaOverrideMap().put(entry.getKey().getStr(), Float.valueOf(entry.getFloatValue()));
    }

    private void handleReinitOverrideMap(AbilityInvokeEntryOuterClass.AbilityInvokeEntry invoke) throws Exception {
        GameEntity entity = this.player.getScene().getEntityById(invoke.getEntityId());
        if (entity == null) {
            return;
        }
        AbilityMetaReInitOverrideMapOuterClass.AbilityMetaReInitOverrideMap map = AbilityMetaReInitOverrideMapOuterClass.AbilityMetaReInitOverrideMap.parseFrom(invoke.getAbilityData());
        for (AbilityScalarValueEntryOuterClass.AbilityScalarValueEntry entry : map.getOverrideMapList()) {
            entity.getMetaOverrideMap().put(entry.getKey().getStr(), Float.valueOf(entry.getFloatValue()));
        }
    }

    private void handleModifierChange(AbilityInvokeEntryOuterClass.AbilityInvokeEntry invoke) throws Exception {
        String modifierString;
        GameEntity target = this.player.getScene().getEntityById(invoke.getEntityId());
        if (target == null) {
            return;
        }
        AbilityInvokeEntryHeadOuterClass.AbilityInvokeEntryHead head = invoke.getHead();
        if (head == null) {
            return;
        }
        AbilityMetaModifierChangeOuterClass.AbilityMetaModifierChange data = AbilityMetaModifierChangeOuterClass.AbilityMetaModifierChange.parseFrom(invoke.getAbilityData());
        if (data == null) {
            return;
        }
        GameEntity sourceEntity = this.player.getScene().getEntityById(data.getApplyEntityId());
        if (sourceEntity == null) {
            return;
        }
        if (data.getAction() == ModifierActionOuterClass.ModifierAction.ADDED && data.getParentAbilityName() != null) {
            String modifierString2 = data.getParentAbilityName().getStr();
            AbilityModifierEntry modifier = GameData.getAbilityModifiers().get(modifierString2);
            if (modifier != null && modifier.getOnAdded().size() > 0) {
                for (AbilityModifier.AbilityModifierAction action : modifier.getOnAdded()) {
                    this.invokeAction(action, target, sourceEntity);
                }
            }
            target.getMetaModifiers().put(head.getInstancedModifierId(), modifierString2);
        } else if (data.getAction() == ModifierActionOuterClass.ModifierAction.REMOVED && (modifierString = (String)target.getMetaModifiers().get(head.getInstancedModifierId())) != null) {
            AbilityModifierEntry modifier = GameData.getAbilityModifiers().get(modifierString);
            if (modifier != null && modifier.getOnRemoved().size() > 0) {
                for (AbilityModifier.AbilityModifierAction action : modifier.getOnRemoved()) {
                    this.invokeAction(action, target, sourceEntity);
                }
            }
            target.getMetaModifiers().remove(head.getInstancedModifierId());
        }
    }

    private void handleMixinCostStamina(AbilityInvokeEntryOuterClass.AbilityInvokeEntry invoke) throws InvalidProtocolBufferException {
        AbilityMixinCostStaminaOuterClass.AbilityMixinCostStamina costStamina = AbilityMixinCostStaminaOuterClass.AbilityMixinCostStamina.parseFrom(invoke.getAbilityData());
        this.getPlayer().getStaminaManager().handleMixinCostStamina(costStamina.getIsSwim());
    }

    private void handleGenerateElemBall(AbilityInvokeEntryOuterClass.AbilityInvokeEntry invoke) throws InvalidProtocolBufferException {
        AbilityActionGenerateElemBallOuterClass.AbilityActionGenerateElemBall action = AbilityActionGenerateElemBallOuterClass.AbilityActionGenerateElemBall.parseFrom(invoke.getAbilityData());
        if (action == null) {
            return;
        }
        ItemData itemData = (ItemData)GameData.getItemDataMap().get(2024);
        if (itemData == null) {
            return;
        }
        EntityItem energyBall = new EntityItem(this.getPlayer().getScene(), this.getPlayer(), itemData, new Position(action.getPos()), 1);
        energyBall.getRotation().set(action.getRot());
        this.getPlayer().getScene().addEntity(energyBall);
    }

    private void invokeAction(AbilityModifier.AbilityModifierAction action, GameEntity target, GameEntity sourceEntity) {
        switch (action.type) {
            case HealHP: {
                if (action.amount == null) {
                    return;
                }
                float healAmount = 0.0f;
                if (action.amount.isDynamic && action.amount.dynamicKey != null) {
                    healAmount = sourceEntity.getMetaOverrideMap().getOrDefault(action.amount.dynamicKey, Float.valueOf(0.0f)).floatValue();
                }
                if (!(healAmount > 0.0f)) break;
                target.heal(healAmount);
                break;
            }
            case LoseHP: {
                if (action.amountByTargetCurrentHPRatio == null) {
                    return;
                }
                float damageAmount = 0.0f;
                if (action.amount.isDynamic && action.amount.dynamicKey != null) {
                    damageAmount = sourceEntity.getMetaOverrideMap().getOrDefault(action.amount.dynamicKey, Float.valueOf(0.0f)).floatValue();
                }
                if (!(damageAmount > 0.0f)) break;
                target.damage(damageAmount);
            }
        }
    }
}

