/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.database;

import com.mongodb.MongoCommandException;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import dev.morphia.Datastore;
import dev.morphia.Morphia;
import dev.morphia.mapping.MapperOptions;
import dev.morphia.query.experimental.filters.Filters;
import emu.grasscutter.Configuration;
import emu.grasscutter.Grasscutter;
import emu.grasscutter.database.DatabaseCounter;
import emu.grasscutter.game.Account;
import emu.grasscutter.game.avatar.Avatar;
import emu.grasscutter.game.friends.Friendship;
import emu.grasscutter.game.gacha.GachaRecord;
import emu.grasscutter.game.inventory.GameItem;
import emu.grasscutter.game.mail.Mail;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.game.quest.GameMainQuest;

public final class DatabaseManager {
    private static Datastore gameDatastore;
    private static Datastore dispatchDatastore;
    private static final Class<?>[] mappedClasses;

    public static Datastore getGameDatastore() {
        return gameDatastore;
    }

    public static MongoDatabase getGameDatabase() {
        return DatabaseManager.getGameDatastore().getDatabase();
    }

    public static Datastore getAccountDatastore() {
        if (Configuration.SERVER.runMode == Grasscutter.ServerRunMode.GAME_ONLY) {
            return dispatchDatastore;
        }
        return gameDatastore;
    }

    public static void initialize() {
        block8: {
            block7: {
                MongoClient gameMongoClient = MongoClients.create(Configuration.DATABASE.game.connectionUri);
                MapperOptions mapperOptions = MapperOptions.builder().storeEmpties(true).storeNulls(false).build();
                gameDatastore = Morphia.createDatastore(gameMongoClient, Configuration.DATABASE.game.collection, mapperOptions);
                gameDatastore.getMapper().map(mappedClasses);
                try {
                    gameDatastore.ensureIndexes();
                }
                catch (MongoCommandException exception) {
                    Grasscutter.getLogger().info("Mongo index error: ", exception);
                    if (exception.getCode() != 85) break block7;
                    MongoIterable<String> collections = gameDatastore.getDatabase().listCollectionNames();
                    for (String name : collections) {
                        gameDatastore.getDatabase().getCollection(name).dropIndexes();
                    }
                    gameDatastore.ensureIndexes();
                }
            }
            if (Configuration.SERVER.runMode == Grasscutter.ServerRunMode.GAME_ONLY) {
                MongoClient dispatchMongoClient = MongoClients.create(Configuration.DATABASE.server.connectionUri);
                dispatchDatastore = Morphia.createDatastore(dispatchMongoClient, Configuration.DATABASE.server.collection);
                try {
                    dispatchDatastore.ensureIndexes();
                }
                catch (MongoCommandException e) {
                    Grasscutter.getLogger().info("Mongo index error: ", e);
                    if (e.getCode() != 85) break block8;
                    MongoIterable<String> collections = dispatchDatastore.getDatabase().listCollectionNames();
                    for (String name : collections) {
                        dispatchDatastore.getDatabase().getCollection(name).dropIndexes();
                    }
                    dispatchDatastore.ensureIndexes();
                }
            }
        }
    }

    public static synchronized int getNextId(Class<?> c) {
        DatabaseCounter counter = DatabaseManager.getGameDatastore().find(DatabaseCounter.class).filter(Filters.eq("_id", c.getSimpleName())).first();
        if (counter == null) {
            counter = new DatabaseCounter(c.getSimpleName());
        }
        try {
            int n = counter.getNextId();
            return n;
        }
        finally {
            DatabaseManager.getGameDatastore().save(counter);
        }
    }

    public static synchronized int getNextId(Object o) {
        return DatabaseManager.getNextId(o.getClass());
    }

    static {
        mappedClasses = new Class[]{DatabaseCounter.class, Account.class, Player.class, Avatar.class, GameItem.class, Friendship.class, GachaRecord.class, Mail.class, GameMainQuest.class};
    }
}

