/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.database;

import com.mongodb.client.result.DeleteResult;
import dev.morphia.query.FindOptions;
import dev.morphia.query.Sort;
import dev.morphia.query.experimental.filters.Filters;
import emu.grasscutter.database.DatabaseManager;
import emu.grasscutter.game.Account;
import emu.grasscutter.game.avatar.Avatar;
import emu.grasscutter.game.friends.Friendship;
import emu.grasscutter.game.gacha.GachaRecord;
import emu.grasscutter.game.inventory.GameItem;
import emu.grasscutter.game.mail.Mail;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.game.quest.GameMainQuest;
import java.util.List;

public final class DatabaseHelper {
    public static Account createAccount(String username) {
        return DatabaseHelper.createAccountWithId(username, 0);
    }

    public static Account createAccountWithId(String username, int reservedId) {
        Account exists = DatabaseHelper.getAccountByName(username);
        if (exists != null) {
            return null;
        }
        if (reservedId > 0) {
            if (reservedId == 99) {
                return null;
            }
            exists = DatabaseHelper.getAccountByPlayerId(reservedId);
            if (exists != null) {
                return null;
            }
        }
        Account account = new Account();
        account.setUsername(username);
        account.setId(Integer.toString(DatabaseManager.getNextId(account)));
        if (reservedId > 0) {
            account.setPlayerId(reservedId);
        }
        DatabaseHelper.saveAccount(account);
        return account;
    }

    @Deprecated
    public static Account createAccountWithPassword(String username, String password) {
        Account exists = DatabaseHelper.getAccountByName(username);
        if (exists != null) {
            return null;
        }
        Account account = new Account();
        account.setId(Integer.toString(DatabaseManager.getNextId(account)));
        account.setUsername(username);
        account.setPassword(password);
        DatabaseHelper.saveAccount(account);
        return account;
    }

    public static void saveAccount(Account account) {
        DatabaseManager.getAccountDatastore().save(account);
    }

    public static Account getAccountByName(String username) {
        return DatabaseManager.getGameDatastore().find(Account.class).filter(Filters.eq("username", username)).first();
    }

    public static Account getAccountByToken(String token) {
        if (token == null) {
            return null;
        }
        return DatabaseManager.getGameDatastore().find(Account.class).filter(Filters.eq("token", token)).first();
    }

    public static Account getAccountBySessionKey(String sessionKey) {
        if (sessionKey == null) {
            return null;
        }
        return DatabaseManager.getGameDatastore().find(Account.class).filter(Filters.eq("sessionKey", sessionKey)).first();
    }

    public static Account getAccountById(String uid) {
        return DatabaseManager.getGameDatastore().find(Account.class).filter(Filters.eq("_id", uid)).first();
    }

    public static Account getAccountByPlayerId(int playerId) {
        return DatabaseManager.getGameDatastore().find(Account.class).filter(Filters.eq("playerId", playerId)).first();
    }

    public static void deleteAccount(Account target) {
        DatabaseManager.getGameDatabase().getCollection("mail").deleteMany(com.mongodb.client.model.Filters.eq("ownerUid", target.getPlayerUid()));
        DatabaseManager.getGameDatabase().getCollection("avatars").deleteMany(com.mongodb.client.model.Filters.eq("ownerId", target.getPlayerUid()));
        DatabaseManager.getGameDatabase().getCollection("gachas").deleteMany(com.mongodb.client.model.Filters.eq("ownerId", target.getPlayerUid()));
        DatabaseManager.getGameDatabase().getCollection("items").deleteMany(com.mongodb.client.model.Filters.eq("ownerId", target.getPlayerUid()));
        DatabaseManager.getGameDatabase().getCollection("quests").deleteMany(com.mongodb.client.model.Filters.eq("ownerUid", target.getPlayerUid()));
        DatabaseManager.getGameDatabase().getCollection("friendships").deleteMany(com.mongodb.client.model.Filters.eq("ownerId", target.getPlayerUid()));
        DatabaseManager.getGameDatabase().getCollection("friendships").deleteMany(com.mongodb.client.model.Filters.eq("friendId", target.getPlayerUid()));
        DatabaseManager.getGameDatastore().find(Player.class).filter(Filters.eq("id", target.getPlayerUid())).delete();
        DatabaseManager.getGameDatastore().find(Account.class).filter(Filters.eq("id", target.getId())).delete();
    }

    public static List<Player> getAllPlayers() {
        return DatabaseManager.getGameDatastore().find(Player.class).stream().toList();
    }

    public static Player getPlayerById(int id) {
        return DatabaseManager.getGameDatastore().find(Player.class).filter(Filters.eq("_id", id)).first();
    }

    public static boolean checkPlayerExists(int id) {
        return DatabaseManager.getGameDatastore().find(Player.class).filter(Filters.eq("_id", id)).first() != null;
    }

    public static synchronized Player createPlayer(Player character, int reservedId) {
        if (reservedId > 0 && !DatabaseHelper.checkPlayerExists(reservedId)) {
            int id = reservedId;
            character.setUid(id);
        } else {
            int id;
            while (DatabaseHelper.checkPlayerExists(id = DatabaseManager.getNextId(character))) {
            }
            character.setUid(id);
        }
        DatabaseManager.getGameDatastore().save(character);
        return character;
    }

    public static synchronized int getNextPlayerId(int reservedId) {
        int id;
        if (reservedId > 0 && !DatabaseHelper.checkPlayerExists(reservedId)) {
            id = reservedId;
        } else {
            while (DatabaseHelper.checkPlayerExists(id = DatabaseManager.getNextId(Player.class))) {
            }
        }
        return id;
    }

    public static void savePlayer(Player character) {
        DatabaseManager.getGameDatastore().save(character);
    }

    public static void saveAvatar(Avatar avatar) {
        DatabaseManager.getGameDatastore().save(avatar);
    }

    public static List<Avatar> getAvatars(Player player) {
        return DatabaseManager.getGameDatastore().find(Avatar.class).filter(Filters.eq("ownerId", player.getUid())).stream().toList();
    }

    public static void saveItem(GameItem item) {
        DatabaseManager.getGameDatastore().save(item);
    }

    public static boolean deleteItem(GameItem item) {
        DeleteResult result = DatabaseManager.getGameDatastore().delete(item);
        return result.wasAcknowledged();
    }

    public static List<GameItem> getInventoryItems(Player player) {
        return DatabaseManager.getGameDatastore().find(GameItem.class).filter(Filters.eq("ownerId", player.getUid())).stream().toList();
    }

    public static List<Friendship> getFriends(Player player) {
        return DatabaseManager.getGameDatastore().find(Friendship.class).filter(Filters.eq("ownerId", player.getUid())).stream().toList();
    }

    public static List<Friendship> getReverseFriends(Player player) {
        return DatabaseManager.getGameDatastore().find(Friendship.class).filter(Filters.eq("friendId", player.getUid())).stream().toList();
    }

    public static void saveFriendship(Friendship friendship) {
        DatabaseManager.getGameDatastore().save(friendship);
    }

    public static void deleteFriendship(Friendship friendship) {
        DatabaseManager.getGameDatastore().delete(friendship);
    }

    public static Friendship getReverseFriendship(Friendship friendship) {
        return DatabaseManager.getGameDatastore().find(Friendship.class).filter(Filters.and(Filters.eq("ownerId", friendship.getFriendId()), Filters.eq("friendId", friendship.getOwnerId()))).first();
    }

    public static List<GachaRecord> getGachaRecords(int ownerId, int page, int gachaType) {
        return DatabaseHelper.getGachaRecords(ownerId, page, gachaType, 10);
    }

    public static List<GachaRecord> getGachaRecords(int ownerId, int page, int gachaType, int pageSize) {
        return DatabaseManager.getGameDatastore().find(GachaRecord.class).filter(Filters.eq("ownerId", ownerId), Filters.eq("gachaType", gachaType)).iterator(new FindOptions().sort(Sort.descending("transactionDate")).skip(pageSize * page).limit(pageSize)).toList();
    }

    public static long getGachaRecordsMaxPage(int ownerId, int page, int gachaType) {
        return DatabaseHelper.getGachaRecordsMaxPage(ownerId, page, gachaType, 10);
    }

    public static long getGachaRecordsMaxPage(int ownerId, int page, int gachaType, int pageSize) {
        long count = DatabaseManager.getGameDatastore().find(GachaRecord.class).filter(Filters.eq("ownerId", ownerId), Filters.eq("gachaType", gachaType)).count();
        return count / 10L + (long)(count % 10L > 0L ? 1 : 0);
    }

    public static void saveGachaRecord(GachaRecord gachaRecord) {
        DatabaseManager.getGameDatastore().save(gachaRecord);
    }

    public static List<Mail> getAllMail(Player player) {
        return DatabaseManager.getGameDatastore().find(Mail.class).filter(Filters.eq("ownerUid", player.getUid())).stream().toList();
    }

    public static void saveMail(Mail mail) {
        DatabaseManager.getGameDatastore().save(mail);
    }

    public static boolean deleteMail(Mail mail) {
        DeleteResult result = DatabaseManager.getGameDatastore().delete(mail);
        return result.wasAcknowledged();
    }

    public static List<GameMainQuest> getAllQuests(Player player) {
        return DatabaseManager.getGameDatastore().find(GameMainQuest.class).filter(Filters.eq("ownerUid", player.getUid())).stream().toList();
    }

    public static void saveQuest(GameMainQuest quest) {
        DatabaseManager.getGameDatastore().save(quest);
    }

    public static boolean deleteQuest(GameMainQuest quest) {
        return DatabaseManager.getGameDatastore().delete(quest).wasAcknowledged();
    }
}

