/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.data.custom;

import emu.grasscutter.data.ResourceLoader;
import java.util.ArrayList;

public class OpenConfigEntry {
    private String name;
    private String[] addAbilities;
    private int extraTalentIndex;
    private SkillPointModifier[] skillPointModifiers;

    public OpenConfigEntry(String name, ResourceLoader.OpenConfigData[] data) {
        this.name = name;
        ArrayList<String> abilityList = new ArrayList<String>();
        ArrayList<SkillPointModifier> modList = new ArrayList<SkillPointModifier>();
        for (ResourceLoader.OpenConfigData entry : data) {
            if (entry.$type.contains("AddAbility")) {
                abilityList.add(entry.abilityName);
                continue;
            }
            if (entry.talentIndex > 0) {
                this.extraTalentIndex = entry.talentIndex;
                continue;
            }
            if (!entry.$type.contains("ModifySkillPoint")) continue;
            modList.add(new SkillPointModifier(entry.skillID, entry.pointDelta));
        }
        if (abilityList.size() > 0) {
            this.addAbilities = abilityList.toArray(new String[0]);
        }
        if (modList.size() > 0) {
            this.skillPointModifiers = modList.toArray(new SkillPointModifier[0]);
        }
    }

    public String getName() {
        return this.name;
    }

    public String[] getAddAbilities() {
        return this.addAbilities;
    }

    public int getExtraTalentIndex() {
        return this.extraTalentIndex;
    }

    public SkillPointModifier[] getSkillPointModifiers() {
        return this.skillPointModifiers;
    }

    public static class SkillPointModifier {
        private int skillId;
        private int delta;

        public SkillPointModifier(int skillId, int delta) {
            this.skillId = skillId;
            this.delta = delta;
        }

        public int getSkillId() {
            return this.skillId;
        }

        public int getDelta() {
            return this.delta;
        }
    }
}

