/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import emu.grasscutter.Configuration;
import emu.grasscutter.Grasscutter;
import emu.grasscutter.data.GameData;
import emu.grasscutter.data.GameDepot;
import emu.grasscutter.data.GameResource;
import emu.grasscutter.data.ResourceType;
import emu.grasscutter.data.common.PointData;
import emu.grasscutter.data.common.ScenePointConfig;
import emu.grasscutter.data.custom.AbilityEmbryoEntry;
import emu.grasscutter.data.custom.AbilityModifier;
import emu.grasscutter.data.custom.AbilityModifierEntry;
import emu.grasscutter.data.custom.MainQuestData;
import emu.grasscutter.data.custom.OpenConfigEntry;
import emu.grasscutter.data.custom.ScenePointEntry;
import emu.grasscutter.data.def.AvatarSkillDepotData;
import emu.grasscutter.game.world.SpawnDataEntry;
import emu.grasscutter.utils.Utils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class ResourceLoader {
    public static List<Class<?>> getResourceDefClasses() {
        Reflections reflections = new Reflections(ResourceLoader.class.getPackage().getName(), new Scanner[0]);
        Set<Class<GameResource>> classes = reflections.getSubTypesOf(GameResource.class);
        ArrayList classList = new ArrayList(classes.size());
        classes.forEach(o -> {
            Class c = (Class)o;
            if (c.getAnnotation(ResourceType.class) != null) {
                classList.add(c);
            }
        });
        classList.sort((a, b) -> b.getAnnotation(ResourceType.class).loadPriority().value() - a.getAnnotation(ResourceType.class).loadPriority().value());
        return classList;
    }

    public static void loadAll() {
        ResourceLoader.loadAbilityEmbryos();
        ResourceLoader.loadOpenConfig();
        ResourceLoader.loadAbilityModifiers();
        ResourceLoader.loadResources();
        GameDepot.load();
        ResourceLoader.loadSpawnData();
        ResourceLoader.loadQuests();
        ResourceLoader.loadScenePoints();
        try {
            ((AvatarSkillDepotData)GameData.getAvatarSkillDepotDataMap().get(504)).setAbilities(new AbilityEmbryoEntry("", new String[]{"Avatar_PlayerBoy_ExtraAttack_Wind", "Avatar_Player_UziExplode_Mix", "Avatar_Player_UziExplode", "Avatar_Player_UziExplode_Strike_01", "Avatar_Player_UziExplode_Strike_02", "Avatar_Player_WindBreathe", "Avatar_Player_WindBreathe_CameraController"}));
            ((AvatarSkillDepotData)GameData.getAvatarSkillDepotDataMap().get(704)).setAbilities(new AbilityEmbryoEntry("", new String[]{"Avatar_PlayerGirl_ExtraAttack_Wind", "Avatar_Player_UziExplode_Mix", "Avatar_Player_UziExplode", "Avatar_Player_UziExplode_Strike_01", "Avatar_Player_UziExplode_Strike_02", "Avatar_Player_WindBreathe", "Avatar_Player_WindBreathe_CameraController"}));
        }
        catch (Exception e) {
            Grasscutter.getLogger().error("Error loading abilities", e);
        }
    }

    public static void loadResources() {
        for (Class<?> resourceDefinition : ResourceLoader.getResourceDefClasses()) {
            Int2ObjectMap<?> map;
            ResourceType type2 = resourceDefinition.getAnnotation(ResourceType.class);
            if (type2 == null || (map = GameData.getMapByResourceDef(resourceDefinition)) == null) continue;
            try {
                ResourceLoader.loadFromResource(resourceDefinition, type2, map);
            }
            catch (Exception e) {
                Grasscutter.getLogger().error("Error loading resource file: " + Arrays.toString(type2.name()), e);
            }
        }
    }

    protected static void loadFromResource(Class<?> c, ResourceType type2, Int2ObjectMap map) throws Exception {
        for (String name : type2.name()) {
            ResourceLoader.loadFromResource(c, name, map);
        }
        Grasscutter.getLogger().info("Loaded " + map.size() + " " + c.getSimpleName() + "s.");
    }

    protected static void loadFromResource(Class<?> c, String fileName, Int2ObjectMap map) throws Exception {
        FileReader fileReader = new FileReader(Configuration.RESOURCE("ExcelBinOutput/" + fileName));
        Gson gson = Grasscutter.getGsonFactory();
        List list = gson.fromJson((Reader)fileReader, List.class);
        for (Object o : list) {
            Map<String, Object> tempMap = Utils.switchPropertiesUpperLowerCase((Map)o, c);
            GameResource res = (GameResource)gson.fromJson(gson.toJson(tempMap), TypeToken.get(c).getType());
            res.onLoad();
            map.put(res.getId(), res);
        }
    }

    private static void loadScenePoints() {
        Pattern pattern = Pattern.compile("(?<=scene)(.*?)(?=_point.json)");
        File folder = new File(Configuration.RESOURCE("BinOutput/Scene/Point"));
        if (!folder.isDirectory() || !folder.exists() || folder.listFiles() == null) {
            Grasscutter.getLogger().error("Scene point files cannot be found, you cannot use teleport waypoints!");
            return;
        }
        ArrayList<ScenePointEntry> scenePointList = new ArrayList<ScenePointEntry>();
        for (File file : Objects.requireNonNull(folder.listFiles())) {
            ScenePointConfig config;
            Matcher matcher = pattern.matcher(file.getName());
            if (!matcher.find()) continue;
            Integer sceneId = Integer.parseInt(matcher.group(1));
            try (FileReader fileReader = new FileReader(file);){
                config = Grasscutter.getGsonFactory().fromJson((Reader)fileReader, ScenePointConfig.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            if (config.points == null) continue;
            for (Map.Entry<String, JsonElement> entry : config.points.entrySet()) {
                PointData pointData = Grasscutter.getGsonFactory().fromJson(entry.getValue(), PointData.class);
                pointData.setId(Integer.parseInt(entry.getKey()));
                ScenePointEntry sl = new ScenePointEntry(sceneId + "_" + entry.getKey(), pointData);
                scenePointList.add(sl);
                GameData.getScenePointIdList().add(pointData.getId());
                pointData.updateDailyDungeon();
            }
            for (ScenePointEntry scenePointEntry : scenePointList) {
                GameData.getScenePointEntries().put(scenePointEntry.getName(), scenePointEntry);
            }
        }
    }

    private static void loadAbilityEmbryos() {
        File embryoCache = new File(Configuration.DATA("AbilityEmbryos.json"));
        List<AbilityEmbryoEntry> embryoList = null;
        if (embryoCache.exists()) {
            try (FileReader fileReader = new FileReader(embryoCache);){
                embryoList = (List)Grasscutter.getGsonFactory().fromJson((Reader)fileReader, TypeToken.getParameterized(Collection.class, new Type[]{AbilityEmbryoEntry.class}).getType());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Pattern pattern = Pattern.compile("(?<=ConfigAvatar_)(.*?)(?=.json)");
            embryoList = new LinkedList();
            File folder = new File(Utils.toFilePath(Configuration.RESOURCE("BinOutput/Avatar/")));
            File[] files = folder.listFiles();
            if (files == null) {
                Grasscutter.getLogger().error("Error loading ability embryos: no files found in " + folder.getAbsolutePath());
                return;
            }
            for (File file : files) {
                AvatarConfig config;
                Matcher matcher = pattern.matcher(file.getName());
                if (!matcher.find()) continue;
                String avatarName = matcher.group(0);
                try (FileReader fileReader = new FileReader(file);){
                    config = Grasscutter.getGsonFactory().fromJson((Reader)fileReader, AvatarConfig.class);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                if (config.abilities == null) continue;
                int s2 = config.abilities.size();
                AbilityEmbryoEntry al = new AbilityEmbryoEntry(avatarName, (String[])config.abilities.stream().map(Object::toString).toArray(size -> new String[s2]));
                embryoList.add(al);
            }
        }
        if (embryoList == null || embryoList.isEmpty()) {
            Grasscutter.getLogger().error("No embryos loaded!");
            return;
        }
        for (AbilityEmbryoEntry entry : embryoList) {
            GameData.getAbilityEmbryoInfo().put(entry.getName(), entry);
        }
    }

    private static void loadAbilityModifiers() {
        File folder = new File(Utils.toFilePath(Configuration.RESOURCE("BinOutput/Ability/Temp/AvatarAbilities/")));
        File[] files = folder.listFiles();
        if (files == null) {
            Grasscutter.getLogger().error("Error loading ability modifiers: no files found in " + folder.getAbsolutePath());
            return;
        }
        for (File file : files) {
            List abilityConfigList;
            try (FileReader fileReader = new FileReader(file);){
                abilityConfigList = (List)Grasscutter.getGsonFactory().fromJson((Reader)fileReader, TypeToken.getParameterized(Collection.class, new Type[]{AbilityModifier.AbilityConfigData.class}).getType());
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            for (AbilityModifier.AbilityConfigData data : abilityConfigList) {
                if (data.Default.modifiers == null || data.Default.modifiers.size() == 0) continue;
                AbilityModifierEntry modifierEntry = new AbilityModifierEntry(data.Default.abilityName);
                for (Map.Entry<String, AbilityModifier> entry : data.Default.modifiers.entrySet()) {
                    AbilityModifier modifier = entry.getValue();
                    if (modifier.onAdded != null) {
                        for (AbilityModifier.AbilityModifierAction action : modifier.onAdded) {
                            if (!action.$type.contains("HealHP")) continue;
                            action.type = AbilityModifier.AbilityModifierActionType.HealHP;
                            modifierEntry.getOnAdded().add(action);
                        }
                    }
                    if (modifier.onThinkInterval != null) {
                        for (AbilityModifier.AbilityModifierAction action : modifier.onThinkInterval) {
                            if (!action.$type.contains("HealHP")) continue;
                            action.type = AbilityModifier.AbilityModifierActionType.HealHP;
                            modifierEntry.getOnThinkInterval().add(action);
                        }
                    }
                    if (modifier.onRemoved == null) continue;
                    for (AbilityModifier.AbilityModifierAction action : modifier.onRemoved) {
                        if (!action.$type.contains("HealHP")) continue;
                        action.type = AbilityModifier.AbilityModifierActionType.HealHP;
                        modifierEntry.getOnRemoved().add(action);
                    }
                }
                GameData.getAbilityModifiers().put(modifierEntry.getName(), modifierEntry);
            }
        }
    }

    private static void loadSpawnData() {
        File spawnDataEntries = new File(Configuration.DATA("Spawns.json"));
        List spawnEntryList = null;
        if (spawnDataEntries.exists()) {
            try (FileReader fileReader = new FileReader(spawnDataEntries);){
                spawnEntryList = (List)Grasscutter.getGsonFactory().fromJson((Reader)fileReader, TypeToken.getParameterized(Collection.class, new Type[]{SpawnDataEntry.SpawnGroupEntry.class}).getType());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (spawnEntryList == null || spawnEntryList.isEmpty()) {
            Grasscutter.getLogger().error("No spawn data loaded!");
            return;
        }
        for (SpawnDataEntry.SpawnGroupEntry entry : spawnEntryList) {
            entry.getSpawns().forEach(s2 -> s2.setGroup(entry));
            GameDepot.getSpawnListById(entry.getSceneId()).insert(entry, entry.getPos().getX(), entry.getPos().getZ());
        }
    }

    private static void loadOpenConfig() {
        File openConfigCache = new File(Configuration.DATA("OpenConfig.json"));
        ArrayList list = null;
        if (openConfigCache.exists()) {
            try (FileReader fileReader = new FileReader(openConfigCache);){
                list = (List)Grasscutter.getGsonFactory().fromJson((Reader)fileReader, TypeToken.getParameterized(Collection.class, new Type[]{OpenConfigEntry.class}).getType());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            String[] folderNames;
            TreeMap<String, OpenConfigEntry> map = new TreeMap<String, OpenConfigEntry>();
            Type type2 = new TypeToken<Map<String, OpenConfigData[]>>(){}.getType();
            for (String name : folderNames = new String[]{"BinOutput/Talent/EquipTalents/", "BinOutput/Talent/AvatarTalents/"}) {
                File folder = new File(Utils.toFilePath(Configuration.RESOURCE(name)));
                File[] files = folder.listFiles();
                if (files == null) {
                    Grasscutter.getLogger().error("Error loading open config: no files found in " + folder.getAbsolutePath());
                    return;
                }
                for (File file : files) {
                    Map config;
                    if (!file.getName().endsWith(".json")) continue;
                    try (FileReader fileReader = new FileReader(file);){
                        config = (Map)Grasscutter.getGsonFactory().fromJson((Reader)fileReader, type2);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    for (Map.Entry e : config.entrySet()) {
                        OpenConfigEntry entry = new OpenConfigEntry((String)e.getKey(), (OpenConfigData[])e.getValue());
                        map.put(entry.getName(), entry);
                    }
                }
            }
            list = new ArrayList(map.values());
        }
        if (list == null || list.isEmpty()) {
            Grasscutter.getLogger().error("No openconfig entries loaded!");
            return;
        }
        for (OpenConfigEntry entry : list) {
            GameData.getOpenConfigEntries().put(entry.getName(), entry);
        }
    }

    private static void loadQuests() {
        File folder = new File(Configuration.RESOURCE("BinOutput/Quest/"));
        if (!folder.exists()) {
            return;
        }
        for (File file : folder.listFiles()) {
            MainQuestData mainQuest = null;
            try (FileReader fileReader = new FileReader(file);){
                mainQuest = Grasscutter.getGsonFactory().fromJson((Reader)fileReader, MainQuestData.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            GameData.getMainQuestDataMap().put(mainQuest.getId(), mainQuest);
        }
        Grasscutter.getLogger().info("Loaded " + GameData.getMainQuestDataMap().size() + " MainQuestDatas.");
    }

    private static class AvatarConfig {
        public ArrayList<AvatarConfigAbility> abilities;

        private AvatarConfig() {
        }

        private static class AvatarConfigAbility {
            public String abilityName;

            private AvatarConfigAbility() {
            }

            public String toString() {
                return this.abilityName;
            }
        }
    }

    public static class OpenConfigData {
        public String $type;
        public String abilityName;
        public int talentIndex;
        public int skillID;
        public int pointDelta;
    }

    private static class OpenConfig {
        public OpenConfigData[] data;

        private OpenConfig() {
        }
    }
}

