/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.command.commands;

import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.utils.Language;
import emu.grasscutter.utils.Position;
import java.util.List;

@Command(label="teleport", usage="teleport <x> <y> <z> [scene id]", aliases={"tp"}, permission="player.teleport", permissionTargeted="player.teleport.others", description="commands.teleport.description")
public final class TeleportCommand
implements CommandHandler {
    private float parseRelative(String input, Float current) {
        if (input.contains("~")) {
            if (!input.equals("~")) {
                current = Float.valueOf(current.floatValue() + Float.parseFloat(input.replace("~", "")));
            }
        } else {
            current = Float.valueOf(Float.parseFloat(input));
        }
        return current.floatValue();
    }

    @Override
    public void execute(Player sender, Player targetPlayer, List<String> args2) {
        if (targetPlayer == null) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.execution.need_target", new Object[0]));
            return;
        }
        Position pos = targetPlayer.getPos();
        float x = pos.getX();
        float y = pos.getY();
        float z = pos.getZ();
        int sceneId = targetPlayer.getSceneId();
        switch (args2.size()) {
            case 4: {
                try {
                    sceneId = Integer.parseInt(args2.get(3));
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Language.translate(sender, "commands.execution.argument_error", new Object[0]));
                }
            }
            case 3: {
                try {
                    x = this.parseRelative(args2.get(0), Float.valueOf(x));
                    y = this.parseRelative(args2.get(1), Float.valueOf(y));
                    z = this.parseRelative(args2.get(2), Float.valueOf(z));
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Language.translate(sender, "commands.teleport.invalid_position", new Object[0]));
                }
                break;
            }
            default: {
                CommandHandler.sendMessage(sender, Language.translate(sender, "commands.teleport.usage", new Object[0]));
                return;
            }
        }
        Position target_pos = new Position(x, y, z);
        boolean result = targetPlayer.getWorld().transferPlayerToScene(targetPlayer, sceneId, target_pos);
        if (!result) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.teleport.invalid_position", new Object[0]));
        } else {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.teleport.success", targetPlayer.getNickname(), Float.toString(x), Float.toString(y), Float.toString(z), Integer.toString(sceneId)));
        }
    }
}

