/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.command.commands;

import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.data.GameData;
import emu.grasscutter.data.def.AvatarFetterLevelData;
import emu.grasscutter.game.avatar.Avatar;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.server.packet.send.PacketAvatarFetterDataNotify;
import emu.grasscutter.utils.Language;
import java.util.List;

@Command(label="setfetterlevel", usage="setfetterlevel <level>", aliases={"setfetterlvl", "setfriendship"}, permission="player.setfetterlevel", permissionTargeted="player.setfetterlevel.others", description="commands.setFetterLevel.description")
public final class SetFetterLevelCommand
implements CommandHandler {
    @Override
    public void execute(Player sender, Player targetPlayer, List<String> args2) {
        if (targetPlayer == null) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.execution.need_target", new Object[0]));
            return;
        }
        if (args2.size() != 1) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.setFetterLevel.usage", new Object[0]));
            return;
        }
        try {
            int fetterLevel = Integer.parseInt(args2.get(0));
            if (fetterLevel < 0 || fetterLevel > 10) {
                CommandHandler.sendMessage(sender, Language.translate(sender, "commands.setFetterLevel.range_error", new Object[0]));
                return;
            }
            Avatar avatar = targetPlayer.getTeamManager().getCurrentAvatarEntity().getAvatar();
            avatar.setFetterLevel(fetterLevel);
            if (fetterLevel != 10) {
                avatar.setFetterExp(((AvatarFetterLevelData)GameData.getAvatarFetterLevelDataMap().get(fetterLevel)).getExp());
            }
            avatar.save();
            targetPlayer.sendPacket(new PacketAvatarFetterDataNotify(avatar));
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.setFetterLevel.success", fetterLevel));
        }
        catch (NumberFormatException ignored) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.setFetterLevel.level_error", new Object[0]));
        }
    }
}

