/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.command.commands;

import emu.grasscutter.Grasscutter;
import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.database.DatabaseHelper;
import emu.grasscutter.game.mail.Mail;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.utils.Language;
import java.util.HashMap;
import java.util.List;

@Command(label="sendmail", usage="sendmail <userId|all|help> [templateId]", permission="server.sendmail", description="commands.sendMail.description")
public final class SendMailCommand
implements CommandHandler {
    private static final HashMap<Integer, MailBuilder> mailBeingConstructed = new HashMap();

    @Override
    public void execute(Player sender, Player targetPlayer, List<String> args2) {
        int senderId = sender != null ? sender.getUid() : -1;
        if (!mailBeingConstructed.containsKey(senderId)) {
            switch (args2.size()) {
                case 1: {
                    MailBuilder mailBuilder;
                    switch (args2.get(0).toLowerCase()) {
                        case "help": {
                            CommandHandler.sendMessage(sender, Language.translate(sender, this.getClass().getAnnotation(Command.class).description(), new Object[0]) + "\nUsage: " + this.getClass().getAnnotation(Command.class).usage());
                            return;
                        }
                        case "all": {
                            mailBuilder = new MailBuilder(true, new Mail());
                            break;
                        }
                        default: {
                            if (DatabaseHelper.getPlayerById(Integer.parseInt(args2.get(0))) != null) {
                                mailBuilder = new MailBuilder(Integer.parseInt(args2.get(0)), new Mail());
                                break;
                            }
                            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.sendMail.user_not_exist", args2.get(0)));
                            return;
                        }
                    }
                    mailBeingConstructed.put(senderId, mailBuilder);
                    CommandHandler.sendMessage(sender, Language.translate(sender, "commands.sendMail.start_composition", new Object[0]));
                    break;
                }
                case 2: {
                    CommandHandler.sendMessage(sender, Language.translate(sender, "commands.sendMail.templates", new Object[0]));
                    break;
                }
                default: {
                    CommandHandler.sendMessage(sender, Language.translate(sender, "commands.sendMail.invalid_arguments", new Object[0]));
                    break;
                }
            }
        } else {
            MailBuilder mailBuilder = mailBeingConstructed.get(senderId);
            if (args2.size() >= 1) {
                switch (args2.get(0).toLowerCase()) {
                    case "stop": {
                        mailBeingConstructed.remove(senderId);
                        CommandHandler.sendMessage(sender, Language.translate(sender, "commands.sendMail.sendCancel", new Object[0]));
                        return;
                    }
                    case "finish": {
                        if (mailBuilder.constructionStage == 3) {
                            if (!mailBuilder.sendToAll) {
                                Grasscutter.getGameServer().getPlayerByUid(mailBuilder.recipient, true).sendMail(mailBuilder.mail);
                                CommandHandler.sendMessage(sender, Language.translate(sender, "commands.sendMail.send_done", Integer.toString(mailBuilder.recipient)));
                            } else {
                                for (Player player : DatabaseHelper.getAllPlayers()) {
                                    Grasscutter.getGameServer().getPlayerByUid(player.getUid(), true).sendMail(mailBuilder.mail);
                                }
                                CommandHandler.sendMessage(sender, Language.translate(sender, "commands.sendMail.send_all_done", new Object[0]));
                            }
                            mailBeingConstructed.remove(senderId);
                        } else {
                            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.sendMail.not_composition_end", this.getConstructionArgs(mailBuilder.constructionStage, sender)));
                        }
                        return;
                    }
                    case "help": {
                        CommandHandler.sendMessage(sender, Language.translate(sender, "commands.sendMail.please_use", this.getConstructionArgs(mailBuilder.constructionStage, sender)));
                        return;
                    }
                }
                switch (mailBuilder.constructionStage) {
                    case 0: {
                        String title;
                        mailBuilder.mail.mailContent.title = title = String.join((CharSequence)" ", args2.subList(0, args2.size()));
                        CommandHandler.sendMessage(sender, Language.translate(sender, "commands.sendMail.set_title", title));
                        ++mailBuilder.constructionStage;
                        break;
                    }
                    case 1: {
                        String contents;
                        mailBuilder.mail.mailContent.content = contents = String.join((CharSequence)" ", args2.subList(0, args2.size()));
                        CommandHandler.sendMessage(sender, Language.translate(sender, "commands.sendMail.set_contents", contents));
                        ++mailBuilder.constructionStage;
                        break;
                    }
                    case 2: {
                        String msgSender;
                        mailBuilder.mail.mailContent.sender = msgSender = String.join((CharSequence)" ", args2.subList(0, args2.size()));
                        CommandHandler.sendMessage(sender, Language.translate(sender, "commands.sendMail.set_message_sender", msgSender));
                        ++mailBuilder.constructionStage;
                        break;
                    }
                    case 3: {
                        int item;
                        int lvl = 1;
                        int amount = 1;
                        int refinement = 0;
                        switch (args2.size()) {
                            case 4: {
                                try {
                                    refinement = Integer.parseInt(args2.get(3));
                                }
                                catch (NumberFormatException ignored) {
                                    CommandHandler.sendMessage(sender, Language.translate(sender, "commands.generic.invalid.itemRefinement", new Object[0]));
                                    return;
                                }
                            }
                            case 3: {
                                try {
                                    lvl = Integer.parseInt(args2.get(2));
                                }
                                catch (NumberFormatException ignored) {
                                    CommandHandler.sendMessage(sender, Language.translate(sender, "commands.generic.invalid.itemLevel", new Object[0]));
                                    return;
                                }
                            }
                            case 2: {
                                try {
                                    amount = Integer.parseInt(args2.get(1));
                                }
                                catch (NumberFormatException ignored) {
                                    CommandHandler.sendMessage(sender, Language.translate(sender, "commands.generic.invalid.amount", new Object[0]));
                                    return;
                                }
                            }
                            case 1: {
                                try {
                                    item = Integer.parseInt(args2.get(0));
                                    break;
                                }
                                catch (NumberFormatException ignored) {
                                    CommandHandler.sendMessage(sender, Language.translate(sender, "commands.generic.invalid.itemId", new Object[0]));
                                    return;
                                }
                            }
                            default: {
                                CommandHandler.sendMessage(sender, Language.translate(sender, "commands.give.usage", new Object[0]));
                                return;
                            }
                        }
                        mailBuilder.mail.itemList.add(new Mail.MailItem(item, amount, lvl));
                        CommandHandler.sendMessage(sender, Language.translate(sender, "commands.sendMail.send", Integer.toString(amount), Integer.toString(item), Integer.toString(lvl)));
                    }
                }
            } else {
                CommandHandler.sendMessage(sender, Language.translate(sender, "commands.sendMail.invalid_arguments_please_use", this.getConstructionArgs(mailBuilder.constructionStage, sender)));
            }
        }
    }

    private String getConstructionArgs(int stage, Player sender) {
        return switch (stage) {
            case 0 -> Language.translate(sender, "commands.sendMail.title", new Object[0]);
            case 1 -> Language.translate(sender, "commands.sendMail.message", new Object[0]);
            case 2 -> Language.translate(sender, "commands.sendMail.sender", new Object[0]);
            case 3 -> Language.translate(sender, "commands.sendMail.arguments", new Object[0]);
            default -> Language.translate(sender, "commands.sendMail.error", Integer.toString(stage));
        };
    }

    public static class MailBuilder {
        public int recipient;
        public boolean sendToAll;
        public int constructionStage;
        public Mail mail;

        public MailBuilder(int recipient, Mail mail) {
            this.recipient = recipient;
            this.sendToAll = false;
            this.constructionStage = 0;
            this.mail = mail;
        }

        public MailBuilder(boolean sendToAll, Mail mail) {
            if (sendToAll) {
                this.recipient = 0;
                this.sendToAll = true;
                this.constructionStage = 0;
                this.mail = mail;
            } else {
                Grasscutter.getLogger().error("Please use MailBuilder(int, mail) when not sending to all");
                Thread.dumpStack();
            }
        }
    }
}

