/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.command.commands;

import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.game.quest.GameQuest;
import emu.grasscutter.utils.Language;
import java.util.List;

@Command(label="quest", usage="quest <add|finish> [quest id]", permission="player.quest", permissionTargeted="player.quest.others", description="commands.quest.description")
public final class QuestCommand
implements CommandHandler {
    @Override
    public void execute(Player sender, Player targetPlayer, List<String> args2) {
        int questId;
        if (targetPlayer == null) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.execution.need_target", new Object[0]));
            return;
        }
        if (args2.size() != 2) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.quest.usage", new Object[0]));
            return;
        }
        String cmd = args2.get(0).toLowerCase();
        try {
            questId = Integer.parseInt(args2.get(1));
        }
        catch (Exception e) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.quest.invalid_id", new Object[0]));
            return;
        }
        switch (cmd) {
            case "add": {
                GameQuest quest = targetPlayer.getQuestManager().addQuest(questId);
                if (quest != null) {
                    CommandHandler.sendMessage(sender, Language.translate(sender, "commands.quest.added", questId));
                    return;
                }
                CommandHandler.sendMessage(sender, Language.translate(sender, "commands.quest.not_found", new Object[0]));
                break;
            }
            case "finish": {
                GameQuest quest = targetPlayer.getQuestManager().getQuestById(questId);
                if (quest == null) {
                    CommandHandler.sendMessage(sender, Language.translate(sender, "commands.quest.not_found", new Object[0]));
                    return;
                }
                quest.finish();
                CommandHandler.sendMessage(sender, Language.translate(sender, "commands.quest.finished", questId));
                break;
            }
            default: {
                CommandHandler.sendMessage(sender, Language.translate(sender, "commands.quest.usage", new Object[0]));
            }
        }
    }
}

