/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.command.commands;

import emu.grasscutter.Grasscutter;
import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.utils.Language;
import java.util.List;
import java.util.Map;

@Command(label="list", usage="list [uid]", aliases={"players"}, description="commands.list.description")
public final class ListCommand
implements CommandHandler {
    @Override
    public void execute(Player sender, Player targetPlayer, List<String> args2) {
        Map<Integer, Player> playersMap = Grasscutter.getGameServer().getPlayers();
        boolean needUID = false;
        if (args2.size() > 0) {
            needUID = args2.get(0).equals("uid");
        }
        CommandHandler.sendMessage(sender, Language.translate(sender, "commands.list.success", Integer.toString(playersMap.size())));
        if (playersMap.size() != 0) {
            StringBuilder playerSet = new StringBuilder();
            boolean finalNeedUID = needUID;
            playersMap.values().forEach(player -> {
                playerSet.append(player.getNickname());
                if (finalNeedUID) {
                    if (sender != null) {
                        playerSet.append(" <color=green>(").append(player.getUid()).append(")</color>");
                    } else {
                        playerSet.append(" (").append(player.getUid()).append(")");
                    }
                }
                playerSet.append(", ");
            });
            String players = playerSet.toString();
            CommandHandler.sendMessage(sender, players.substring(0, players.length() - 2));
        }
    }
}

