/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.command.commands;

import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.game.entity.EntityMonster;
import emu.grasscutter.game.entity.GameEntity;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.game.world.Scene;
import emu.grasscutter.utils.Language;
import java.util.List;

@Command(label="killall", usage="killall [sceneId]", permission="server.killall", permissionTargeted="server.killall.others", description="commands.kill.description")
public final class KillAllCommand
implements CommandHandler {
    @Override
    public void execute(Player sender, Player targetPlayer, List<String> args2) {
        if (targetPlayer == null) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.execution.need_target", new Object[0]));
            return;
        }
        Scene scene = targetPlayer.getScene();
        try {
            switch (args2.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    scene = targetPlayer.getWorld().getSceneById(Integer.parseInt(args2.get(0)));
                    break;
                }
                default: {
                    CommandHandler.sendMessage(sender, Language.translate(sender, "commands.kill.usage", new Object[0]));
                    return;
                }
            }
        }
        catch (NumberFormatException ignored) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.execution.argument_error", new Object[0]));
        }
        if (scene == null) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.kill.scene_not_found_in_player_world", new Object[0]));
            return;
        }
        Scene sceneF = scene;
        List<GameEntity> toKill = sceneF.getEntities().values().stream().filter(entity -> entity instanceof EntityMonster).toList();
        toKill.forEach(entity -> sceneF.killEntity((GameEntity)entity, 0));
        CommandHandler.sendMessage(sender, Language.translate(sender, "commands.kill.kill_monsters_in_scene", Integer.toString(toKill.size()), Integer.toString(scene.getId())));
    }
}

