/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.command.commands;

import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.command.CommandMap;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.utils.Language;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

@Command(label="help", usage="help [command]", description="commands.help.description")
public final class HelpCommand
implements CommandHandler {
    @Override
    public void execute(Player player, Player targetPlayer, List<String> args2) {
        if (args2.size() < 1) {
            HashMap<String, CommandHandler> handlers = CommandMap.getInstance().getHandlers();
            ArrayList<Command> annotations = new ArrayList<Command>();
            for (String key : handlers.keySet()) {
                Command annotation = handlers.get(key).getClass().getAnnotation(Command.class);
                if (Arrays.asList(annotation.aliases()).contains(key) || player != null && !Objects.equals(annotation.permission(), "") && !player.getAccount().hasPermission(annotation.permission())) continue;
                annotations.add(annotation);
            }
            this.SendAllHelpMessage(player, annotations);
        } else {
            String command = args2.get(0);
            CommandHandler handler = CommandMap.getInstance().getHandler(command);
            StringBuilder builder = new StringBuilder(player == null ? "\n" + Language.translate(player, "commands.status.help", new Object[0]) + " - " : Language.translate(player, "commands.status.help", new Object[0]) + " - ").append(command).append(": \n");
            if (handler == null) {
                builder.append(Language.translate(player, "commands.generic.command_exist_error", new Object[0]));
            } else {
                Command annotation = handler.getClass().getAnnotation(Command.class);
                builder.append("   ").append(Language.translate(player, annotation.description(), new Object[0])).append("\n");
                builder.append(Language.translate(player, "commands.help.usage", new Object[0])).append(annotation.usage());
                if (annotation.aliases().length >= 1) {
                    builder.append("\n").append(Language.translate(player, "commands.help.aliases", new Object[0]));
                    for (String alias : annotation.aliases()) {
                        builder.append(alias).append(" ");
                    }
                }
                if (player != null && !Objects.equals(annotation.permission(), "") && !player.getAccount().hasPermission(annotation.permission())) {
                    builder.append("\n Warning: You do not have permission to run this command.");
                }
            }
            CommandHandler.sendMessage(player, builder.toString());
        }
    }

    void SendAllHelpMessage(Player player, List<Command> annotations) {
        if (player == null) {
            StringBuilder builder = new StringBuilder("\n" + Language.translate(player, "commands.help.available_commands", new Object[0]) + "\n");
            annotations.forEach(annotation -> {
                builder.append(annotation.label()).append("\n");
                builder.append("   ").append(Language.translate(player, annotation.description(), new Object[0])).append("\n");
                builder.append(Language.translate(player, "commands.help.usage", new Object[0])).append(annotation.usage());
                if (annotation.aliases().length >= 1) {
                    builder.append("\n").append(Language.translate(player, "commands.help.aliases", new Object[0]));
                    for (String alias : annotation.aliases()) {
                        builder.append(alias).append(" ");
                    }
                }
                builder.append("\n");
            });
            CommandHandler.sendMessage(null, builder.toString());
        } else {
            CommandHandler.sendMessage(player, Language.translate(player, "commands.help.available_commands", new Object[0]));
            annotations.forEach(annotation -> {
                StringBuilder builder = new StringBuilder(annotation.label()).append("\n");
                builder.append("   ").append(Language.translate(player, annotation.description(), new Object[0])).append("\n");
                builder.append(Language.translate(player, "commands.help.usage", new Object[0])).append(annotation.usage());
                if (annotation.aliases().length >= 1) {
                    builder.append("\n").append(Language.translate(player, "commands.help.aliases", new Object[0]));
                    for (String alias : annotation.aliases()) {
                        builder.append(alias).append(" ");
                    }
                }
                CommandHandler.sendMessage(player, builder.toString());
            });
        }
    }
}

