/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.command.commands;

import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.data.GameData;
import emu.grasscutter.data.def.ItemData;
import emu.grasscutter.game.inventory.GameItem;
import emu.grasscutter.game.inventory.ItemType;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.game.props.ActionReason;
import emu.grasscutter.utils.Language;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Command(label="give", usage="give <itemId|itemName> [amount] [level]", aliases={"g", "item", "giveitem"}, permission="player.give", permissionTargeted="player.give.others", description="commands.give.description")
public final class GiveCommand
implements CommandHandler {
    Pattern lvlRegex = Pattern.compile("l(?:vl?)?(\\d+)");
    Pattern refineRegex = Pattern.compile("r(\\d+)");
    Pattern amountRegex = Pattern.compile("((?<=x)\\d+|\\d+(?=x)(?!x\\d))");

    private int matchIntOrNeg(Pattern pattern, String arg) {
        Matcher match2 = pattern.matcher(arg);
        if (match2.find()) {
            return Integer.parseInt(match2.group(1));
        }
        return -1;
    }

    @Override
    public void execute(Player sender, Player targetPlayer, List<String> args2) {
        int item;
        if (targetPlayer == null) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.execution.need_target", new Object[0]));
            return;
        }
        int lvl = 1;
        int amount = 1;
        int refinement = 0;
        for (int i2 = args2.size() - 1; i2 >= 0; --i2) {
            String arg = args2.get(i2).toLowerCase();
            boolean deleteArg = false;
            int argNum = this.matchIntOrNeg(this.lvlRegex, arg);
            if (argNum != -1) {
                lvl = argNum;
                deleteArg = true;
            }
            if ((argNum = this.matchIntOrNeg(this.refineRegex, arg)) != -1) {
                refinement = argNum;
                deleteArg = true;
            }
            if ((argNum = this.matchIntOrNeg(this.amountRegex, arg)) != -1) {
                amount = argNum;
                deleteArg = true;
            }
            if (!deleteArg) continue;
            args2.remove(i2);
        }
        switch (args2.size()) {
            case 4: {
                try {
                    refinement = Integer.parseInt(args2.get(3));
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Language.translate(sender, "commands.generic.invalid.itemRefinement", new Object[0]));
                    return;
                }
            }
            case 3: {
                try {
                    lvl = Integer.parseInt(args2.get(2));
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Language.translate(sender, "commands.generic.invalid.itemLevel", new Object[0]));
                    return;
                }
            }
            case 2: {
                try {
                    amount = Integer.parseInt(args2.get(1));
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Language.translate(sender, "commands.generic.invalid.amount", new Object[0]));
                    return;
                }
            }
            case 1: {
                try {
                    item = Integer.parseInt(args2.get(0));
                    break;
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Language.translate(sender, "commands.generic.invalid.itemId", new Object[0]));
                    return;
                }
            }
            default: {
                CommandHandler.sendMessage(sender, Language.translate(sender, "commands.give.usage", new Object[0]));
                return;
            }
        }
        ItemData itemData = (ItemData)GameData.getItemDataMap().get(item);
        if (itemData == null) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.generic.invalid.itemId", new Object[0]));
            return;
        }
        if (refinement != 0) {
            if (itemData.getItemType() == ItemType.ITEM_WEAPON) {
                if (refinement < 1 || refinement > 5) {
                    CommandHandler.sendMessage(sender, Language.translate(sender, "commands.give.refinement_must_between_1_and_5", new Object[0]));
                    return;
                }
            } else {
                CommandHandler.sendMessage(sender, Language.translate(sender, "commands.give.refinement_only_applicable_weapons", new Object[0]));
                return;
            }
        }
        this.item(targetPlayer, itemData, amount, lvl, refinement);
        if (!itemData.isEquip()) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.give.given", Integer.toString(amount), Integer.toString(item), Integer.toString(targetPlayer.getUid())));
        } else if (itemData.getItemType() == ItemType.ITEM_WEAPON) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.give.given_with_level_and_refinement", Integer.toString(item), Integer.toString(lvl), Integer.toString(refinement), Integer.toString(amount), Integer.toString(targetPlayer.getUid())));
        } else {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.give.given_level", Integer.toString(item), Integer.toString(lvl), Integer.toString(amount), Integer.toString(targetPlayer.getUid())));
        }
    }

    private void item(Player player, ItemData itemData, int amount, int lvl, int refinement) {
        if (itemData.isEquip()) {
            LinkedList<GameItem> items = new LinkedList<GameItem>();
            for (int i2 = 0; i2 < amount; ++i2) {
                GameItem item = new GameItem(itemData);
                if (item.isEquipped()) {
                    if (item.getItemType() == ItemType.ITEM_WEAPON) {
                        if (lvl > 90) {
                            lvl = 90;
                        }
                    } else if (lvl > 21) {
                        lvl = 21;
                    }
                }
                item.setCount(amount);
                item.setLevel(lvl);
                if (lvl > 80) {
                    item.setPromoteLevel(6);
                } else if (lvl > 70) {
                    item.setPromoteLevel(5);
                } else if (lvl > 60) {
                    item.setPromoteLevel(4);
                } else if (lvl > 50) {
                    item.setPromoteLevel(3);
                } else if (lvl > 40) {
                    item.setPromoteLevel(2);
                } else if (lvl > 20) {
                    item.setPromoteLevel(1);
                }
                if (item.getItemType() == ItemType.ITEM_WEAPON) {
                    if (refinement > 0) {
                        item.setRefinement(refinement - 1);
                    } else {
                        item.setRefinement(0);
                    }
                }
                items.add(item);
            }
            player.getInventory().addItems(items, ActionReason.SubfieldDrop);
        } else {
            GameItem item = new GameItem(itemData);
            item.setCount(amount);
            player.getInventory().addItem(item, ActionReason.SubfieldDrop);
        }
    }
}

