/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.command.commands;

import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.data.GameData;
import emu.grasscutter.data.def.AvatarData;
import emu.grasscutter.game.avatar.Avatar;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.utils.Language;
import java.util.List;

@Command(label="givechar", usage="givechar <avatarId> [level]", aliases={"givec"}, permission="player.givechar", permissionTargeted="player.givechar.others", description="commands.giveChar.description")
public final class GiveCharCommand
implements CommandHandler {
    @Override
    public void execute(Player sender, Player targetPlayer, List<String> args2) {
        int ascension;
        int avatarId;
        if (targetPlayer == null) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.execution.need_target", new Object[0]));
            return;
        }
        int level = 1;
        switch (args2.size()) {
            case 2: {
                try {
                    level = Integer.parseInt(args2.get(1));
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Language.translate(sender, "commands.execution.invalid.avatarLevel", new Object[0]));
                    return;
                }
            }
            case 1: {
                try {
                    avatarId = Integer.parseInt(args2.get(0));
                    break;
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Language.translate(sender, "commands.execution.invalid.avatarId", new Object[0]));
                    return;
                }
            }
            default: {
                CommandHandler.sendMessage(sender, Language.translate(sender, "commands.giveChar.usage", new Object[0]));
                return;
            }
        }
        AvatarData avatarData = (AvatarData)GameData.getAvatarDataMap().get(avatarId);
        if (avatarData == null) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.execution.invalid.avatarId", new Object[0]));
            return;
        }
        if (level > 90) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.execution.invalid.avatarLevel", new Object[0]));
            return;
        }
        if (level <= 40) {
            ascension = (int)Math.ceil((float)level / 20.0f) - 1;
        } else {
            ascension = (int)Math.ceil((float)level / 10.0f) - 3;
            ascension = Math.min(ascension, 6);
        }
        Avatar avatar = new Avatar(avatarId);
        avatar.setLevel(level);
        avatar.setPromoteLevel(ascension);
        avatar.recalcStats();
        targetPlayer.addAvatar(avatar);
        CommandHandler.sendMessage(sender, Language.translate(sender, "commands.giveChar.given", Integer.toString(avatarId), Integer.toString(level), Integer.toString(targetPlayer.getUid())));
    }
}

