/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.command.commands;

import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.data.GameData;
import emu.grasscutter.data.def.ItemData;
import emu.grasscutter.game.inventory.EquipType;
import emu.grasscutter.game.inventory.GameItem;
import emu.grasscutter.game.inventory.ItemType;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.game.props.ActionReason;
import emu.grasscutter.utils.Language;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Command(label="giveart", usage="giveart <artifactId> <mainPropId> [<appendPropId>[,<times>]]... [level]", aliases={"gart"}, permission="player.giveart", permissionTargeted="player.giveart.others", description="commands.giveArtifact.description")
public final class GiveArtifactCommand
implements CommandHandler {
    private static final Map<String, Map<EquipType, Integer>> mainPropMap = Map.ofEntries(Map.entry("hp", Map.ofEntries(Map.entry(EquipType.EQUIP_BRACER, 14001))), Map.entry("hp%", Map.ofEntries(Map.entry(EquipType.EQUIP_SHOES, 10980), Map.entry(EquipType.EQUIP_RING, 50980), Map.entry(EquipType.EQUIP_DRESS, 30980))), Map.entry("atk", Map.ofEntries(Map.entry(EquipType.EQUIP_NECKLACE, 12001))), Map.entry("atk%", Map.ofEntries(Map.entry(EquipType.EQUIP_SHOES, 10990), Map.entry(EquipType.EQUIP_RING, 50990), Map.entry(EquipType.EQUIP_DRESS, 30990))), Map.entry("def%", Map.ofEntries(Map.entry(EquipType.EQUIP_SHOES, 10970), Map.entry(EquipType.EQUIP_RING, 50970), Map.entry(EquipType.EQUIP_DRESS, 30970))), Map.entry("er", Map.ofEntries(Map.entry(EquipType.EQUIP_SHOES, 10960))), Map.entry("em", Map.ofEntries(Map.entry(EquipType.EQUIP_SHOES, 10950), Map.entry(EquipType.EQUIP_RING, 50880), Map.entry(EquipType.EQUIP_DRESS, 30930))), Map.entry("hb", Map.ofEntries(Map.entry(EquipType.EQUIP_DRESS, 30940))), Map.entry("cdmg", Map.ofEntries(Map.entry(EquipType.EQUIP_DRESS, 30950))), Map.entry("cr", Map.ofEntries(Map.entry(EquipType.EQUIP_DRESS, 30960))), Map.entry("phys%", Map.ofEntries(Map.entry(EquipType.EQUIP_RING, 50890))), Map.entry("dendro%", Map.ofEntries(Map.entry(EquipType.EQUIP_RING, 50900))), Map.entry("geo%", Map.ofEntries(Map.entry(EquipType.EQUIP_RING, 50910))), Map.entry("anemo%", Map.ofEntries(Map.entry(EquipType.EQUIP_RING, 50920))), Map.entry("hydro%", Map.ofEntries(Map.entry(EquipType.EQUIP_RING, 50930))), Map.entry("cryo%", Map.ofEntries(Map.entry(EquipType.EQUIP_RING, 50940))), Map.entry("electro%", Map.ofEntries(Map.entry(EquipType.EQUIP_RING, 50950))), Map.entry("pyro%", Map.ofEntries(Map.entry(EquipType.EQUIP_RING, 50960))));
    private static final Map<String, String> appendPropMap = Map.ofEntries(Map.entry("hp", "0102"), Map.entry("hp%", "0103"), Map.entry("atk", "0105"), Map.entry("atk%", "0106"), Map.entry("def", "0108"), Map.entry("def%", "0109"), Map.entry("er", "0123"), Map.entry("em", "0124"), Map.entry("cr", "0120"), Map.entry("cdmg", "0122"));

    private int getAppendPropId(String substatText, ItemData itemData) {
        try {
            int res = Integer.parseInt(substatText);
            return res;
        }
        catch (NumberFormatException numberFormatException) {
            int substatTier;
            String substatType;
            String[] substatArgs = substatText.split("_");
            if (substatArgs.length == 1) {
                substatType = substatArgs[0];
                substatTier = itemData.getRankLevel() == 1 ? 2 : (itemData.getRankLevel() == 2 ? 3 : 4);
            } else if (substatArgs.length == 2) {
                substatType = substatArgs[0];
                substatTier = Integer.parseInt(substatArgs[1]);
            } else {
                throw new IllegalArgumentException();
            }
            if (substatTier < 1 || substatTier > 4) {
                throw new IllegalArgumentException();
            }
            if (itemData.getRankLevel() == 1 && substatTier > 2) {
                throw new IllegalArgumentException();
            }
            if (itemData.getRankLevel() == 2 && substatTier > 3) {
                throw new IllegalArgumentException();
            }
            if (!appendPropMap.containsKey(substatType)) {
                throw new IllegalArgumentException();
            }
            return Integer.parseInt(Integer.toString(itemData.getRankLevel()) + appendPropMap.get(substatType) + Integer.toString(substatTier));
        }
    }

    @Override
    public void execute(Player sender, Player targetPlayer, List<String> args2) {
        int mainPropId;
        int itemId;
        if (targetPlayer == null) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.execution.need_target", new Object[0]));
            return;
        }
        if (args2.size() < 2) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.giveArtifact.usage", new Object[0]));
            return;
        }
        try {
            itemId = Integer.parseInt(args2.remove(0));
        }
        catch (NumberFormatException ignored) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.giveArtifact.id_error", new Object[0]));
            return;
        }
        ItemData itemData = (ItemData)GameData.getItemDataMap().get(itemId);
        if (itemData.getItemType() != ItemType.ITEM_RELIQUARY) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.giveArtifact.id_error", new Object[0]));
            return;
        }
        String mainPropIdString = args2.remove(0);
        try {
            mainPropId = Integer.parseInt(mainPropIdString);
        }
        catch (NumberFormatException ignored) {
            mainPropId = -1;
        }
        if (mainPropMap.containsKey(mainPropIdString) && mainPropMap.get(mainPropIdString).containsKey((Object)itemData.getEquipType())) {
            mainPropId = mainPropMap.get(mainPropIdString).get((Object)itemData.getEquipType());
        }
        if (mainPropId == -1) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.execution.argument_error", new Object[0]));
            return;
        }
        int level = 1;
        try {
            int last = Integer.parseInt(args2.get(args2.size() - 1));
            if (last > 0 && last < 22) {
                level = last;
                args2.remove(args2.size() - 1);
            }
        }
        catch (NumberFormatException last) {
            // empty catch block
        }
        ArrayList appendPropIdList = new ArrayList();
        try {
            args2.forEach(it -> {
                int n = 1;
                String[] arr = it.split(",");
                if (arr.length == 2) {
                    it = arr[0];
                    n = Integer.parseInt(arr[1]);
                    if (n > 200) {
                        n = 200;
                    }
                }
                int appendPropId = this.getAppendPropId((String)it, itemData);
                appendPropIdList.addAll(Collections.nCopies(n, appendPropId));
            });
        }
        catch (Exception ignored) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.execution.argument_error", new Object[0]));
            return;
        }
        GameItem item = new GameItem(itemData);
        item.setLevel(level);
        item.setMainPropId(mainPropId);
        item.getAppendPropIdList().clear();
        item.getAppendPropIdList().addAll(appendPropIdList);
        targetPlayer.getInventory().addItem(item, ActionReason.SubfieldDrop);
        CommandHandler.sendMessage(sender, Language.translate(sender, "commands.giveArtifact.success", Integer.toString(itemId), Integer.toString(targetPlayer.getUid())));
    }
}

