/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.command.commands;

import emu.grasscutter.Grasscutter;
import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.utils.Language;
import java.util.List;

@Command(label="coop", usage="coop [host UID]", permission="server.coop", permissionTargeted="server.coop.others", description="commands.coop.description")
public final class CoopCommand
implements CommandHandler {
    @Override
    public void execute(Player sender, Player targetPlayer, List<String> args2) {
        if (targetPlayer == null) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.execution.need_target", new Object[0]));
            return;
        }
        Player host = sender;
        switch (args2.size()) {
            case 0: {
                CommandHandler.sendMessage(sender, Language.translate(sender, "commands.coop.usage", new Object[0]));
                if (sender != null) break;
                return;
            }
            case 1: {
                try {
                    int hostId = Integer.parseInt(args2.get(0));
                    host = Grasscutter.getGameServer().getPlayerByUid(hostId);
                    if (host == null) {
                        CommandHandler.sendMessage(sender, Language.translate(sender, "commands.execution.player_offline_error", new Object[0]));
                        return;
                    }
                    break;
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Language.translate(sender, "commands.execution.uid_error", new Object[0]));
                    return;
                }
            }
            default: {
                CommandHandler.sendMessage(sender, Language.translate(sender, "commands.coop.usage", new Object[0]));
                return;
            }
        }
        if (targetPlayer.isInMultiplayer()) {
            targetPlayer.getServer().getMultiplayerManager().leaveCoop(targetPlayer);
        }
        host.getServer().getMultiplayerManager().applyEnterMp(targetPlayer, host.getUid());
        targetPlayer.getServer().getMultiplayerManager().applyEnterMpReply(host, targetPlayer.getUid(), true);
        CommandHandler.sendMessage(sender, Language.translate(sender, "commands.coop.success", targetPlayer.getNickname(), host.getNickname()));
    }
}

