/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.command.commands;

import emu.grasscutter.Grasscutter;
import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.database.DatabaseHelper;
import emu.grasscutter.game.Account;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.utils.Language;
import java.util.List;

@Command(label="account", usage="account <create|delete> <username> [uid]", description="commands.account.description")
public final class AccountCommand
implements CommandHandler {
    @Override
    public void execute(Player sender, Player targetPlayer, List<String> args2) {
        if (sender != null) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.generic.console_execute_error", new Object[0]));
            return;
        }
        if (args2.size() < 2) {
            CommandHandler.sendMessage(null, Language.translate(sender, "commands.account.command_usage", new Object[0]));
            return;
        }
        String action = args2.get(0);
        String username = args2.get(1);
        switch (action) {
            default: {
                CommandHandler.sendMessage(null, Language.translate(sender, "commands.account.command_usage", new Object[0]));
                return;
            }
            case "create": {
                Account account;
                int uid = 0;
                if (args2.size() > 2) {
                    try {
                        uid = Integer.parseInt(args2.get(2));
                    }
                    catch (NumberFormatException ignored) {
                        CommandHandler.sendMessage(null, Language.translate(sender, "commands.account.invalid", new Object[0]));
                        return;
                    }
                }
                if ((account = DatabaseHelper.createAccountWithId(username, uid)) == null) {
                    CommandHandler.sendMessage(null, Language.translate(sender, "commands.account.exists", new Object[0]));
                    return;
                }
                account.addPermission("*");
                account.save();
                CommandHandler.sendMessage(null, Language.translate(sender, "commands.account.create", Integer.toString(account.getPlayerUid())));
                return;
            }
            case "delete": 
        }
        Account toDelete = DatabaseHelper.getAccountByName(username);
        if (toDelete == null) {
            CommandHandler.sendMessage(null, Language.translate(sender, "commands.account.no_account", new Object[0]));
            return;
        }
        Player player = Grasscutter.getGameServer().getPlayerByUid(toDelete.getPlayerUid());
        if (player != null) {
            player.getSession().close();
        }
        DatabaseHelper.deleteAccount(toDelete);
        CommandHandler.sendMessage(null, Language.translate(sender, "commands.account.delete", new Object[0]));
    }
}

