/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.auth;

import emu.grasscutter.Configuration;
import emu.grasscutter.Grasscutter;
import emu.grasscutter.auth.AuthenticationSystem;
import emu.grasscutter.auth.Authenticator;
import emu.grasscutter.auth.ExternalAuthenticator;
import emu.grasscutter.database.DatabaseHelper;
import emu.grasscutter.game.Account;
import emu.grasscutter.server.http.objects.ComboTokenReqJson;
import emu.grasscutter.server.http.objects.ComboTokenResJson;
import emu.grasscutter.server.http.objects.LoginAccountRequestJson;
import emu.grasscutter.server.http.objects.LoginResultJson;
import emu.grasscutter.server.http.objects.LoginTokenRequestJson;
import emu.grasscutter.utils.Language;

public final class DefaultAuthenticators {

    public static class ExternalAuthentication
    implements ExternalAuthenticator {
        @Override
        public void handleLogin(AuthenticationSystem.AuthenticationRequest request) {
            assert (request.getResponse() != null);
            request.getResponse().send("Authentication is not available with the default authentication method.");
        }

        @Override
        public void handleAccountCreation(AuthenticationSystem.AuthenticationRequest request) {
            assert (request.getResponse() != null);
            request.getResponse().send("Authentication is not available with the default authentication method.");
        }

        @Override
        public void handlePasswordReset(AuthenticationSystem.AuthenticationRequest request) {
            assert (request.getResponse() != null);
            request.getResponse().send("Authentication is not available with the default authentication method.");
        }
    }

    public static class SessionKeyAuthenticator
    implements Authenticator<ComboTokenResJson> {
        @Override
        public ComboTokenResJson authenticate(AuthenticationSystem.AuthenticationRequest request) {
            boolean successfulLogin;
            ComboTokenResJson response = new ComboTokenResJson();
            ComboTokenReqJson requestData = request.getSessionKeyRequest();
            ComboTokenReqJson.LoginTokenData loginData = request.getSessionKeyData();
            assert (requestData != null);
            assert (loginData != null);
            String address = request.getRequest().ip();
            Account account = DatabaseHelper.getAccountById(loginData.uid);
            boolean bl = successfulLogin = account != null && account.getSessionKey().equals(loginData.token);
            if (successfulLogin) {
                response.message = "OK";
                response.data.open_id = account.getId();
                response.data.combo_id = "157795300";
                response.data.combo_token = account.generateLoginToken();
                Grasscutter.getLogger().info(Language.translate("messages.dispatch.account.combo_token_success", address));
            } else {
                response.retcode = -201;
                response.message = Language.translate("messages.dispatch.account.session_key_error", new Object[0]);
                Grasscutter.getLogger().info(Language.translate("messages.dispatch.account.combo_token_error", address));
            }
            return response;
        }
    }

    public static class TokenAuthenticator
    implements Authenticator<LoginResultJson> {
        @Override
        public LoginResultJson authenticate(AuthenticationSystem.AuthenticationRequest request) {
            boolean successfulLogin;
            LoginResultJson response = new LoginResultJson();
            LoginTokenRequestJson requestData = request.getTokenRequest();
            assert (requestData != null);
            String address = request.getRequest().ip();
            Grasscutter.getLogger().info(Language.translate("messages.dispatch.account.login_token_attempt", address));
            Account account = DatabaseHelper.getAccountById(requestData.uid);
            boolean bl = successfulLogin = account != null && account.getSessionKey().equals(requestData.token);
            if (successfulLogin) {
                response.message = "OK";
                response.data.account.uid = account.getId();
                response.data.account.token = account.getSessionKey();
                response.data.account.email = account.getEmail();
                Grasscutter.getLogger().info(Language.translate("messages.dispatch.account.login_token_success", address, requestData.uid));
            } else {
                response.retcode = -201;
                response.message = Language.translate("messages.dispatch.account.account_cache_error", new Object[0]);
                Grasscutter.getLogger().info(Language.translate("messages.dispatch.account.login_token_error", address));
            }
            return response;
        }
    }

    public static class PasswordAuthenticator
    implements Authenticator<LoginResultJson> {
        @Override
        public LoginResultJson authenticate(AuthenticationSystem.AuthenticationRequest request) {
            LoginResultJson response = new LoginResultJson();
            LoginAccountRequestJson requestData = request.getPasswordRequest();
            assert (requestData != null);
            boolean successfulLogin = false;
            String address = request.getRequest().ip();
            String responseMessage = Language.translate("messages.dispatch.account.username_error", new Object[0]);
            Account account = DatabaseHelper.getAccountByName(requestData.account);
            if (account == null && Configuration.ACCOUNT.autoCreate) {
                account = DatabaseHelper.createAccountWithId(requestData.account, 0);
                if (account == null) {
                    responseMessage = Language.translate("messages.dispatch.account.username_create_error", new Object[0]);
                    Grasscutter.getLogger().info(Language.translate("messages.dispatch.account.account_login_create_error", address));
                } else {
                    for (String permission : Configuration.ACCOUNT.defaultPermissions) {
                        account.addPermission(permission);
                    }
                    successfulLogin = true;
                    Grasscutter.getLogger().info(Language.translate("messages.dispatch.account.account_login_create_success", address, response.data.account.uid));
                }
            } else if (account != null) {
                successfulLogin = true;
            }
            if (successfulLogin) {
                response.message = "OK";
                response.data.account.uid = account.getId();
                response.data.account.token = account.generateSessionKey();
                response.data.account.email = account.getEmail();
                Grasscutter.getLogger().info(Language.translate("messages.dispatch.account.login_success", address, account.getId()));
            } else {
                response.retcode = -201;
                response.message = responseMessage;
                Grasscutter.getLogger().info(Language.translate("messages.dispatch.account.account_login_exist_error", address));
            }
            return response;
        }
    }
}

