/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.auth;

import emu.grasscutter.auth.Authenticator;
import emu.grasscutter.auth.ExternalAuthenticator;
import emu.grasscutter.server.http.objects.ComboTokenReqJson;
import emu.grasscutter.server.http.objects.ComboTokenResJson;
import emu.grasscutter.server.http.objects.LoginAccountRequestJson;
import emu.grasscutter.server.http.objects.LoginResultJson;
import emu.grasscutter.server.http.objects.LoginTokenRequestJson;
import express.http.Request;
import express.http.Response;
import javax.annotation.Nullable;

public interface AuthenticationSystem {
    public void createAccount(String var1, String var2);

    public void resetPassword(String var1);

    public boolean verifyUser(String var1);

    public Authenticator<LoginResultJson> getPasswordAuthenticator();

    public Authenticator<LoginResultJson> getTokenAuthenticator();

    public Authenticator<ComboTokenResJson> getSessionKeyAuthenticator();

    public ExternalAuthenticator getExternalAuthenticator();

    public static AuthenticationRequest fromPasswordRequest(Request request, LoginAccountRequestJson jsonData) {
        return AuthenticationRequest.builder().request(request).passwordRequest(jsonData).build();
    }

    public static AuthenticationRequest fromTokenRequest(Request request, LoginTokenRequestJson jsonData) {
        return AuthenticationRequest.builder().request(request).tokenRequest(jsonData).build();
    }

    public static AuthenticationRequest fromComboTokenRequest(Request request, ComboTokenReqJson jsonData, ComboTokenReqJson.LoginTokenData tokenData) {
        return AuthenticationRequest.builder().request(request).sessionKeyRequest(jsonData).sessionKeyData(tokenData).build();
    }

    public static AuthenticationRequest fromExternalRequest(Request request, Response response) {
        return AuthenticationRequest.builder().request(request).response(response).build();
    }

    public static class AuthenticationRequest {
        private final Request request;
        @Nullable
        private final Response response;
        @Nullable
        private final LoginAccountRequestJson passwordRequest;
        @Nullable
        private final LoginTokenRequestJson tokenRequest;
        @Nullable
        private final ComboTokenReqJson sessionKeyRequest;
        @Nullable
        private final ComboTokenReqJson.LoginTokenData sessionKeyData;

        public static AuthenticationRequestBuilder builder() {
            return new AuthenticationRequestBuilder();
        }

        public AuthenticationRequest(Request request, @Nullable Response response, @Nullable LoginAccountRequestJson passwordRequest, @Nullable LoginTokenRequestJson tokenRequest, @Nullable ComboTokenReqJson sessionKeyRequest, @Nullable ComboTokenReqJson.LoginTokenData sessionKeyData) {
            this.request = request;
            this.response = response;
            this.passwordRequest = passwordRequest;
            this.tokenRequest = tokenRequest;
            this.sessionKeyRequest = sessionKeyRequest;
            this.sessionKeyData = sessionKeyData;
        }

        public Request getRequest() {
            return this.request;
        }

        @Nullable
        public Response getResponse() {
            return this.response;
        }

        @Nullable
        public LoginAccountRequestJson getPasswordRequest() {
            return this.passwordRequest;
        }

        @Nullable
        public LoginTokenRequestJson getTokenRequest() {
            return this.tokenRequest;
        }

        @Nullable
        public ComboTokenReqJson getSessionKeyRequest() {
            return this.sessionKeyRequest;
        }

        @Nullable
        public ComboTokenReqJson.LoginTokenData getSessionKeyData() {
            return this.sessionKeyData;
        }

        public static class AuthenticationRequestBuilder {
            private Request request;
            private Response response;
            private LoginAccountRequestJson passwordRequest;
            private LoginTokenRequestJson tokenRequest;
            private ComboTokenReqJson sessionKeyRequest;
            private ComboTokenReqJson.LoginTokenData sessionKeyData;

            AuthenticationRequestBuilder() {
            }

            public AuthenticationRequestBuilder request(Request request) {
                this.request = request;
                return this;
            }

            public AuthenticationRequestBuilder response(@Nullable Response response) {
                this.response = response;
                return this;
            }

            public AuthenticationRequestBuilder passwordRequest(@Nullable LoginAccountRequestJson passwordRequest) {
                this.passwordRequest = passwordRequest;
                return this;
            }

            public AuthenticationRequestBuilder tokenRequest(@Nullable LoginTokenRequestJson tokenRequest) {
                this.tokenRequest = tokenRequest;
                return this;
            }

            public AuthenticationRequestBuilder sessionKeyRequest(@Nullable ComboTokenReqJson sessionKeyRequest) {
                this.sessionKeyRequest = sessionKeyRequest;
                return this;
            }

            public AuthenticationRequestBuilder sessionKeyData(@Nullable ComboTokenReqJson.LoginTokenData sessionKeyData) {
                this.sessionKeyData = sessionKeyData;
                return this;
            }

            public AuthenticationRequest build() {
                return new AuthenticationRequest(this.request, this.response, this.passwordRequest, this.tokenRequest, this.sessionKeyRequest, this.sessionKeyData);
            }

            public String toString() {
                return "AuthenticationSystem.AuthenticationRequest.AuthenticationRequestBuilder(request=" + this.request + ", response=" + this.response + ", passwordRequest=" + this.passwordRequest + ", tokenRequest=" + this.tokenRequest + ", sessionKeyRequest=" + this.sessionKeyRequest + ", sessionKeyData=" + this.sessionKeyData + ")";
            }
        }
    }
}

