/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query.experimental.filters;

import com.mongodb.client.model.geojson.Point;
import dev.morphia.mapping.Mapper;
import dev.morphia.query.experimental.filters.Filter;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

class PolygonFilter
extends Filter {
    private final Point[] points;

    PolygonFilter(String field, Point[] points) {
        super("$polygon", field, null);
        this.points = points;
    }

    @Override
    public void encode(Mapper mapper, BsonWriter writer, EncoderContext context) {
        writer.writeStartDocument(this.path(mapper));
        writer.writeStartDocument("$geoWithin");
        writer.writeStartArray("$polygon");
        for (Point point : this.points) {
            writer.writeStartArray();
            for (Double value : point.getPosition().getValues()) {
                writer.writeDouble(value);
            }
            writer.writeEndArray();
        }
        writer.writeEndArray();
        writer.writeEndDocument();
        writer.writeEndDocument();
    }
}

