/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query.experimental.filters;

import com.mongodb.client.model.geojson.CoordinateReferenceSystem;
import com.mongodb.client.model.geojson.MultiPolygon;
import com.mongodb.client.model.geojson.Polygon;
import dev.morphia.mapping.Mapper;
import dev.morphia.query.experimental.filters.Filter;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.EncoderContext;

public class GeoWithinFilter
extends Filter {
    private CoordinateReferenceSystem crs;

    GeoWithinFilter(String field, Polygon value) {
        super("$geoWithin", field, value);
    }

    GeoWithinFilter(String field, MultiPolygon value) {
        super("$geoWithin", field, value);
    }

    public GeoWithinFilter crs(CoordinateReferenceSystem crs) {
        this.crs = crs;
        return this;
    }

    @Override
    public final void encode(Mapper mapper, BsonWriter writer, EncoderContext context) {
        writer.writeStartDocument(this.path(mapper));
        writer.writeStartDocument(this.getName());
        writer.writeName("$geometry");
        Object shape = this.getValue();
        if (shape != null) {
            Codec<?> codec = mapper.getCodecRegistry().get(shape.getClass());
            codec.encode(writer, shape, context);
        }
        writer.writeEndDocument();
        writer.writeEndDocument();
    }
}

