/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.experimental;

import com.mongodb.DBRef;
import com.mongodb.lang.Nullable;
import dev.morphia.Datastore;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.MappingException;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import dev.morphia.mapping.experimental.MorphiaReference;
import dev.morphia.mapping.lazy.proxy.ReferenceException;
import dev.morphia.query.MorphiaCursor;
import dev.morphia.query.Query;
import dev.morphia.query.experimental.filters.Filters;
import dev.morphia.sofia.Sofia;
import java.util.List;
import java.util.Locale;
import org.bson.Document;

public class SingleReference<T>
extends MorphiaReference<T> {
    private EntityModel entityModel;
    private Object id;
    private T value;

    public SingleReference(Datastore datastore, EntityModel entityModel, Object id) {
        super(datastore);
        this.entityModel = entityModel;
        this.id = id;
        if (entityModel.getType().isInstance(id)) {
            this.value = id;
            PropertyModel idProperty = entityModel.getIdProperty();
            if (idProperty != null) {
                this.id = idProperty.getValue(this.value);
                this.resolve();
            } else {
                throw new MappingException(Sofia.noIdPropertyFound(entityModel.getType().getName(), new Locale[0]));
            }
        }
    }

    SingleReference(T value) {
        this.value = value;
    }

    public static MorphiaReference<?> decode(Datastore datastore, Mapper mapper, PropertyModel mappedField, Class<?> paramType, Document document) {
        EntityModel entityModel = mapper.getEntityModel(paramType);
        Object id = document.get(mappedField.getMappedName());
        return new SingleReference(datastore, entityModel, id);
    }

    @Override
    public T get() {
        if (!this.isResolved() && this.value == null && this.id != null) {
            this.value = ((MorphiaCursor)this.buildQuery().iterator()).tryNext();
            if (this.value == null && !this.ignoreMissing()) {
                throw new ReferenceException(Sofia.missingReferencedEntity(this.entityModel.getType().getSimpleName(), new Locale[0]));
            }
            this.resolve();
        }
        return this.value;
    }

    @Override
    public List<Object> getIds() {
        return List.of(this.getId());
    }

    @Override
    public Class<T> getType() {
        return this.entityModel.getType();
    }

    @Override
    Object getId(Mapper mapper, Datastore datastore, EntityModel fieldClass) {
        EntityModel entityModel;
        if (this.id == null && (entityModel = this.getEntityModel(mapper)) != null && entityModel.getIdProperty() != null) {
            this.id = entityModel.getIdProperty().getValue(this.get());
            if (!entityModel.equals(fieldClass)) {
                this.id = new DBRef(entityModel.getCollectionName(), this.id);
            }
        }
        if (this.id == null) {
            throw new ReferenceException(Sofia.noIdForReference(new Locale[0]));
        }
        return this.id;
    }

    private Object getId() {
        return this.id instanceof DBRef ? ((DBRef)this.id).getId() : this.id;
    }

    Query<?> buildQuery() {
        Query<Object> query = this.id instanceof DBRef ? this.getDatastore().find(this.getDatastore().getMapper().getClassFromCollection(((DBRef)this.id).getCollectionName())) : this.getDatastore().find(this.entityModel.getType());
        return query.filter(Filters.eq("_id", this.getId()));
    }

    @Nullable
    EntityModel getEntityModel(Mapper mapper) {
        T t;
        if (this.entityModel == null && (t = this.get()) != null) {
            this.entityModel = mapper.getEntityModel(t.getClass());
        }
        return this.entityModel;
    }
}

