/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.experimental;

import com.mongodb.lang.Nullable;
import dev.morphia.annotations.experimental.Name;
import dev.morphia.mapping.MappingException;
import dev.morphia.mapping.codec.MorphiaInstanceCreator;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import dev.morphia.sofia.Sofia;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;

public class ConstructorCreator
implements MorphiaInstanceCreator {
    private final Object[] parameters;
    private final Constructor<?> constructor;
    private final EntityModel model;
    private final Map<String, BiFunction<Object[], Object, Void>> positions = new LinkedHashMap<String, BiFunction<Object[], Object, Void>>();

    public ConstructorCreator(EntityModel model, Constructor<?> constructor) {
        this.model = model;
        this.constructor = constructor;
        this.constructor.setAccessible(true);
        Parameter[] constructorParameters = this.constructor.getParameters();
        this.parameters = new Object[constructorParameters.length];
        int i2 = 0;
        while (i2 < constructorParameters.length) {
            Parameter parameter = constructorParameters[i2];
            int finalI = i2++;
            String name = ConstructorCreator.getParameterName(parameter);
            if (name.matches("arg[0-9]+")) {
                throw new MappingException(Sofia.unnamedConstructorParameter(model.getType().getName(), new Locale[0]));
            }
            BiFunction<Object[], Object, Void> old = this.positions.put(name, (params, v) -> {
                params[finalI] = v;
                return null;
            });
            if (old == null) continue;
            throw new MappingException(Sofia.duplicatedParameterName(model.getType().getName(), name, new Locale[0]));
        }
    }

    public static Constructor<?> getFullConstructor(EntityModel model) {
        for (Constructor<?> constructor : model.getType().getDeclaredConstructors()) {
            if (constructor.getParameterCount() != model.getProperties().size() || !ConstructorCreator.namesMatchProperties(model, constructor)) continue;
            return constructor;
        }
        throw new MappingException(Sofia.noSuitableConstructor(model.getType().getName(), new Locale[0]));
    }

    public static String getParameterName(Parameter parameter) {
        Name name = parameter.getAnnotation(Name.class);
        return name != null ? name.value() : parameter.getName();
    }

    private static boolean namesMatchProperties(EntityModel model, Constructor<?> constructor) {
        for (Parameter parameter : constructor.getParameters()) {
            if (model.getProperty(ConstructorCreator.getParameterName(parameter)) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getInstance() {
        try {
            return this.constructor.newInstance(this.parameters);
        }
        catch (ReflectiveOperationException e) {
            throw new MappingException(Sofia.cannotInstantiate(this.model.getType().getName(), e.getMessage(), new Locale[0]));
        }
    }

    @Override
    public void set(@Nullable Object value, PropertyModel model) {
        this.positions.get(model.getName()).apply(this.parameters, value);
    }
}

