/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec.pojo;

import com.mongodb.DBRef;
import com.mongodb.lang.Nullable;
import dev.morphia.Datastore;
import dev.morphia.Key;
import dev.morphia.annotations.AlsoLoad;
import dev.morphia.annotations.Handler;
import dev.morphia.annotations.Reference;
import dev.morphia.mapping.MappingException;
import dev.morphia.mapping.codec.Conversions;
import dev.morphia.mapping.codec.MorphiaPropertySerialization;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.PropertyModelBuilder;
import dev.morphia.mapping.codec.pojo.TypeData;
import dev.morphia.mapping.codec.references.MorphiaProxy;
import dev.morphia.sofia.Sofia;
import java.beans.Transient;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.pojo.PropertyAccessor;

public final class PropertyModel {
    private final String name;
    private final TypeData<?> typeData;
    private final String mappedName;
    private Codec<? super Object> codec;
    private final PropertyAccessor<? super Object> accessor;
    private final MorphiaPropertySerialization serialization;
    private final Map<Class<? extends Annotation>, Annotation> annotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
    private final List<String> loadNames;
    private final EntityModel entityModel;
    private volatile Codec<? super Object> cachedCodec;
    private Class<?> normalizedType;

    PropertyModel(PropertyModelBuilder builder) {
        List<String> result;
        this.entityModel = builder.owner();
        this.name = Objects.requireNonNull(builder.name(), Sofia.notNull("name", new Locale[0]));
        this.mappedName = Objects.requireNonNull(builder.mappedName(), Sofia.notNull("name", new Locale[0]));
        this.typeData = Objects.requireNonNull(builder.typeData(), Sofia.notNull("typeData", new Locale[0]));
        this.accessor = builder.accessor();
        this.serialization = builder.serialization();
        builder.annotations().forEach(ann -> this.annotationMap.put(ann.annotationType(), (Annotation)ann));
        this.configureCodec(builder.datastore());
        AlsoLoad al = this.getAnnotation(AlsoLoad.class);
        if (al != null && al.value().length > 0) {
            ArrayList<String> names = new ArrayList<String>();
            names.add(this.getMappedName());
            names.addAll(Arrays.asList(al.value()));
            result = names;
        } else {
            result = Collections.singletonList(this.getMappedName());
        }
        this.loadNames = result;
    }

    static PropertyModelBuilder builder(Datastore datastore) {
        return new PropertyModelBuilder(datastore);
    }

    public String getFullName() {
        return String.format("%s#%s", this.entityModel.getType().getName(), this.name);
    }

    @Nullable
    public <A extends Annotation> A getAnnotation(Class<A> type2) {
        return (A)((Annotation)type2.cast(this.annotationMap.get(type2)));
    }

    public static Class<?> normalize(TypeData<?> toNormalize) {
        TypeData<?> typeData = toNormalize;
        while (!typeData.getTypeParameters().isEmpty()) {
            List<TypeData<?>> typeParameters = typeData.getTypeParameters();
            typeData = typeParameters.get(typeParameters.size() - 1);
        }
        Class<?> type2 = typeData.getType();
        while (type2.isArray()) {
            type2 = type2.getComponentType();
        }
        return type2;
    }

    public PropertyAccessor<? super Object> getAccessor() {
        return this.accessor;
    }

    @Nullable
    public Object getValue(Object instance) {
        Object target = instance;
        if (target instanceof MorphiaProxy) {
            target = ((MorphiaProxy)instance).unwrap();
        }
        return this.accessor.get(target);
    }

    @Nullable
    public Codec<? super Object> getCachedCodec() {
        return this.cachedCodec;
    }

    @Nullable
    public Codec<?> getCodec() {
        return this.codec;
    }

    public Object getDocumentValue(Document document) {
        return document.get(this.loadFromDocument(document));
    }

    public EntityModel getEntityModel() {
        return this.entityModel;
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getTypeData(), this.getMappedName(), this.getCodec(), this.getAccessor(), this.serialization, this.annotationMap.values(), this.getCachedCodec(), this.getNormalizedType());
    }

    public List<String> getLoadNames() {
        return this.loadNames;
    }

    public String getMappedName() {
        return this.mappedName;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getNormalizedType() {
        if (this.normalizedType == null) {
            this.normalizedType = PropertyModel.normalize(this.getTypeData());
        }
        return this.normalizedType;
    }

    public Class<?> getType() {
        return this.getTypeData().getType();
    }

    public TypeData<?> getTypeData() {
        return this.typeData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PropertyModel)) {
            return false;
        }
        PropertyModel that = (PropertyModel)o;
        return this.getName().equals(that.getName()) && this.getTypeData().equals(that.getTypeData()) && this.getMappedName().equals(that.getMappedName()) && Objects.equals(this.getCodec(), that.getCodec()) && this.getAccessor().equals(that.getAccessor()) && this.serialization.equals(that.serialization) && Objects.equals(this.getCachedCodec(), that.getCachedCodec()) && Objects.equals(this.getNormalizedType(), that.getNormalizedType());
    }

    public boolean hasAnnotation(Class<? extends Annotation> type2) {
        return this.annotationMap.containsKey(type2);
    }

    public String toString() {
        return new StringJoiner(", ", PropertyModel.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("mappedName='" + this.mappedName + "'").add("typeData=" + this.typeData).add("annotations=" + this.annotationMap.values()).toString();
    }

    public void setValue(Object instance, @Nullable Object value) {
        this.accessor.set(instance, Conversions.convert(value, this.getType()));
    }

    private void configureCodec(Datastore datastore) {
        Handler handler = this.getHandler();
        if (handler != null) {
            try {
                this.codec = handler.value().getDeclaredConstructor(Datastore.class, PropertyModel.class).newInstance(datastore, this);
            }
            catch (ReflectiveOperationException e) {
                throw new MappingException(e.getMessage(), e);
            }
        }
    }

    public boolean isArray() {
        return this.getType().isArray();
    }

    public boolean isMap() {
        return Map.class.isAssignableFrom(this.getTypeData().getType());
    }

    public boolean isMultipleValues() {
        return !this.isScalarValue();
    }

    public boolean isReference() {
        return this.hasAnnotation(Reference.class) || Key.class == this.getType() || DBRef.class == this.getType();
    }

    public boolean isScalarValue() {
        return !this.isMap() && !this.isArray() && !this.isCollection();
    }

    public boolean isSet() {
        return Set.class.isAssignableFrom(this.getTypeData().getType());
    }

    public boolean isTransient() {
        return !this.hasAnnotation(dev.morphia.annotations.Transient.class) && !this.hasAnnotation(Transient.class) && Modifier.isTransient(this.getType().getModifiers());
    }

    @Nullable
    private Handler getHandler() {
        Handler handler = this.typeData.getType().getAnnotation(Handler.class);
        if (handler == null && (handler = (Handler)this.annotationMap.values().stream().filter(a -> a.getClass().equals(Handler.class)).findFirst().orElse(null)) == null) {
            Iterator<Annotation> iterator2 = this.annotationMap.values().iterator();
            while (handler == null && iterator2.hasNext()) {
                handler = iterator2.next().annotationType().getAnnotation(Handler.class);
            }
        }
        return handler;
    }

    public boolean shouldSerialize(@Nullable Object value) {
        return this.serialization.shouldSerialize(value);
    }

    private boolean isCollection() {
        return Collection.class.isAssignableFrom(this.getTypeData().getType());
    }

    @Nullable
    private String loadFromDocument(Document document) {
        String propertyName = this.getMappedName();
        if (document.containsKey(propertyName)) {
            return propertyName;
        }
        for (String name : this.getLoadNames()) {
            if (!document.containsKey(name)) continue;
            return name;
        }
        return null;
    }

    void cachedCodec(Codec<? super Object> codec) {
        this.cachedCodec = codec;
    }
}

